<?php
// For Production Only
// ussage:
// check first if class is exists
// if ( class_exists( 'Brayn_Core_Sass_Production' ) )
// call the construct: new Brayn_Core_Sass_Production( sass_file_path, css_file_path, $unique_mod_control );
require BRAYN_CORE_PATH . '/inc/scss-inc/scss.inc.php';
use Leafo\ScssPhp\Compiler;

if ( ! class_exists( 'Brayn_Core_Sass_Production' ) ) {

	class Brayn_Core_Sass_Production {
		var $scss = false;
		var $sass_file = false;
		var $css_file = false;
		var $include_path = false;
		var $mod_control = false;

		/** construction */
		public function __construct( $sass_path = null, $css_path = null, $include_path = null, $version_control = null ) {
			if ( empty( $sass_path) || empty( $css_path ) || empty( $include_path ) || empty( $version_control ) ) {
				return false;
			}
			$this->sass_file = $sass_path;
			$this->css_file = $css_path;
			$this->mod_control = $version_control;
			$this->include_path = $include_path;

			$this->scss = new Compiler();
			$this->init();
		}
		
		/** init */
		public function init() {
			$this->compile_sass();
		}

		public function compile_sass() {
			$latest_modified_time = filemtime( $this->sass_file );

			if ( $latest_modified_time !== get_theme_mod( $this->mod_control ) ) {
				$this->write_css( $latest_modified_time );
			}
		}

		private function write_css( $latest_modified_time ) {
			$this->scss->setImportPaths( $this->include_path );
			$this->scss->setFormatter( 'Leafo\ScssPhp\Formatter\Nested' );
			$content = $this->get_contents( $this->sass_file );
			if ( $content ) {
				$compiled_css = $this->scss->compile( $content );
				$this->put_contents( $this->css_file, $compiled_css );

				set_theme_mod( $this->mod_control, $latest_modified_time );
			}
		}

		public function core_create_path( $path ) {
			// use WP_Filesystem
			if ( ! function_exists( 'WP_Filesystem' ) ) {
				require_once( ABSPATH . 'wp-admin/includes/file.php' );
			}

			WP_Filesystem();
			global $wp_filesystem;
			if ( ! $wp_filesystem->is_dir( $path ) ) {
				$wp_filesystem->mkdir( $path );
			}
		}

		public function get_mtime( $file = null ) {
			// use WP_Filesystem
			if ( ! function_exists( 'WP_Filesystem' ) ) {
				require_once( ABSPATH . 'wp-admin/includes/file.php' );
			}
			
			WP_Filesystem();
			global $wp_filesystem;
			if ( ! $wp_filesystem->is_file( $file ) ) {
				return false;
			}

			return $wp_filesystem->mtime( $file );
		}

		public function get_contents( $file ) {
			// use WP_Filesystem
			if ( ! function_exists( 'WP_Filesystem' ) ) {
				require_once( ABSPATH . 'wp-admin/includes/file.php' );
			}
			
			WP_Filesystem();
			global $wp_filesystem;
			if ( ! $wp_filesystem->is_file( $file ) ) {
				return false;
			}

			return $wp_filesystem->get_contents( $file );
		}

		public function put_contents( $file, $content ) {
			// use WP_Filesystem
			if ( ! function_exists( 'WP_Filesystem' ) ) {
				require_once( ABSPATH . 'wp-admin/includes/file.php' );
			}
			
			WP_Filesystem();
			global $wp_filesystem;

			$fs_chmod_file = ( fileperms( ABSPATH . 'index.php' ) & 0777 | 0644 );
			if ( defined('FS_CHMOD_FILE') ) {
				$fs_chmod_file = FS_CHMOD_FILE;
			}

			if ( ! $wp_filesystem->put_contents( $file, $content, $fs_chmod_file ) ) {
				return false;
			}

			return true;
		}
	}
}

// production only.
//if ( class_exists( 'Brayn_Core_Sass_Production' ) ) {
//	$GLOBALS['solehacss_site']  = new Brayn_Core_Sass_Production( get_parent_theme_file_path( '/assets/scss/site.scss' ), get_parent_theme_file_path( '/assets/css/site.css' ), get_parent_theme_file_path( '/assets/scss/' ), '_99css_base_modified_time' );
//	$GLOBALS['solehacss_color'] = new Brayn_Core_Sass_Production( get_parent_theme_file_path( '/assets/scss/color.scss' ), get_parent_theme_file_path( '/assets/css/default-color.css' ), get_parent_theme_file_path( '/assets/scss/' ), '_99css_color_modified_time' );
//}
