<?php
/**
 * custom elementor Circle progress
 *
 * @package Elementor
 * @subpackage Brayn Core
 * @since 1.0
 */

/**
 * Elementor button Widget.
 *
 * @since 1.0.0
 */
class Brayn_Elementor_Circle_Progress_Widget extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		$name = 'brayn-circle-progress';
		return $name;
	}

	/**
	 * Get widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Circle Counter', 'brayn-core' );
	}

	/**
	 * Get widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-counter-circle';
	}

	/**
	 * Get widget categories.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'brayn-theme' ];
	}

	/**
	 * Get sizes.
	 *
	 * Retrieve an array of sizes.
	 *
	 * @since 1.0.0
	 * @access public
	 * @static
	 *
	 * @return array An array containing sizes.
	 */
	public static function get_circle_sizes() {
		return [
			'medium' => __( 'Default', 'brayn-core' ),
			'small'  => __( 'Small', 'brayn-core' ),
			'big'    => __( 'Large', 'brayn-core' ),
		];
	}

	/**
	 * Register widget controls.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function _register_controls() {

		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__( 'Settings', 'brayn-core' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'size',
			[
				'label' => esc_html__( 'Size', 'brayn-core' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'medium',
				'options' => self::get_circle_sizes(),
				'style_transfer' => true,
			]
		);

		$this->add_control(
			'progress',
			[
				'label' => esc_html__( 'Percentage', 'brayn-core' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'default' => [
					'unit' => '%',
					'size' => 50,
				],
				'dynamic' => [
					'active' => true,
				],
				'label_block' => true,
			]
		);

		$this->add_control(
			'circle_color',
			[
				'label' => esc_html__( 'Color', 'elementor' ),
				'type' => \Elementor\Controls_Manager::COLOR,
			]
		);

		$this->add_control(
			'circle_bg',
			[
				'label' => esc_html__( 'Background Color', 'elementor' ),
				'type' => \Elementor\Controls_Manager::COLOR,
			]
		);

		$this->add_control(
			'label_text',
			[
				'label' => esc_html__( 'Label', 'brayn-core' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'input_type' => 'text',
				'placeholder' => '',
				'default' => esc_html__( 'Programming', 'brayn-core' ),
			]
		);

		$this->end_controls_section();
	}

	/**
	 * Render widget output on the frontend.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();

		$progress_percentage = is_numeric( $settings['progress']['size'] ) ? $settings['progress']['size'] : '0';
		if ( 100 < $progress_percentage ) {
			$progress_percentage = 100;
		}

		$this->add_render_attribute( 'circle_wrap', 'class', 'br-circle-progress' );
		$json_data = '{"percent":"'.$progress_percentage.'","background":"'.$settings['circle_bg'].'","color":"'.$settings['circle_color'].'","size":"'.$settings['size'].'"}';

		$this->add_render_attribute( 'circle_wrap', 'data-progress', $json_data );

		print '<div class="text-center">' . "\n";
		print '<div ' . $this->get_render_attribute_string( 'circle_wrap' ) . '></div>';
		if ( isset( $settings['label_text'] ) && ! empty( $settings['label_text'] ) ) {
			print '<strong>' . $settings['label_text'] . '</strong>' . "\n";
		}
		print '</div>' . "\n";
	}
}
