<?php
/**
 * Custom elementor testimonial slide widget
 *
 * @package    Elementor
 * @subpackage Brayn_Core
 * @since      1.0
 */

/**
 * Elementor Testimonial Slide Widget.
 *
 * @since 1.0.0
 */
class Brayn_Elementor_Testimonial_Slide_Widget extends \Elementor\Widget_Base
{

	/**
	 * Get widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		$name = 'brayn-testislide';
		return $name;
	}

	/**
	 * Get widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Testimonial Slide', 'brayn-core' );
	}

	/**
	 * Get widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-testimonial-carousel';
	}

	/**
	 * Get widget categories.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'brayn-theme' ];
	}

	/**
	 * Register widget controls.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function _register_controls() {

		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__( 'Testimonials', 'brayn-core' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'testi_name',
			[
				'label'       => __( 'Client Name', 'brayn-core' ),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'default'     => '',
				'label_block' => true,
			]
		);

		$repeater->add_control(
			'testi_business_lvl',
			[
				'label'       => __( 'Client Business Info', 'brayn-core' ),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'default'     => '',
				'label_block' => true,
				'description' => esc_html__( 'e.g. CEO of Google', 'brayn-core' ),
			]
		);

		$repeater->add_control(
			'testi_avatar',
			[
				'label'       => __( 'Client Picture/Avatar', 'brayn-core' ),
				'type'        => \Elementor\Controls_Manager::MEDIA,
				'default'     => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
				'description' => esc_html__( 'Please use a square image.', 'brayn-core' ),
			]
		);

		$repeater->add_control(
			'testi_content',
			[
				'label'      => __( 'Testimonial Content', 'brayn-core' ),
				'type'       => \Elementor\Controls_Manager::WYSIWYG,
				'default'    => esc_html__( 'Please enter the testimonial content', 'brayn-core' ),
				'show_label' => false,
			]
		);

		$this->add_control(
			'testi',
			[
				'label'  => __( 'Testimonials', 'brayn-core' ),
				'type'   => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'testi_name' => esc_html__( 'John Due', 'brayn-core' ),
						'testi_business_lvl' => esc_html__( 'ThemeForest Author', 'brayn-core' ),
						'testi_content' => esc_html__( 'Testimonial content. Click the edit button to change this text.', 'brayn-core' ),
					],
				],
				'title_field' => '{{{ testi_name }}}',
				'show_label' => false,
			]
		);

		$this->end_controls_section();
	}

	/**
	 * Render widget output on the frontend.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();

		if ( $settings['testi'] ) {
			?>
			<div class="testimonial-carousel-contain swiper-container">
				<div class="swiper-wrapper">

				<?php
					foreach( $settings['testi'] as $item ) {
						print '<div class="swiper-slide">' . "\n";
						print '<figure class="br-testimonial">' . "\n";
							print '<blockquote>' . stripslashes( $item['testi_content'] ) . '</blockquote>' . "\n";

							print '<img class="testimonial-person" src="' . $item['testi_avatar']['url'] . '" alt="" />' . "\n";
							print '<figcaption><cite>' . $item['testi_name'] . '</cite>' . "\n";
							print $item['testi_business_lvl'] . '</figcaption>' . "\n";
						print '</figure>' . "\n";
						print '</div>' . "\n";
					}
					unset( $item );
				?>
				</div>

				<!-- Prev / Next button -->
				<div class="testimonial-carousel-buttons">
					<div class="testimonial-carousel-btn-prev">
						<svg class="svg-icon" viewBox="0 0 20 20">
							<path d="M18.271,9.212H3.615l4.184-4.184c0.306-0.306,0.306-0.801,0-1.107c-0.306-0.306-0.801-0.306-1.107,0
							L1.21,9.403C1.194,9.417,1.174,9.421,1.158,9.437c-0.181,0.181-0.242,0.425-0.209,0.66c0.005,0.038,0.012,0.071,0.022,0.109
							c0.028,0.098,0.075,0.188,0.142,0.271c0.021,0.026,0.021,0.061,0.045,0.085c0.015,0.016,0.034,0.02,0.05,0.033l5.484,5.483
							c0.306,0.307,0.801,0.307,1.107,0c0.306-0.305,0.306-0.801,0-1.105l-4.184-4.185h14.656c0.436,0,0.788-0.353,0.788-0.788
							S18.707,9.212,18.271,9.212z"></path>
						</svg>
					</div>
					<div class="testimonial-carousel-btn-next">
						<svg class="svg-icon" viewBox="0 0 20 20">
							<path d="M1.729,9.212h14.656l-4.184-4.184c-0.307-0.306-0.307-0.801,0-1.107c0.305-0.306,0.801-0.306,1.106,0
							l5.481,5.482c0.018,0.014,0.037,0.019,0.053,0.034c0.181,0.181,0.242,0.425,0.209,0.66c-0.004,0.038-0.012,0.071-0.021,0.109
							c-0.028,0.098-0.075,0.188-0.143,0.271c-0.021,0.026-0.021,0.061-0.045,0.085c-0.015,0.016-0.034,0.02-0.051,0.033l-5.483,5.483
							c-0.306,0.307-0.802,0.307-1.106,0c-0.307-0.305-0.307-0.801,0-1.105l4.184-4.185H1.729c-0.436,0-0.788-0.353-0.788-0.788
							S1.293,9.212,1.729,9.212z"></path>
						</svg>
					</div>
				</div>
			</div>
			<?php
		}
	}
}
