<?php
/**
 * Some helper functions
 *
 * @since 1.0
 * @author WIP-Themes
 */

/**
 * Check post featured by ID
 *
 * @return bool
 */
function wip_themes_post_is_featured( $post_id = false ) {
	if ( ! $post_id ) {
		return false;
	}

	$val = get_post_meta( $post_id, '_wip_themes_featured', true );
	$featured = ( $val === "1" ) ? true : false;

	return $featured;
}

/**
 * Create path
 *
 * @use WP_Filesystem
 * @return bool
 */
function brayn_core_create_path( $path ) {
	// use WP_Filesystem
	if ( ! function_exists( 'WP_Filesystem' ) ) {
		require_once( ABSPATH . 'wp-admin/includes/file.php' );
	}

	WP_Filesystem();
	global $wp_filesystem;
	if ( ! $wp_filesystem->is_dir( $path ) ) {
		$wp_filesystem->mkdir( $path );
	}
}

/**
 * Write to file, use for refresh the custom css or editor style css
 *
 * @use WP_Filesystem
 * @return bool
 */
function brayn_core_write_to_file( $file = '', $content = '' ) {
	// use WP_Filesystem
	if ( ! function_exists( 'WP_Filesystem' ) ) {
		require_once( ABSPATH . 'wp-admin/includes/file.php' );
	}
	
	WP_Filesystem();
	global $wp_filesystem;

	$fs_chmod_file = ( fileperms( ABSPATH . 'index.php' ) & 0777 | 0644 );
	if ( defined('FS_CHMOD_FILE') ) {
		$fs_chmod_file = FS_CHMOD_FILE;
	}

	if ( ! $wp_filesystem->put_contents( $file, $content, $fs_chmod_file ) ) {
		return false;
	}

	return true;
}

if ( ! function_exists( 'brayn_core_get_tax_lists' ) ) {
	/**
	 * get the taxonomy lists, mostly used in theme option as select option values
	 * @param $taxonomy = taxonomy name @default 'category'
	 *
	 * @access public
	 * @return html select field
	 */
	function brayn_core_get_tax_lists( $taxonomy = 'category', $name = '', $id = '', $class = 'postform', $show_option_all = '', $selected = 0, $walker = "", $custom_args = array() ){
		$args = array(
			'show_option_all' => $show_option_all,
			'hide_empty'	=> 0, 
			'name' 			=> $name,
			'id'			=>  ( $id == "" ) ? $name : $id,
			'class'			=> $class,
			'hierarchical' 	=> true,
			'taxonomy'		=> $taxonomy,
			'selected'		=> $selected,
			'echo'			=> 0,
			'walker'		=> $walker
			);

		if ( ! empty( $custom_args ) ) {
			foreach( $custom_args as $name => $value ) {
				$args[$name] = $value;
			}
			unset( $name );
		}
		//var_dump($args);
		$options = 	wp_dropdown_categories($args);

		$options = str_replace('&nbsp;&nbsp;&nbsp;', "&mdash; ", $options);
		return $options;
	}
}

if ( ! function_exists( 'brayn_core_taxonomies_options' ) ) {
	function brayn_core_taxonomies_options( $taxonomy = 'category', $use_slug = false ) {
		$categories = get_categories( array(
			'taxonomy' => $taxonomy,
		) );

		$options = array();
		$options['all'] = esc_html__( 'All categories', 'brayn-core' );
		if ( ! empty( $categories ) ) {
			foreach( $categories as $cat ) {
				if ( $use_slug ) {
					$options[ $cat->slug ] = $cat->name;
				} else {
					$options[ $cat->term_id ] = $cat->name;
				}
			}
			unset( $cat );
		}

		return $options;
	}
}

function brayn_core_custom_paginate_links( $args = array() ) {
	$args = wp_parse_args(
		$args, array(
			'base' => str_replace( 999999999, '%#%', esc_url( get_pagenum_link( 999999999 ) ) ),
			'format' => '?paged=%#%',
			'total' => 1,
			'current' => 0,
			'show_all' => false,
			'end_size' => 1,
			'mid_size' => 2,
			'prev_next' => true,
			'prev_text' => esc_html__( 'Previous page', 'brayn-core' ),
			'next_text' => esc_html__( 'Next page', 'brayn-core' ),
			'type' => 'plain',
			'add_args' => false,
			'add_fragment' => '',
			'before_page_number' => '',
			'after_page_number' => ''
		)
	);

	return paginate_links( $args );
}

function the_brayn_core_custom_paginate_links( $args = array() ) {
	$paging = brayn_core_custom_paginate_links( $args );
	if ( $paging ) {
		print '<nav class="navigation pagination"><div class="nav-links">' . $paging . '</div></nav>';
	}
}

/**
 * Get the google fonts from the API or in the cache
 *
 * @param  integer $amount
 * @return String
 */
function brayn_core_get_google_fonts( $amount = 30 ) {
	$directory = BRAYN_CORE_PATH;
	$fontFile = $directory . '/cache/google-web-fonts.txt';

	//Total time the file will be cached in seconds, set to a week
	$cachetime = 86400 * 7;

	if ( ! function_exists( 'WP_Filesystem' ) ) {
		require_once( ABSPATH . 'wp-admin/includes/file.php' );
	}

	WP_Filesystem();
	global $wp_filesystem;

	$fs_chmod_file = ( fileperms( ABSPATH . 'index.php' ) & 0777 | 0644 );
	if ( defined('FS_CHMOD_FILE') ) {
		$fs_chmod_file = FS_CHMOD_FILE;
	}

	$content = false;
	if ( file_exists( $fontFile ) ) {
		if ( $cachetime < filemtime($fontFile) ) {
			$fonts_data = $wp_filesystem->get_contents($fontFile);

			if ( $fonts_data ) {
				$content = json_decode( $fonts_data );
			} else {
				$googleApi = 'https://www.googleapis.com/webfonts/v1/webfonts?sort=popularity&key=AIzaSyCtHefEYoYwZRMUqF_EcYNBTFfPLsZFRE8';
				$fontContent = wp_remote_get( esc_url($googleApi) );

				$content = json_decode( $fontContent['body'] );
				if ( isset( $content->error ) ) {
					return false;
				}

				$wp_filesystem->put_contents( $fontFile, $fontContent['body'], $fs_chmod_file );
				
			}

		} else {
			$googleApi = 'https://www.googleapis.com/webfonts/v1/webfonts?sort=popularity&key=AIzaSyCtHefEYoYwZRMUqF_EcYNBTFfPLsZFRE8';
			$fontContent = wp_remote_get( esc_url($googleApi) );
			
			$content = json_decode( $fontContent['body'] );
			if ( isset( $content->error ) ) {
				$fonts_data = $wp_filesystem->get_contents($fontFile);
				$content = json_decode( $fonts_data );
			} else {
				$wp_filesystem->put_contents( $fontFile, $fontContent['body'], $fs_chmod_file );
			}
		}
	} else {
		$dir = $wp_filesystem->find_folder( $directory . "/cache" );
		$newfile = trailingslashit($dir) . "google-web-fonts.txt";

		$googleApi = 'https://www.googleapis.com/webfonts/v1/webfonts?sort=popularity&key=AIzaSyCtHefEYoYwZRMUqF_EcYNBTFfPLsZFRE8';
		$fontContent = wp_remote_get( esc_url($googleApi) );

		$content = json_decode( $fontContent['body'] );
		if ( isset( $content->error ) ) {
			$wp_filesystem->put_contents( trailingslashit($dir) . "google-error.txt", $fontContent['body'], $fs_chmod_file );
			return false;
		}		

		$wp_filesystem->put_contents( $newfile, $fontContent['body'], $fs_chmod_file );
	}

	if ( ! $content ) {
		return false;
	}

	if ( $amount == 'all' ) {
		return $content->items;
	} else {
		return array_slice( $content->items, 0, $amount );
	}
}

function brayn_core_elementor_in_edit_screen() {
	if ( ! defined( 'ELEMENTOR_VERSION' ) ) {
		return false;
	}

	if ( \Elementor\Plugin::$instance->preview->is_preview_mode() ) {
		return true;
	}
	return false;
}

function brayn_core_footer_add_jsid() {
	if ( ! brayn_core_elementor_in_edit_screen() ) {
		return false;
	}

	?>
<script>
jQuery( window ).on( 'elementor/frontend/init', function() {
	elementorFrontend.hooks.addAction( 'frontend/element_ready/portfolio-grid.default', function( $scope ) {
		jQuery(window).trigger("ElemPortoAdded");
	});
	elementorFrontend.hooks.addAction( 'frontend/element_ready/brayn-portfolio.default', function( $scope ) {
		jQuery(window).trigger("BraynPortoAdded");
	});
	elementorFrontend.hooks.addAction( 'frontend/element_ready/brayn-portfolio-slide.default', function( $scope ) {
		jQuery(window).trigger("BraynPSAdded");
	});
	elementorFrontend.hooks.addAction( 'frontend/element_ready/brayn-circle-progress.default', function( $scope ) {
		jQuery(window).trigger("BraynCircleAdded", [ $scope ]);
	});
	elementorFrontend.hooks.addAction( 'frontend/element_ready/brayn-carousel.default', function( $scope ) {
		jQuery(window).trigger("BraynPGSAdded", [ $scope ]);
	});
	elementorFrontend.hooks.addAction( 'frontend/element_ready/brayn-metro-gallery.default', function( $scope ) {
		jQuery(window).trigger("BraynMetroAdded", [ $scope ]);
	});
	elementorFrontend.hooks.addAction( 'frontend/element_ready/brayn-masonry-gallery.default', function( $scope ) {
		jQuery(window).trigger("BraynGalMasonryAdded", [ $scope ]);
	});
	elementorFrontend.hooks.addAction( 'frontend/element_ready/brayn-woo-slide.default', function( $scope ) {
		jQuery(window).trigger("BraynWooSliderAdded", [ $scope ]);
	});
});
</script>
	<?php
}
add_action( 'wp_footer', 'brayn_core_footer_add_jsid', 99 );

function brayn_core_blurr_the_image( $file ) {
	//header('Content-Type: image/png');
	$image = imagecreatefromjpeg($file);

    /* Get original image size */
    list($w, $h) = getimagesize($file);

    /* Create array with width and height of down sized images */
    $size = array(
    	'sm' => array(
    		'w' => intval($w/4),
    		'h' => intval($h/4),
    	),
    	'md'=> array(
    		'w' => intval($w/2),
    		'h' => intval($h/2),
    	),
    );                       

    /* Scale by 25% and apply Gaussian blur */
    $sm = imagecreatetruecolor( $size['sm']['w'], $size['sm']['h'] );
    imagecopyresampled( $sm, $image, 0, 0, 0, 0, $size['sm']['w'], $size['sm']['h'], $w, $h );

    for ( $x=1; $x <=40; $x++ ){
        imagefilter( $sm, IMG_FILTER_GAUSSIAN_BLUR, 999 );
    } 

    imagefilter( $sm, IMG_FILTER_SMOOTH, 99 );
    imagefilter( $sm, IMG_FILTER_BRIGHTNESS, 10 );        

    /* Scale result by 200% and blur again */
    $md = imagecreatetruecolor( $size['md']['w'], $size['md']['h'] );
    imagecopyresampled( $md, $sm, 0, 0, 0, 0, $size['md']['w'], $size['md']['h'], $size['sm']['w'], $size['sm']['h'] );
    imagedestroy($sm);

	for ( $x=1; $x <=25; $x++ ) {
		imagefilter( $md, IMG_FILTER_GAUSSIAN_BLUR, 999 );
	} 

    imagefilter( $md, IMG_FILTER_SMOOTH, 99 );
    imagefilter( $md, IMG_FILTER_BRIGHTNESS, 10 );        

	/* Scale result back to original size */
	imagecopyresampled( $image, $md, 0, 0, 0, 0, $w, $h, $size['md']['w'], $size['md']['h'] );
	imagedestroy( $md );  

	// Apply filters of upsized image if you wish, but probably not needed
	imagefilter($image, IMG_FILTER_GAUSSIAN_BLUR, 999 );      
	$opacity = 0.5;
	imagealphablending($image, false);
	imagesavealpha($image, true);
	$transparency = 1 - $opacity;
	imagefilter($image, IMG_FILTER_COLORIZE, 0,0,0,127*$transparency);

	imagepng($image, null, 9);
	imagedestroy($image);
}

function brayn_core_get_blurry_image( $post ) {
	$image_file = get_parent_theme_file_path( '/assets/images/portfolio-def-img.jpg' );
	if ( has_post_thumbnail() ) {
		$thumbnail_id = get_post_thumbnail_id( $post );

		$std_blurr = get_post_meta( $thumbnail_id, '_brayn_blur', true );

		if ( ! $std_blurr ) {
			$image_url = wp_get_attachment_image_url( $thumbnail_id, 'brayn-post-potrait' );
			$image_name = wp_basename( $image_url );
			$fullsize_path = get_attached_file( $thumbnail_id );
			$fullsize_name = wp_basename( $fullsize_path );

			$image_file = str_replace( $fullsize_name, $image_name, $fullsize_path );
			//error_log( $image_file );
			ob_start();
			brayn_core_blurr_the_image( $image_file );
			$std_blurr = ob_get_contents();
			ob_end_clean();

			$std_blurr = base64_encode($std_blurr);
			update_post_meta( $thumbnail_id, '_brayn_blur', $std_blurr );
		}

		print 'data:image/png;base64,' . $std_blurr;
	} else {
		$std_blurr = get_option( 'brayn_std_blur' );
		if ( ! $std_blurr ) {
			ob_start();
			brayn_core_blurr_the_image( $image_file );
			$std_blurr = ob_get_contents();
			ob_end_clean();

			$std_blurr = base64_encode($std_blurr);
			update_option( 'brayn_std_blur', $std_blurr );
		}
		print 'data:image/png;base64,' . $std_blurr;
	}
}

/**
 * Check WooCommerce status
 *
 * @since 2.0.0
 * @return bool
 */
function brayn_core_woo_active(){
	return class_exists( 'WooCommerce' );
}
