/**
 * A smooth 3D tilt javascript library forked from Tilt.js (jQuery version)
 * https://github.com/micku7zu/vanilla-tilt.js
 * Released under the MIT License
 */

function _instanceof(left, right) { if (right != null && typeof Symbol !== "undefined" && right[Symbol.hasInstance]) { return right[Symbol.hasInstance](left); } else { return left instanceof right; } }
function _classCallCheck(instance, Constructor) { if (!_instanceof(instance, Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }
var VanillaTilt=function(){"use strict";var e=function(){function e(t){var i=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};if(_classCallCheck(this,e),!_instanceof(t,Node))throw"Can't initialize VanillaTilt because "+t+" is not a Node.";this.width=null,this.height=null,this.left=null,this.top=null,this.transitionTimeout=null,this.updateCall=null,this.updateBind=this.update.bind(this),this.resetBind=this.reset.bind(this),this.element=t,this.settings=this.extendSettings(i),this.elementListener=this.getElementListener(),this.reverse=this.settings.reverse?-1:1,this.glare=this.isSettingTrue(this.settings.glare),this.glarePrerender=this.isSettingTrue(this.settings["glare-prerender"]),this.gyroscope=this.isSettingTrue(this.settings.gyroscope),this.glare&&this.prepareGlare(),this.addEventListeners()}return _createClass(e,[{key:"isSettingTrue",value:function(e){return""===e||!0===e||1===e}},{key:"getElementListener",value:function(){if(!this.settings||!this.settings["mouse-event-element"])return this.element;if("string"==typeof this.settings["mouse-event-element"]){var e=document.querySelector(this.settings["mouse-event-element"]);if(e)return e}return _instanceof(this.settings["mouse-event-element"],Node)?this.settings["mouse-event-element"]:void 0}},{key:"addEventListeners",value:function(){this.onMouseEnterBind=this.onMouseEnter.bind(this),this.onMouseMoveBind=this.onMouseMove.bind(this),this.onMouseLeaveBind=this.onMouseLeave.bind(this),this.onWindowResizeBind=this.onWindowResize.bind(this),this.onDeviceOrientationBind=this.onDeviceOrientation.bind(this),this.elementListener.addEventListener("mouseenter",this.onMouseEnterBind),this.elementListener.addEventListener("mousemove",this.onMouseMoveBind),this.elementListener.addEventListener("mouseleave",this.onMouseLeaveBind),this.glare&&window.addEventListener("resize",this.onWindowResizeBind),this.gyroscope&&window.addEventListener("deviceorientation",this.onDeviceOrientationBind)}},{key:"removeEventListeners",value:function(){this.elementListener.removeEventListener("mouseenter",this.onMouseEnterBind),this.elementListener.removeEventListener("mousemove",this.onMouseMoveBind),this.elementListener.removeEventListener("mouseleave",this.onMouseLeaveBind),this.gyroscope&&window.removeEventListener("deviceorientation",this.onDeviceOrientationBind),this.glare&&window.removeEventListener("resize",this.onWindowResizeBind)}},{key:"destroy",value:function(){clearTimeout(this.transitionTimeout),null!==this.updateCall&&cancelAnimationFrame(this.updateCall),this.reset(),this.removeEventListeners(),this.element.vanillaTilt=null,delete this.element.vanillaTilt,this.element=null}},{key:"onDeviceOrientation",value:function(e){if(null!==e.gamma&&null!==e.beta){this.updateElementPosition();var t=this.settings.gyroscopeMaxAngleX-this.settings.gyroscopeMinAngleX,i=this.settings.gyroscopeMaxAngleY-this.settings.gyroscopeMinAngleY,s=t/this.width,n=i/this.height,a=(e.gamma-this.settings.gyroscopeMinAngleX)/s,l=(e.beta-this.settings.gyroscopeMinAngleY)/n;null!==this.updateCall&&cancelAnimationFrame(this.updateCall),this.event={clientX:a+this.left,clientY:l+this.top},this.updateCall=requestAnimationFrame(this.updateBind)}}},{key:"onMouseEnter",value:function(){this.updateElementPosition(),this.element.style.willChange="transform",this.setTransition()}},{key:"onMouseMove",value:function(e){null!==this.updateCall&&cancelAnimationFrame(this.updateCall),this.event=e,this.updateCall=requestAnimationFrame(this.updateBind)}},{key:"onMouseLeave",value:function(){this.setTransition(),this.settings.reset&&requestAnimationFrame(this.resetBind)}},{key:"reset",value:function(){this.event={pageX:this.left+this.width/2,pageY:this.top+this.height/2},this.element&&this.element.style&&(this.element.style.transform="perspective(".concat(this.settings.perspective,"px) ")+"rotateX(0deg) rotateY(0deg) scale3d(1, 1, 1)"),this.glare&&(this.glareElement.style.transform="rotate(180deg) translate(-50%, -50%)",this.glareElement.style.opacity="0")}},{key:"getValues",value:function(){var e=(this.event.clientX-this.left)/this.width,t=(this.event.clientY-this.top)/this.height;return e=Math.min(Math.max(e,0),1),t=Math.min(Math.max(t,0),1),{tiltX:(this.reverse*(this.settings.max/2-e*this.settings.max)).toFixed(2),tiltY:(this.reverse*(t*this.settings.max-this.settings.max/2)).toFixed(2),percentageX:100*e,percentageY:100*t,angle:Math.atan2(this.event.clientX-(this.left+this.width/2),-(this.event.clientY-(this.top+this.height/2)))*(180/Math.PI)}}},{key:"updateElementPosition",value:function(){var e=this.element.getBoundingClientRect();this.width=this.element.offsetWidth,this.height=this.element.offsetHeight,this.left=e.left,this.top=e.top}},{key:"update",value:function(){var e=this.getValues();this.element.style.transform="perspective("+this.settings.perspective+"px) rotateX("+("x"===this.settings.axis?0:e.tiltY)+"deg) rotateY("+("y"===this.settings.axis?0:e.tiltX)+"deg) scale3d("+this.settings.scale+", "+this.settings.scale+", "+this.settings.scale+")",this.glare&&(this.glareElement.style.transform="rotate(".concat(e.angle,"deg) translate(-50%, -50%)"),this.glareElement.style.opacity="".concat(e.percentageY*this.settings["max-glare"]/100)),this.element.dispatchEvent(new CustomEvent("tiltChange",{detail:e})),this.updateCall=null}},{key:"prepareGlare",value:function(){if(!this.glarePrerender){var e=document.createElement("div");e.classList.add("js-tilt-glare");var t=document.createElement("div");t.classList.add("js-tilt-glare-inner"),e.appendChild(t),this.element.appendChild(e)}this.glareElementWrapper=this.element.querySelector(".js-tilt-glare"),this.glareElement=this.element.querySelector(".js-tilt-glare-inner"),this.glarePrerender||(Object.assign(this.glareElementWrapper.style,{position:"absolute",top:"0",left:"0",width:"100%",height:"100%",overflow:"hidden","pointer-events":"none"}),Object.assign(this.glareElement.style,{position:"absolute",top:"50%",left:"50%","pointer-events":"none","background-image":"linear-gradient(0deg, rgba(255,255,255,0) 0%, rgba(255,255,255,1) 100%)",width:"".concat(2*this.element.offsetWidth,"px"),height:"".concat(2*this.element.offsetWidth,"px"),transform:"rotate(180deg) translate(-50%, -50%)","transform-origin":"0% 0%",opacity:"0"}))}},{key:"updateGlareSize",value:function(){Object.assign(this.glareElement.style,{width:"".concat(2*this.element.offsetWidth),height:"".concat(2*this.element.offsetWidth)})}},{key:"onWindowResize",value:function(){this.updateGlareSize()}},{key:"setTransition",value:function(){var e=this;clearTimeout(this.transitionTimeout),this.element.style.transition=this.settings.speed+"ms "+this.settings.easing,this.glare&&(this.glareElement.style.transition="opacity ".concat(this.settings.speed,"ms ").concat(this.settings.easing)),this.transitionTimeout=setTimeout(function(){e.element.style.transition="",e.glare&&(e.glareElement.style.transition="")},this.settings.speed)}},{key:"extendSettings",value:function(e){var t={reverse:!1,max:35,perspective:1e3,easing:"cubic-bezier(.03,.98,.52,.99)",scale:1,speed:300,transition:!0,axis:null,glare:!1,"max-glare":1,"glare-prerender":!1,"mouse-event-element":null,reset:!0,gyroscope:!0,gyroscopeMinAngleX:-45,gyroscopeMaxAngleX:45,gyroscopeMinAngleY:-45,gyroscopeMaxAngleY:45},i={};for(var s in t)if(s in e)i[s]=e[s];else if(this.element.hasAttribute("data-tilt-"+s)){var n=this.element.getAttribute("data-tilt-"+s);try{i[s]=JSON.parse(n)}catch(t){i[s]=n}}else i[s]=t[s];return i}}],[{key:"init",value:function(t,i){_instanceof(t,Node)&&(t=[t]),_instanceof(t,NodeList)&&(t=[].slice.call(t)),_instanceof(t,Array)&&t.forEach(function(t){"vanillaTilt"in t||(t.vanillaTilt=new e(t,i))})}}]),e}();return"undefined"!=typeof document&&(window.VanillaTilt=e,e.init(document.querySelectorAll("[data-tilt]"))),e}();