<?php
/**
 * Customize control radio option with image
 *
 * @package Brayn
 * @since   1.0
 */

/**
 * UI Radio Image
 *
 * @since 1.0
 */
class Brayn_Customizer_Ui_Radio_Image extends WP_Customize_Control {
	/**
	 * Ui type
	 *
	 * @var string
	 * @since 1.0
	 */
	public $type = 'wip_themes_ui_radio_image';

	/**
	 * Class constructor
	 *
	 * @param object $manager WP_Customize_Control.
	 * @param mixed  $id      WP_Customize_Control.
	 * @param array  $args    WP_Customize_Control.
	 * @param array  $options WP_Customize_Control.
	 * @return void
	 */
	public function __construct( $manager, $id, $args = array(), $options = array() ) {
		parent::__construct( $manager, $id, $args );
	}

	/**
	 * Render the control's content.
	 */
	public function render_content() {
		if ( empty( $this->choices ) ) {
			return;
		}

		$name = '_customize-radio-' . $this->id;

		if ( ! empty( $this->label ) ) :
			?>
			<span class="customize-control-title"><?php echo esc_html( $this->label ); ?></span>
			<?php
		endif;
		if ( ! empty( $this->description ) ) :
			?>
			<span class="description customize-control-description"><?php echo esc_html( $this->description ); ?></span>
		<?php endif; ?>
			<span class="wipThemes_ui_toggle_radio_parent">
		<?php
		foreach ( $this->choices as $value => $label ) :
			?>
			<label class="wipThemes_ui_toggle_radio">
				<input type="radio" value="<?php echo esc_attr( $value ); ?>" name="<?php echo esc_attr( $name ); ?>" <?php $this->link(); ?> <?php checked( $this->value(), $value ); ?> />
				<?php echo '<img src="' . esc_url( $label ) . '" />'; ?>
			</label>
			<?php
		endforeach;
		?>
			</span>
		<?php
	}
}
