<?php
/**
 * Customize control toggle option
 *
 * @package Brayn
 * @since   1.0
 */

/**
 * UI Toggle
 *
 * @since 1.0
 */
class Brayn_Customizer_Ui_Toggle extends WP_Customize_Control {
	/**
	 * Ui type
	 *
	 * @var string
	 * @since 1.0
	 */
	public $type = 'wip_themes_ui_toggle';

	public $default_checked = '';

	/**
	 * Class constructor
	 *
	 * @param object $manager WP_Customize_Control.
	 * @param mixed  $id      WP_Customize_Control.
	 * @param array  $args    WP_Customize_Control.
	 * @param array  $options WP_Customize_Control.
	 * @return void
	 */
	public function __construct( $manager, $id, $args = array(), $options = array() ) {
		parent::__construct( $manager, $id, $args );
	}

	/**
	 * Render the control's content.
	 */
	public function render_content() {
		?>
		<label class="wipThemes_ui_toggle_parent">
			<input type="checkbox" value="<?php echo esc_attr( $this->default_checked ); ?>" <?php $this->link(); ?> <?php checked( $this->value(), $this->default_checked ); ?> />
			<span class="wipThemes_ui_toggle">
				<strong><?php echo esc_html( $this->label ); ?></strong>
			</span>
			<?php if ( ! empty( $this->description ) ) : ?>
				<span class="description customize-control-description"><?php echo esc_html( $this->description ); ?></span>
			<?php endif; ?>
		</label>

		<?php
	}
}
