<?php
/**
 * Helper functions and actions for woocommerce
 *
 * @package WordPress
 * @subpackage Brayn
 * @since 2.0.0
 */

// Remove breadcrumbs && Move to before title.
remove_action( 'woocommerce_before_main_content', 'woocommerce_breadcrumb', 20 );
add_action( 'brayn_woocommerce_before_title', 'woocommerce_breadcrumb', 10 );

// Moves cross-sell into after cart table
remove_action( 'woocommerce_cart_collaterals', 'woocommerce_cross_sell_display' );
add_action( 'woocommerce_after_cart_table', 'woocommerce_cross_sell_display', 10 );

/**
 * Get the shop archive layout
 *
 * @package    Brayn
 * @subpackage WooCommerce
 * @since      2.0.0
 */
function brayn_get_shop_layout() {
	$default = 'right-sidebar';
	$option = get_theme_mod( 'brayn_shop_layout', $default );

	return $option;	
}

/**
 * Get the shop archive layout
 *
 * @package    Brayn
 * @subpackage WooCommerce
 * @since      2.0.0
 */
function brayn_get_single_product_layout() {
	global $post;

	$default = 'right-sidebar';
	$option = get_post_meta( $post->ID, '_brayn_post_layout', true );
	if ( ! $option ) {
		$option = $default;
	}

	return $option;	
}

/**
 * Register custom metabox.
 * Need the core plugin to be active
 *
 * @return void
 */
function brayn_register_product_metabox() {
	if ( class_exists( 'Brayn_Core_Metabox' ) ) {
		$option = array(
			'id'        => 'brayn_post_metabox',
			'post_type' => 'product',
			'title'     => esc_html__( 'Additional Settings', 'brayn' ),
			'options'   => array(
				'_brayn_post_layout' => array(
					'type' => 'select',
					'args' => array(
						'id'          => '_brayn_post_layout',
						'label'       => esc_html__( 'Layout', 'brayn' ),
						'description' => '',
						'default'     => 'right-sidebar',
						'options'     => [
							'no-sidebar'    => esc_html__( 'Fullwidth', 'brayn' ),
							'left-sidebar'  => esc_html__( 'Left Sidebar', 'brayn' ),
							'right-sidebar' => esc_html__( 'Right Sidebar', 'brayn' ),
						],
					),
				),
			),
		);

		new Brayn_Core_Metabox( $option );
	}
}
add_action( 'init', 'brayn_register_product_metabox' );

/**
 * the top cart icon
 *
 * @package    Brayn
 * @subpackage WooCommerce
 * @since      2.0.0
 */
function brayn_woo_top_cart_icon() {
	if ( '' !== get_theme_mod( 'enable_top_cart', true ) || is_customize_preview() ) {
		$attr_style  = is_customize_preview() ? ( '' === get_theme_mod( 'enable_top_cart', true ) ? 'display:none;' : '' ) : '';
		$cart_count = WC()->cart->get_cart_contents_count();

		print '<div class="brayn-top-cart" style="' . esc_attr( $attr_style ) . '"><span class="brayn-top-cart-count">' . esc_html( $cart_count ) . '</span><a href="' . esc_url( wc_get_cart_url() ) . '">' . brayn_get_icon_svg( 'shopping_bag', 18 ) . '</a></div>';
	}
}
add_action( 'brayn_header_complementary_content', 'brayn_woo_top_cart_icon', 15 );

/**
 * the top cart user
 *
 * @package    Brayn
 * @subpackage WooCommerce
 * @since      2.0.0
 */
function brayn_woo_top_user_icon() {
	if ( '' !== get_theme_mod( 'enable_top_user', true ) || is_customize_preview() ) {
		$attr_style  = is_customize_preview() ? ( '' === get_theme_mod( 'enable_top_user', true ) ? 'display:none;' : '' ) : '';

		print '<a class="brayn-top-account" style="' . esc_attr( $attr_style ) . '" href="' . esc_url( get_permalink( get_option('woocommerce_myaccount_page_id') ) ) . '">' . brayn_get_icon_svg( 'person_alt', 18 ) . '</a>';
	}
}
add_action( 'brayn_header_complementary_content', 'brayn_woo_top_user_icon', 12 );

function brayn_woo_header_addtocart_fragments( $fragments ) {
	global $woocommerce;

	if ( '' !== get_theme_mod( 'enable_top_cart', true ) ) {
		ob_start();
		?>
		<span class="brayn-top-cart-count"><?php print esc_html( $woocommerce->cart->cart_contents_count ); ?></span>
		<?php
		$fragments['span.brayn-top-cart-count'] = ob_get_clean();
	}

	return $fragments;
}
add_filter( 'woocommerce_add_to_cart_fragments', 'brayn_woo_header_addtocart_fragments' );
