<?php
/**
 * The portfolio category template file
 *
 * @package		WordPress
 * @subpackage	Brayn
 * @since 		1.0
 */

get_header();
?>

<main id="main" class="main-contain">

	<header class="page-header">
		<div class="container">

			<h1 class="has-reveal-effect" data-effect="fadeInTop"><?php print single_term_title( "", false ); ?></h1>

			<?php the_archive_description( '<div class="lead br-font-normal pt-4 has-reveal-effect" data-effect="fadeInTop">', '</div>' ); ?>

		</div>
	</header>

	<div class="container">

		<article id="post-<?php the_ID(); ?>" <?php post_class( 'brayn-single-page' ); ?>>
			
			<div class="br-section brayn-the-content">

<?php
		if ( have_posts() ) :

			print '<div class="portfolio-grid-wrapper">' . "\n";
			print '<div class="portfolio-grid-lists">' . "\n";

			while ( have_posts() ) :
				the_post();

				get_template_part( 'template-parts/portfolio/loop', '' );

			endwhile;

			print '</div>' . "\n";

			the_posts_pagination( array(
				'prev_text' => '<svg style="enable-background:new 0 0 50 50;" viewBox="0 0 50 50"><g><polygon points="37.561,47.293 15.267,25 37.561,2.707 36.146,1.293 12.439,25 36.146,48.707"/></g></svg><span class="screen-reader-text">' . esc_html__( 'Previous page', 'brayn' ) . '</span>',
				'next_text' => '<span class="screen-reader-text">' . esc_html__( 'Next page', 'brayn' ) . '</span><svg style="enable-background:new 0 0 50 50;" viewBox="0 0 50 50"><g><polygon points="13.854,48.707 37.561,25 13.854,1.293 12.439,2.707 34.732,25 12.439,47.293"/></g></svg>',
				'before_page_number' => '<span class="meta-nav screen-reader-text">' . esc_html__( 'Page', 'brayn' ) . ' </span>',
			) );

			wp_reset_postdata();

			print '</div>' . "\n";

		else :

			get_template_part( 'template-parts/content', 'none' );

		endif;
?>
			</div>

		</article>

	</div>

</main>

<?php
get_footer();
