<?php
/**
 * no content founded
 *
 * @package brayn
 * @since 1.0
 */

?>

<div class="brayn__blank text-center">
	<h2 class="br-font-large"><?php print esc_html__( 'Whoops', 'brayn' ); ?></h2>
	
	<?php
	if ( is_home() && current_user_can( 'publish_posts' ) ) : ?>

		<p class="lead"><?php print esc_html__( 'Ready to publish your first post?', 'brayn' ); ?>
			<a href="<?php print esc_url( admin_url( 'post-new.php' ) ); ?>"><?php print esc_html__( 'Get started here', 'brayn' ); ?></a></p>

	<?php else : ?>

		<p class="lead"><?php esc_html_e( 'It seems we can&rsquo;t find what you&rsquo;re looking for. Perhaps searching can help.', 'brayn' ); ?></p>
		<div class="col-md-6 mx-auto"><?php get_search_form(); ?></div>

	<?php endif; ?>
</div>
