<?php
/**
 * Page layout, no sidebar
 *
 * @package brayn
 * @since 1.0
 */

global $post;
?>

<?php if ( ! is_front_page() && ! brayn_page_title_is_hidden( get_the_id() ) ) : ?>
	<header class="page-header">
		<div <?php brayn_page_title_container_classes(); ?>>
			<h1 class="has-reveal-effect" data-effect="fadeInTop"><?php the_title(); ?></h1>
			
			<?php if ( "" !== get_post_meta( get_the_ID(), '_brayn_page_subtitle', true ) ) { ?>
			<p class="lead br-font-normal has-reveal-effect" data-effect="fadeInTop">
				<?php print wp_kses_post( get_post_meta( get_the_ID(), '_brayn_page_subtitle', true ) ); ?>
			</p>
			<?php } ?>

		</div>
	</header>
<?php endif; ?>

<div class="container">

<?php
	while ( have_posts() ) :
		the_post();

		global $post;
?>
	<article id="post-<?php the_ID(); ?>" <?php post_class( 'brayn-single-page' ); ?>>
		
		<div class="br-section brayn-the-content">
			<?php
				if ( ! brayn_post_is_built_with_elementor( get_the_ID() ) ) {
					print '<div class="single-post-contain">' . "\n";
					print '<div class="post-content-contain">' . "\n";
				}

				the_content();

				wp_link_pages( array(
					'before'      => '<div class="page-links"><span class="screen-reader-text">' . esc_html__( 'Pages:', 'brayn' ) . '</span>',
					'after'       => '</div>',
					'link_before' => '<span class="page-number">',
					'link_after'  => '</span>',
				) );

				if ( ! brayn_post_is_built_with_elementor( get_the_ID() ) ) {
					print '</div>' . "\n";
					print '</div>' . "\n";
				}
			?>
		</div>	

	</article>

<?php
	// If comments are open or we have at least one comment, load up the comment template.
	if ( comments_open() || get_comments_number() ) {
		comments_template();
	}
	endwhile;
?>
</div>
<!-- .container -->
