<?php
/**
 * Default portfolio loop
 *
 * @package brayn
 * @since 1.0
 */

$show_category = true;
if ( isset( $GLOBALS['show_cat'] ) ) {
	$show_category = $GLOBALS['show_cat'] === "yes" ? true : false;
}
?>

<article id="portfolio-<?php the_ID(); ?>" <?php post_class( 'portfolio-grid-item' ); ?>>
	<div class="portfolio-grid-obj">
		<a href="<?php the_permalink(); ?>" class="portfolio-grid-link" rel="bookmark">
			<div class="entry-image">
				<?php print brayn_get_portfolio_cover_poster(); ?>
			</div>
			<header class="entry-header">
				<?php the_title( '<h3>', '</h3>'); ?>
				<?php if ( $show_category && brayn_get_portfolio_cat_lists( get_the_ID() ) ) { ?>
					<span class="portfolio-category"><?php print brayn_get_portfolio_cat_lists( get_the_ID() ); ?></span>
				<?php } ?>
			</header>
		</a>
	</div>
</article>
