<?php
/**
 * Archive layout, right sidebar
 *
 * @package brayn
 * @since 1.0
 */

do_action( 'brayn_before_post_loop' );
?>

<div class="br-section">

	<div class="container">

		<div class="row main-row">

			<div id="main-content-contain" class="col-lg-9 col-md-8">
<?php
if ( have_posts() ) :

	$paged = ( get_query_var('paged') ) ? get_query_var('paged') : 1;
	if ( $paged < 1 ) {
		$paged = 1;
	}

	if ( strpos( brayn_get_post_loop_style(), 'column') !== false ) {
		print '<div class="row';
		if ( 'column-minimal' === brayn_get_post_loop_style() ) {
			print esc_attr( ' no-gutters' );
		} else {
			print esc_attr( ' masonry-post' );
		}
		print '">' . "\n";
	}

	$i = ( intval( $paged ) < 2 ) ? ( brayn_show_first_post_as_featured() === 'no' ? 1 : 0 ) : 1;
	while ( have_posts() ) :
		the_post();

			if ( $i > 0 ) {
				get_template_part( 'template-parts/post/loop', brayn_get_post_loop_style() );
			}

		$i++;
	endwhile;

	if ( strpos( brayn_get_post_loop_style(), 'column') !== false ) {
		print '</div><!-- .row -->' . "\n";
	}

	unset( $i );

	the_posts_pagination( array(
		'prev_text' => '<svg style="enable-background:new 0 0 50 50;" viewBox="0 0 50 50"><g><polygon points="37.561,47.293 15.267,25 37.561,2.707 36.146,1.293 12.439,25 36.146,48.707"/></g></svg><span class="screen-reader-text">' . esc_html__( 'Previous page', 'brayn' ) . '</span>',
		'next_text' => '<span class="screen-reader-text">' . esc_html__( 'Next page', 'brayn' ) . '</span><svg style="enable-background:new 0 0 50 50;" viewBox="0 0 50 50"><g><polygon points="13.854,48.707 37.561,25 13.854,1.293 12.439,2.707 34.732,25 12.439,47.293"/></g></svg>',
		'before_page_number' => '<span class="meta-nav screen-reader-text">' . esc_html__( 'Page', 'brayn' ) . ' </span>',
	) );

	wp_reset_postdata();

else :

	get_template_part( 'template-parts/content', 'none' );

endif;
?>
			</div>
			<!-- #main-content-contain -->

			<?php get_sidebar(); ?>

		</div>
		<!-- .main-row -->

	</div>
	<!-- .container -->

</div>
<!-- .br-section -->

<?php
do_action( 'brayn_after_post_loop' );
