<?php
/**
 * post loop columns minimal
 *
 * @package brayn
 * @since 1.0
 */

$post_classes = array( 'br-post', 'br-post-grid-minimal' );
?>

<div class="col-md-4 mb-2 mb-md-0">
	<article id="post-<?php the_ID(); ?>" <?php post_class( $post_classes ); ?>>

		<div class="ui-post-grid-minimal d-flex align-items-center">
			<div class="d-block w-100">
				<header class="entry-header">
					<?php brayn_category_lists(); ?>
					<h4 class="entry-title"><a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>" rel="bookmark"><?php the_title(); ?></a></h4>
				</header>

				<footer class="entry-meta d-flex justify-content-between">
					<?php print brayn_get_post_author(); ?>
					<?php print brayn_option_time_link(); ?>
				</footer>
			</div>
		</div>

		<div class="post-grid-minimal-bg">
			<?php
			if ( has_post_thumbnail() ) {
				the_post_thumbnail( 'brayn-post-square' );
			}
			?>
		</div>

	</article>
</div>
