<?php
/**
 * The first loop item
 *
 * @package brayn
 * @since 1.0
 */

$center_div = has_post_thumbnail() ? '' : 'mx-auto';
?>

<article id="post-<?php the_ID(); ?>" <?php post_class( 'brayn-first-post' ); ?>>

	<div class="container">
		<div class="d-flex align-items-center mx-auto">
			<div class="d-block px-4">
				<header class="entry-header">
					<?php brayn_category_lists(); ?>
					<h2 class="entry-title"><a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>" rel="bookmark"><?php the_title(); ?></a></h2>
				</header>

				<footer class="entry-meta text-center">
					<?php print brayn_get_post_author(); ?>
					<span class="meta-separator">/</span>
					<?php print brayn_option_time_link(); ?>
				</footer>
			</div>
		</div>
	</div>

	<div class="first-post-bg">	
	<?php if ( has_post_thumbnail() ) { ?>
		
			<?php the_post_thumbnail( 'full' ); ?>
		
	<?php } ?>
	</div>
</article>
