<?php
/**
 * Custom taxonomies (category) fields.
 *
 * @author WIP-Themes
 * @version 1.0
 */

// stop if theme request to not include these fields.
if ( 'yes' === get_option('wip_themes_core_no_custom_tax_fields') ) {
	return false;
}

function brayn_core_new_category_fields() {
	$term_layout     = '_brayn_core_term_layout';
	$term_post_style = '_brayn_core_term_listing_style';
	
	// defaults.
	$def_term_layout = get_theme_mod( 'brayn_index_layout', 'no-sidebar' );
	$def_post_style  = get_theme_mod( 'brayn_index_loop_style', 'column' );
	?>
<style>
.ce-image-radio-option .layout {
	float: left;
	margin: 0;
	padding: 0 10px 0 10px;
	width: 33.333333%;
	-webkit-box-sizing: border-box;
	-moz-box-sizing: border-box;
	box-sizing: border-box;
}
.ce-image-radio-option .layout:after {
	content: "";
	display: table;
	clear: both;
}
.ce-image-radio-option label {
	display: block;
	max-width: 136px;
	margin: 5px 0 15px;
	padding: 10px;
	position: relative;
	text-align: center;
	background-color: #f4f4f4;
	border: 1px solid #e6e6e6;
	-moz-border-radius: 4px;
	-khtml-border-radius: 4px;
	-webkit-border-radius: 4px;
	border-radius: 4px;
	-webkit-transition:   all 0.2s ease-out 0s;
	-moz-transition:      all 0.2s ease-out 0s;
	-o-transition:        all 0.2s ease-out 0s;
	transition:           all 0.2s ease-out 0s;
}
.ce-image-radio-option label:hover{
	background-color: #f9f9f9;
	box-shadow: 0 10px 15px -10px rgba(0,0,0, .3);
}
.ce-image-radio-option input {
	margin: 0 0 6px;
}
.ce-image-radio-option span {
	display: block;
	width: 100%;
	margin: 0px 0px 10px;
}
.ce-image-radio-option img {
	max-width: 100%;
	height: auto;
	margin: 0;
	padding: 0;
	display: inline-block;
}
</style>
	<div class="form-field">
		<label for="<?php echo esc_attr( $term_layout ); ?>"><?php esc_html_e( 'Layout', 'brayn-core' ); ?></label>
		<div class="ce-image-radio-option">
			<?php
				$layout_option = array(
					'no-sidebar' => array(
						'img'     => BRAYN_CORE_URL . '/assets/images/fullwidth.png',
						'default' => $def_term_layout,
					),
					'right-sidebar' => array(
						'img'     => BRAYN_CORE_URL . '/assets/images/content-sidebar.png',
						'default' => $def_term_layout,
					),
					'left-sidebar' => array(
						'img'     => BRAYN_CORE_URL . '/assets/images/sidebar-content.png',
						'default' => $def_term_layout,
					),
				);

				foreach( $layout_option as $val => $set ) {
					print '<div class="layout"><label class="description">';
					print '<span><img src="' . esc_url( $set['img'] ) . '" width="136" height="122" alt="" /></span>';
					print '<input type="radio" name="' . $term_layout . '" value="' . esc_attr( $val ) . '" ' . checked( $val, $set['default'], false ) . ' />';
					print '</label></div>';
				}
				unset( $val );
				unset( $set );

			?>
		</div>
	</div>
	<div class="form-field">
		<label for="<?php echo esc_attr( $term_post_style ); ?>"><?php esc_html_e( 'Post Listing Style', 'brayn-core' ); ?></label>
		<select name="<?php echo esc_attr( $term_post_style ); ?>">
			<?php
			$values = array(
				'column'         => esc_html__( 'Column', 'brayn-core' ),
				'column-minimal' => esc_html__( 'Column minimal', 'brayn-core' ),
				'staggered'      => esc_html__( 'Staggered', 'brayn-core' ),
				'classic'        => esc_html__( 'Classic', 'brayn-core' ),
			);

			foreach ( $values as $vid => $lbl ) {
				print '<option value="' . esc_attr( $vid ) . '" ' . selected( $vid, $def_post_style, false ) . '>' . esc_html( $lbl ) . '</option>' . "\n";
			}
			unset( $lbl );
			unset( $vid );
			?>
		</select>
	</div>
	<?php
}
add_action( 'category_add_form_fields', 'brayn_core_new_category_fields', 10, 2 );
add_action( 'post_tag_add_form_fields', 'brayn_core_new_category_fields', 10, 2 );

function brayn_core_edit_category_fields( $tag ) {
	// get term id.
	$term_id = $tag->term_id;

	// option names.
	$term_layout     = '_brayn_core_term_layout';
	$term_post_style = '_brayn_core_term_listing_style';

	// values.
	$term_layout_value     = get_term_meta( $term_id, $term_layout, true );
	$term_post_style_value = get_term_meta( $term_id, $term_post_style, true );

	// get defaults.
	if ( '' === $term_layout_value ) {
		$term_layout_value = get_theme_mod( 'brayn_index_layout', 'no-sidebar' );
	}
	if ( '' === $term_post_style_value ) {
		$term_post_style_value = get_theme_mod( 'brayn_index_loop_style', 'column' );
	}
	?>
<style>
.ce-image-radio-option .layout {
	float: left;
	margin: 0;
	padding: 0 10px 0 10px;
	width: 33.333333%;
	-webkit-box-sizing: border-box;
	-moz-box-sizing: border-box;
	box-sizing: border-box;
}
.ce-image-radio-option .layout:after {
	content: "";
	display: table;
	clear: both;
}
.ce-image-radio-option label {
	display: block;
	max-width: 136px;
	margin: 5px 0 15px;
	padding: 10px;
	position: relative;
	text-align: center;
	background-color: #f4f4f4;
	border: 1px solid #e6e6e6;
	-moz-border-radius: 4px;
	-khtml-border-radius: 4px;
	-webkit-border-radius: 4px;
	border-radius: 4px;
	-webkit-transition:   all 0.2s ease-out 0s;
	-moz-transition:      all 0.2s ease-out 0s;
	-o-transition:        all 0.2s ease-out 0s;
	transition:           all 0.2s ease-out 0s;
}
.ce-image-radio-option label:hover{
	background-color: #f9f9f9;
	box-shadow: 0 10px 15px -10px rgba(0,0,0, .3);
}
.ce-image-radio-option input {
	margin: 0 0 6px;
}
.ce-image-radio-option span {
	display: block;
	width: 100%;
	margin: 0px 0px 10px;
}
.ce-image-radio-option img {
	max-width: 100%;
	height: auto;
	margin: 0;
	padding: 0;
	display: inline-block;
}
</style>
	<tr class="form-field">
		<th scope="row" valign="top"><label for="<?php echo esc_attr( $term_layout ); ?>"><?php esc_html_e( 'Layout', 'brayn-core' ); ?></label></th>
		<td class="ce-image-radio-option">
			<?php
				$layout_option = array(
					'no-sidebar' => array(
						'img'     => BRAYN_CORE_URL . '/assets/images/fullwidth.png',
						'default' => $term_layout_value,
					),
					'right-sidebar' => array(
						'img'     => BRAYN_CORE_URL . '/assets/images/content-sidebar.png',
						'default' => $term_layout_value,
					),
					'left-sidebar' => array(
						'img'     => BRAYN_CORE_URL . '/assets/images/sidebar-content.png',
						'default' => $term_layout_value,
					),
				);

				foreach( $layout_option as $val => $set ) {
					print '<div class="layout"><label class="description">';
					print '<span><img src="' . esc_url( $set['img'] ) . '" width="136" height="122" alt="" /></span>';
					print '<input type="radio" name="' . $term_layout . '" value="' . esc_attr( $val ) . '" ' . checked( $val, $set['default'], false ) . ' />';
					print '</label></div>';
				}
				unset( $val );
				unset( $set );
			?>
		</td>
	</tr>
	<tr class="form-field">
		<th scope="row" valign="top"><label for="<?php echo esc_attr( $term_post_style ); ?>"><?php esc_html_e( 'Post listing style', 'brayn-core' ); ?></label></th>
		<td>
		<select name="<?php echo esc_attr( $term_post_style ); ?>">
			<?php
			$values = array(
				'column'         => esc_html__( 'Column', 'brayn-core' ),
				'column-minimal' => esc_html__( 'Column minimal', 'brayn-core' ),
				'staggered'      => esc_html__( 'Staggered', 'brayn-core' ),
				'classic'        => esc_html__( 'Classic', 'brayn-core' ),
			);

			foreach ( $values as $vid => $lbl ) {
				print '<option value="' . esc_attr( $vid ) . '" ' . selected( $vid, $term_post_style_value, false ) . '>' . esc_html( $lbl ) . '</option>' . "\n";
			}
			unset( $lbl );
			unset( $vid );
			?>
		</select>
		</td>
	</tr>
	<?php
}
add_action( 'edit_category_form_fields', 'brayn_core_edit_category_fields' );
add_action( 'post_tag_edit_form_fields', 'brayn_core_edit_category_fields' );

function brayn_core_save_custom_category_fields( $term_id, $taxonomy ) {
	// Options.
	$options = array( '_brayn_core_term_layout', '_brayn_core_term_listing_style' );
	foreach ( $options as $opt ) {
		if ( isset( $_POST[ $opt ] ) ) {
			$val = sanitize_text_field( $_POST[ $opt ] );
			update_term_meta( $term_id, $opt, $val );
		}
	}
	unset( $opt );
}
add_action( 'edited_category', 'brayn_core_save_custom_category_fields', 10, 2 );
add_action( 'create_category', 'brayn_core_save_custom_category_fields', 10, 2 );

add_action( 'edited_post_tag', 'brayn_core_save_custom_category_fields', 10, 2 );
add_action( 'create_post_tag', 'brayn_core_save_custom_category_fields', 10, 2 );
