<?php
/**
 * Scss compiler helper
 *
 * @since 1.0
 */

require BRAYN_CORE_PATH . '/inc/scss-inc/scss.inc.php';
use Leafo\ScssPhp\Compiler;

/**
 * Scss Compiler
 *
 * @since 1.0
 */
class Brayn_Core_Compiler_Scss {
	var $scss = false;
	var $include_path = false;
	var $precompiled_code = false;
	
	public function __construct( $scss_code = null, $include_path = null ) {
		if ( empty( $scss_code ) || empty( $include_path ) ) {
			return false;
		}

		$this->precompiled_code = $scss_code;
		$this->include_path = $include_path;
		$this->scss = new Compiler();
	}

	public function compile() {
		$this->scss->setImportPaths( $this->include_path );
		$this->scss->setFormatter( 'Leafo\ScssPhp\Formatter\Compressed' );
		// compile the code.
		$compiled_css = $this->scss->compile( $this->precompiled_code );
		return $compiled_css;
	}
}
