<?php
/**
 * custom elementor post column
 *
 * @package Elementor
 * @subpackage Brayn Core
 * @since 1.0
 */

/**
 * Elementor portfolio carousel Widget.
 *
 * @since 1.0.0
 */
class Brayn_Elementor_Post_Column_Widget extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		$name = 'brayn-post-column';
		return $name;
	}

	/**
	 * Get widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Latest Post Grid', 'brayn-core' );
	}

	/**
	 * Get widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-columns';
	}

	/**
	 * Get widget categories.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'brayn-theme' ];
	}

	/**
	 * Register widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function _register_controls() {

		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__( 'Settings', 'brayn-core' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_responsive_control(
			'post_col',
			[
				'label' => esc_html__( 'Column', 'brayn-core' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'col' => [
						'min' => 1,
						'max' => 4,
						'step' => 1,
					],
				],
				'devices' => [ 'desktop', 'tablet', 'mobile' ],
				'desktop_default' => [
					'size' => 3,
					'unit' => 'col',
				],
				'tablet_default' => [
					'size' => 2,
					'unit' => 'col',
				],
				'mobile_default' => [
					'size' => 2,
					'unit' => 'col',
				],
			]
		);

		$this->add_control(
			'number_post',
			[
				'label' => esc_html__( 'Number of post', 'brayn-core' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'input_type' => 'number',
				'placeholder' => '',
				'default' => 3,
			]
		);

		$this->add_control(
			'order_by',
			[
				'label' => esc_html__( 'Order by', 'brayn-core' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'date',
				'description' => '',
				'options' => [
					'ID'    => esc_html__( 'Post ID', 'brayn-core' ),
					'date'  => esc_html__( 'Post date', 'brayn-core' ),
					'title' => esc_html__( 'Post title', 'brayn-core' ),
					'rand'  => esc_html__( 'Random order', 'brayn-core' ),
				],
			]
		);

		$this->add_control(
			'order',
			[
				'label' => esc_html__( 'Order', 'brayn-core' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'DESC',
				'description' => '',
				'options' => [
					'ASC'  => esc_html__( 'Ascending', 'brayn-core' ),
					'DESC' => esc_html__( 'Descending', 'brayn-core' ),
				],
			]
		);

		$cats = brayn_core_taxonomies_options( 'category' );
		$this->add_control(
			'category',
			[
				'label' => esc_html__( 'Category', 'brayn-core' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'all',
				'description' => '',
				'options' => $cats,
			]
		);

		$this->end_controls_section();

	}

	public function get_post_class_by_col( $number ) {
		$number = intval( $number );
		$class = '-' . 12/$number;
		
		return $class;
	}

	/**
	 * Render widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings    = $this->get_settings_for_display();
		$post_number = $settings['number_post'];
		$order_by    = $settings['order_by'];
		$order       = $settings['order'];
		$category    = $settings['category'];

		$wrap_classes = [ 'col' . $this->get_post_class_by_col( $settings['post_col_mobile']['size'] ), 'col-md' . $this->get_post_class_by_col( $settings['post_col_tablet']['size'] ), 'col-lg' . $this->get_post_class_by_col( $settings['post_col']['size'] ), 'col-post-loop' ];

		$this->add_render_attribute(
			'post_wrap',
			[
				'class' => $wrap_classes,
			]
		);

		$post_args = array(
			'post_type'           => 'post',
			'post_status'         => 'publish',
			'ignore_sticky_posts' => 1,
			'orderby'             => $order_by,
			'order'               => $order,
			'paged'               => 1,
		);

		
		$post_args['posts_per_page'] = intval($post_number);

		if ( $category !== 'all' && intval( $category ) > 0 ) {
			$post_args['tax_query'] = array();
			$post_args['tax_query'][] = array(
					'taxonomy' => 'category',
					'field'    => 'id',
					'terms'    => intval( $category ),
					'operator' => 'IN'
			);
		}


		$p_query = new WP_Query( $post_args );
		if ( $p_query->have_posts() ) :

			print '<div class="container">' . "\n";
			print '<div class="row">' . "\n";

			while ( $p_query->have_posts() ) :
				$p_query->the_post();
				global $post;

				print '<div ' . $this->get_render_attribute_string( 'post_wrap' ) . '>' . "\n";

				get_template_part( 'template-parts/post/loop', 'column-widget' );

				print '</div>' . "\n";

			endwhile;
			wp_reset_postdata();

			print '</div>' . "\n";
			print '</div>' . "\n";

		endif;
	}
}
