<?php
/**
 * Some init functions
 *
 * @since version 1.0
 * @author WIP-Themes
 */

/**
 * Admin notice
 *
 * @access public
 * @since 1.0
 * @return string
 */
function brayn_core_plugin_error_notice() {
	$notice = __( 'Unfortunately "Brayn Core" plugin is not compatible with the current theme! Plugin has been disabled.', 'brayn-core' );
	echo "<div class=\"error\"><p>$notice</p></div>"; 
}

/**
 * Admin notice for elementor version
 *
 * @access public
 * @since 1.0
 * @return string
 */
function brayn_core_notice_elementor_version() {
	$notice = __( 'The minimum version of Elementor is 2.7.4. Please update the Elementor plugin', 'brayn-core' );
	echo "<div class=\"error\"><p>$notice</p></div>"; 	
}

/** 
 * plugin's activation
 */
function brayn_cores_activate() {
	do_action( 'wip_themes_core_before_init' );
	// refresh the wp_rewrite
	flush_rewrite_rules();
}

/** 
 * plugin's shut down
 */
function brayn_cores_deactivate() {
	do_action( 'wip_themes_core_deactivate' );
}

/**
 * Allow theme to register custom post type easily
 *
 * @since 1.0
 * @return void
 */
function brayn_core_add_custom_post_type( $name = null, $options = null ) {
	if ( empty( $options ) || empty( $name ) ) {
		return false;
	}

	Brayn_Core_Cpt::register_custom_post_type( $name, $options );
}

/**
 * Allow theme to register custom post type easily
 *
 * @since 1.0
 * @return void
 */
function brayn_core_add_custom_taxonomies( $name = null, $options = null ) {
	if ( empty( $options ) || empty( $name ) ) {
		return false;
	}

	Brayn_Core_Cpt::register_taxonomy( $name, $options );
}

/**
 * Enqueue Pace js
 *
 * @since 1.0.0
 */
function brayn_core_pace_js() {
	wp_enqueue_script( 'pace-js', esc_url( BRAYN_CORE_URL . '/assets/js/pace.min.js' ), array(), '1.0.0', false );
}
//add_action( 'wp_enqueue_scripts', 'brayn_core_pace_js' );
