<?php
/**
 * Some functions to show the instagram feed.
 *
 * @version 1.0
 */

/**
 * get the data from an Instagram account.
 */
function wip_themes_core_get_instagram( $username = '' ) {
	$username = trim( strtolower( $username ) );

	switch ( substr( $username, 0, 1 ) ) {
		case '#':
			$url = 'https://instagram.com/explore/tags/' . str_replace( '#', '', $username );
			$transient_prefix = 'h';
			break;

		default:
			$url = 'https://instagram.com/' . str_replace( '@', '', $username );
			$transient_prefix = 'u';
			break;
	}

	$instagram = get_transient( 'wip-themes-instagram-' . $transient_prefix . '-' . sanitize_title_with_dashes( $username ) );
	// if no data stored in transient, scraped the data.
	if ( false === $instagram ) :

		$remote = wp_remote_get( $url );

		if ( is_wp_error( $remote ) ) {
			return new WP_Error( 'site_down', esc_html__( 'Unable to communicate with Instagram.', 'brayn-core' ) );
		}

		if ( 200 !== wp_remote_retrieve_response_code( $remote ) ) {
			return new WP_Error( 'invalid_response', esc_html__( 'Invalid response : Instagram did not return a 200.', 'brayn-core' ) );
		}

		$shards = explode( 'window._sharedData = ', $remote['body'] );
		$insta_json = explode( ';</script>', $shards[1] );
		$insta_array = json_decode( $insta_json[0], true );

		if ( ! $insta_array ) {
			return new WP_Error( 'bad_json', esc_html__( 'Instagram has returned invalid data.', 'brayn-core' ) );
		}

		$images = '';
		if ( isset( $insta_array['entry_data']['ProfilePage'][0]['graphql']['user']['edge_owner_to_timeline_media']['edges'] ) ) {
			$images = $insta_array['entry_data']['ProfilePage'][0]['graphql']['user']['edge_owner_to_timeline_media']['edges'];
		} elseif ( isset( $insta_array['entry_data']['TagPage'][0]['graphql']['hashtag']['edge_hashtag_to_media']['edges'] ) ) {
			$images = $insta_array['entry_data']['TagPage'][0]['graphql']['hashtag']['edge_hashtag_to_media']['edges'];
		} else {
			return new WP_Error( 'bad_json_2', esc_html__( 'Instagram has returned invalid data.', 'brayn-core' ) );
		}

		if ( ! is_array( $images ) ) {
			return new WP_Error( 'bad_array', esc_html__( 'Instagram has returned invalid data.', 'brayn-core' ) );
		}

		$instagram = array();
		foreach ( $images as $image ) {
			if ( true === $image['node']['is_video'] ) {
				$type = 'video';
			} else {
				$type = 'image';
			}

			$caption = esc_html__( 'Instagram Picture', 'brayn-core' );
			if ( ! empty( $image['node']['edge_media_to_caption']['edges'][0]['node']['text'] ) ) {
				$caption = wp_kses( $image['node']['edge_media_to_caption']['edges'][0]['node']['text'], array() );
			}

			$instagram[] = array(
				'description'   => $caption,
				'link'		  	=> trailingslashit( '//instagram.com/p/' . $image['node']['shortcode'] ),
				'time'		  	=> $image['node']['taken_at_timestamp'],
				'comments'	  	=> $image['node']['edge_media_to_comment']['count'],
				'likes'		 	=> $image['node']['edge_liked_by']['count'],
				'thumbnail'	 	=> preg_replace( '/^https?\:/i', '', $image['node']['thumbnail_resources'][0]['src'] ),
				'small'			=> preg_replace( '/^https?\:/i', '', $image['node']['thumbnail_resources'][2]['src'] ),
				'large'			=> preg_replace( '/^https?\:/i', '', $image['node']['thumbnail_resources'][4]['src'] ),
				'original'		=> preg_replace( '/^https?\:/i', '', $image['node']['display_url'] ),
				'type'		  	=> $type,
			);

		} // End foreach().
		unset( $image );

		if ( ! empty( $instagram ) ) {
			$instagram = base64_encode( serialize( $instagram ) );
			set_transient( 'wip-themes-instagram-' . $transient_prefix . '-' . sanitize_title_with_dashes( $username ), $instagram, HOUR_IN_SECONDS*2 );
		}

	endif;

	if ( ! empty( $instagram ) ) {
		return unserialize( base64_decode( $instagram ) );
	} else {
		return new WP_Error( 'no_images', esc_html__( 'Instagram did not return any images.', 'brayn-core' ) );
	}
}

function wip_themes_core_print_instagram( $account = '', $ul_class = '', $li_class = 'ig-item', $limit = 20, $type = 'all', $size = 'small', $link = '' ) {
	if ( '' === $account ) {
		return false;
	}

	$media_array = wip_themes_core_get_instagram( $account );
	
	if ( is_wp_error( $media_array ) ) {
		print wp_kses_post( $media_array->get_error_message() );
	} else {
		if ( $type === 'images' ) {
			$media_array = array_filter( $media_array, 'wip_themes_core_filter_instagram_images_only' );
		}

		// slice the data based on the limit.
		$media_array = array_slice( $media_array, 0, intval( $limit ) );

		print '<ul class="wip-themes-instagram-showup ' . esc_attr( $ul_class ) . '">' . "\n";

		foreach ( $media_array as $item ) {
			print '<li class="' . esc_attr( $li_class ) . '"><a href="' . esc_url( $item['link'] ) . '" target="_blank" rel="nofollow"><img class="lazyload blur-up" src="' . esc_url( $item[$size] ) . '"  alt="' . esc_attr( $item['description'] ) . '" title="' . esc_attr( $item['description'] ). '" /></a></li>';
		}
		unset( $item );

		print '</ul>' . "\n";
	}
}

function wip_themes_core_filter_instagram_images_only( $media ) {
	if ( $media['type'] == 'image' ) {
		return true;
	}

	return false;
}
