window.braynFrontend = window.braynFrontend || {};

// Animation images, use it only for few sections,
// webGL is awesome, but it cost memory more
var pSlideCanvas = function () {
  function pSlideCanvas(parentEl, el, interaction, filterObj, sizes) {
    "use strict";

    _classCallCheck(this, pSlideCanvas);

    PIXI.utils.skipHello();
    this.build = {};
    this.build.parentEl = parentEl;
    this.build.el = el;
    this.build.sizes = sizes;
    this.build.interaction = interaction;
    this.build.filterObj = filterObj;

    if (typeof this.build.filterObj === 'undefined') {
      this.build.filterObj = braynLib.filterObj;
    }

    this.build.baseTimeline = new Array();
    this.readAssets();
  }

  _createClass(pSlideCanvas, [{
    key: "readAssets",
    value: function readAssets() {
      var that = this;
      this.build.count = 0;
      this.build.elemSizes = [];
      that.build.hovered = [];

      if (Array.isArray(that.build.el)) {
        that.build.el.forEach(function (ell) {
          that.loadAssets(ell, that.build.count);
          that.build.elemSizes[that.build.count] = {
            el: ell,
            width: jQuery(ell).find('img').width(),
            height: jQuery(ell).find('img').height()
          };
          that.build.hovered[that.build.count] = false;
          ++that.build.count;
        });
      } else {
        that.build.elemSizes[that.build.count] = {
          el: that.build.el,
          width: jQuery(that.build.el).find('img').width(),
          height: jQuery(that.build.el).find('img').height()
        };
        that.build.hovered[that.build.count] = false;
        that.loadAssets(that.build.el, that.build.count);
      }

      this.build.loader.add('objFilter', that.build.filterObj);
      this.build.loader.load(function (loader, resources) {
        that.buildCanvas(loader, resources);
        loader.reset();
      });
    }
  }, {
    key: "loadAssets",
    value: function loadAssets(ell, counter) {
      if (typeof this.build.loader === 'undefined') {
        this.build.loader = new PIXI.loaders.Loader();
      }

      this.build.loader.add('objSprite' + counter, jQuery(ell).find('img').attr('src'));
    }
  }, {
    key: "buildCanvas",
    value: function buildCanvas(loader, resources) {
      var that = this;

      if (typeof that.build.renderer === 'undefined') {
        that.build.renderer = new PIXI.autoDetectRenderer(that.build.sizes.width, that.build.sizes.height, {
          transparent: true,
          autoResize: true
        });
      }

      that.build.stage = new PIXI.Container();
      that.build.displacementSprite = new PIXI.Sprite.fromImage(that.build.filterObj);
      that.build.displacementFilter = new PIXI.filters.DisplacementFilter(that.build.displacementSprite);
      jQuery(that.build.parentEl).append(that.build.renderer.view);
      that.build.stage.interactive = true;
      that.build.slidesContainer = new Array();
      that.build.image = new Array();

      for (var i = 0; i < that.build.elemSizes.length; i++) {
        that.build.slidesContainer[i] = new PIXI.Container();
        var texture = new PIXI.Texture.fromImage(loader.resources['objSprite' + i].url);
        that.build.image[i] = new PIXI.Sprite(texture);
        that.build.image[i].width = that.build.elemSizes[i].width;
        that.build.image[i].height = that.build.elemSizes[i].height;
        that.build.slidesContainer[i].alpha = 0;
        that.build.slidesContainer[i].addChild(that.build.image[i]);
        that.build.stage.addChild(that.build.slidesContainer[i]);
      }

      that.build.renderer.view.style.position = 'absolute';
      that.build.renderer.view.style.maxWidth = '100%';
      that.build.renderer.view.style.width = '100%';
      that.build.renderer.view.style.height = '100%';
      that.build.renderer.view.style.zIndex = '-1';
      that.build.renderer.view.style.top = '50%';
      that.build.renderer.view.style.left = '50%';
      that.build.renderer.view.style.webkitTransform = 'translate( -50%, -50% )';
      that.build.renderer.view.style.transform = 'translate( -50%, -50% )';
      that.build.displacementSprite.texture.baseTexture.wrapMode = PIXI.WRAP_MODES.REPEAT;
      that.build.displacementSprite.scale.x = 5;
      that.build.displacementSprite.scale.y = 5;
      that.build.stage.addChild(that.build.displacementSprite);
      that.build.stage.filters = [that.build.displacementFilter];
      that.build.displacementFilter.scale.alpha = 0;
      that.build.displacementFilter.scale.x = 900;
      that.build.displacementFilter.scale.y = 450;
      that.build.iRender = new PIXI.ticker.Ticker();
      that.build.iRender.autoStart = true;
      that.build.iRender.add(function (delta) {
        if (that.build && that.build.renderer) {
          that.build.renderer.render(that.build.stage);
        }
      });

      if (that.build.interaction === 'hover') {
        that.listenEvent();
      } else if (that.build.interaction === 'hide') {
        that.build.displacementSprite.scale.x = 2;
        that.build.displacementSprite.scale.y = 2;
        that.attachNewListener();
      } else {
        that.build.displacementSprite.scale.x = 2;
        that.build.displacementSprite.scale.y = 2;
        that.show_destroy();
      }
    }
  }, {
    key: "attachNewListener",
    value: function attachNewListener() {
      var that = this;
      jQuery(that.build.parentEl).on('customShowCanvas', function () {
        that.build.baseTimeline = new anime.timeline({
          loop: false,
          autoplay: true,
          complete: function complete() {
            jQuery(that.build.parentEl).find('img').css({
              opacity: 1
            });

            for (var i = 0; i < that.build.slidesContainer.length; i++) {
              that.build.slidesContainer[i].alpha = 0;
            }

            that.build.displacementFilter.scale.alpha = 0;
            that.build.displacementFilter.scale.x = 900;
            that.build.displacementFilter.scale.y = 450;
            that.build.displacementSprite.scale.x = 2;
            that.build.displacementSprite.scale.y = 2;
          }
        });
        that.build.baseTimeline.add({
          targets: that.build.displacementFilter.scale,
          duration: 1000,
          alpha: 1,
          x: 0,
          y: 0,
          easing: 'easeInOutCirc'
        }).add({
          targets: that.build.slidesContainer,
          duration: 1000,
          alpha: 1,
          easing: 'easeInOutCirc'
        }, '-=1000');
      });
    }
  }, {
    key: "listenEvent",
    value: function listenEvent() {
      var that = this;
      jQuery(window).on('braynBeforeLoadNewCanvas', function () {
        jQuery(window).off('resize');
      });
      $(that.build.slidesContainer).each(function (i) {
        var k = i;
        jQuery(that.build.elemSizes[k].el).on('mouseover', function () {
          requestAnimationFrame(function () {
            if (!that.build.hovered[k]) {
              that.showit(k);
              that.build.baseTimeline[k].play();
            } else {
              that.build.baseTimeline[k].play();
              that.build.baseTimeline[k].reverse();
            }
          });
        }).on('mouseleave', function () {
          requestAnimationFrame(function () {
            that.build.baseTimeline[k].play();
            that.build.baseTimeline[k].reverse();
          });
        });
      });
    }
  }, {
    key: "showit",
    value: function showit(i) {
      var that = this;
      that.build.baseTimeline[i] = new anime.timeline({
        loop: false,
        autoplay: false,
        complete: function complete() {
          that.build.hovered[i] = true;
        }
      });
      var koko = that.build.slidesContainer[i];
      that.build.baseTimeline[i].add({
        targets: that.build.displacementFilter.scale,
        duration: 1000,
        alpha: 1,
        x: 0,
        y: 0,
        easing: 'easeInOutCirc'
      }).add({
        targets: koko,
        duration: 1000,
        alpha: 1,
        easing: 'easeInOutCirc'
      }, '-=1000');
    }
  }, {
    key: "show_destroy",
    value: function show_destroy() {
      var that = this;
      that.build.baseTimeline = new anime.timeline({
        loop: false,
        autoplay: true,
        complete: function complete() {
          jQuery(that.build.parentEl).find('img').css({
            opacity: 1
          });
          window.requestTimeout(function () {
            that.build.displacementFilter.scale.alpha = 0;

            for (var i = 0; i < that.build.slidesContainer.length; i++) {
              that.build.slidesContainer[i].alpha = 0;
            }

            that.__destroy();
          }, 50);
        }
      });
      that.build.baseTimeline.add({
        targets: that.build.displacementFilter.scale,
        duration: 1200,
        alpha: 1,
        x: 0,
        y: 0,
        easing: 'easeInOutCirc'
      }).add({
        targets: that.build.slidesContainer,
        duration: 1200,
        alpha: 1,
        easing: 'easeInOutCirc'
      }, '-=1200');
    }
  }, {
    key: "__destroy",
    value: function __destroy() {
      this.build.stage.filters = null;
      this.build.iRender.remove();
      this.build.stage.removeChild();
      this.build.baseTimeline = this.build.slidesContainer = this.build.displacementSprite = this.build.displacementFilter = this.build.itexture = this.build.image = null;
      this.build.renderer.destroy(true);
    }
  }]);

  return pSlideCanvas;
}();

// Obj braynFrontend
window.braynFrontend = function($) {
	"use strict";
	var z = {
		$win: $(window),
		$doc: $(document),
		$version: '2.0.0',
		init: function() {
			var d=this;
			d.headerSize = 0;
			d.origScroll = 0;
			d.onMenuShow = d.menuShowed = d.getter = d.getterProcess = d.onAjaxProgress = false;
			d.initialLoaded = true;
			d.currentUrl = window.location.href;

			// @version 2.0.0
			// Fix safari back-forward cache issue.
			d.$win.on("pageshow", function(event) {
				if (event.originalEvent.persisted) {
					window.location.reload();
				}
			});

			d.$doc.ready(function(){
				PIXI.utils.skipHello();
				d.parallaxInit();
        		d.mediaPlayerSkin();
        		d.wooProductImage();
        		d.portfolioImageShadow();
				if( $('#transit_roler').length < 1 ) {
					$(window).trigger('braynHasDoneLoad');
				}
      		});

      		d.$doc.ajaxComplete(function(){
      			d.wooProductImage();
      			d.linkClickTrigger();
      		});

			d.$win.on('load', function() {
				if( $('#transit_roler').length ) {
					$(window).trigger('braynHasDoneLoad');
				}
				d.getHeaderSize();

				d.linkClickTrigger();
			});

			d.$win.on('braynHasDoneLoad', function() {
				d.removeLoader();
			});

			d.$win.on('braynHasFinishLoad', function() {
				d.shrinkHeader();
				d.funcCaller();
				d.prettyReveal();
				d.menuListener();
				d.searchHandle();

				d.origScroll = d.$win.scrollTop();

				if ( window.location.hash ) {
					var tgt = window.location.hash.substring(1);
					if ( tgt ) {
						window.requestTimeout(function(){
							if ( /iPad|iPhone|iPod|Android/.test(navigator.userAgent) || document.documentElement.className.includes('default-scroll') ) {
								$('html, body').animate({ scrollTop : Math.round($('#'+tgt).offset().top)-100 }, 300 );
							} else {
								$(window).scrollTop( Math.round($('#'+tgt).offset().top)-100 );
							}
							
						}, 500);
					}
				}
			});

			// resize
			d.$win.on('resize', function(e) {
				d.getHeaderSize();

				window.requestTimeout(function(){
					d.floatEdgeMedia();
					d.floatEdgeMediaOrig();
				}, 100);
			});

			// Scroll.
			d.$win.on('scroll', function() {
				var body = document.body,
					html = document.documentElement;

				d.shrinkHeader();
				d.watchPortfolioGridItems();

				var bstop = window.pageYOffset || html.scrollTop || body.scrollTop || 0;

				if ( ( bstop < d.$win.height() ) && $('.jarallax-img').length && ( /iPad|iPhone|iPod|Android/.test(navigator.userAgent) === false ) ) {
					$('.jarallax-img').css({
						webkitTransform: 'translate3d(0, '+ ( bstop === 0 ? 0 : bstop*0.5 ) +'px, 0)',
						transform: 'translate3d(0, '+ ( bstop === 0 ? 0 : bstop*0.5 ) +'px, 0)',
					});
				}
			});

			// Elementor back-end events.
			d.$win.on('BraynPSAdded', function() {
				d.portoSlideWd();
			});

			d.$win.on('BraynWooSliderAdded', function(event, $scope) {
				d.wooSliderInit($scope);
			});

			d.$win.on('BraynPortoAdded', function() {
				d.portfolioImageShadow();
			});

			d.$win.on('BraynPGSAdded', function(event, $scope) {
				d.portoGalSlideInit($scope);
			});

			d.$win.on('BraynMetroAdded BraynGalMasonryAdded', function(event, $scope) {
				d.masonryInit();
			});

			d.$win.on('BraynCircleAdded', function(event, $scope) {
				d.circleProgressOnEditor($scope);
				d.circProg();
			});

		},

		// Link click event
		// Depecreated soon.
		linkClickTrigger: function() {
			var d=this;

			$('.showcoupon').removeClass('calc-open');

			$('a').on('click', function(e) {
				var z=this;

				// @version 2.0.0 - WooCommerce support.
				if ( $(this).braynHasAnyClass( 'ajax_add_to_cart', 'woocommerce-product-gallery__trigger', 'remove', 'restore-item', 'showcoupon', 'reset_variations', 'woocommerce-review-link', 'shipping-calculator-button', 'showlogin' ) || $(this).parents('.wc-tabs').length || $(this).parents('.stars').length || $(this).parents('.woocommerce-product-gallery').length || $(this).parents('.mejs-container').length ) {
					if ( $(this).hasClass('shipping-calculator-button') ) {
						if ( $('.shipping-calculator-form').is(":hidden") ) {
							$(z).addClass('calc-open');
						} else {
							$(z).removeClass('calc-open');
						}
					}

					if ( $(this).hasClass('showcoupon') ) {
						if ( $('form.checkout_coupon').is(":hidden") ) {
							$(z).addClass('calc-open');
						} else {
							$(z).removeClass('calc-open');
						}
					}

					if ( $(this).hasClass('showlogin') ) {
						if ( $('form.woocommerce-form-login').is(":hidden") ) {
							$(z).addClass('calc-open');
						} else {
							$(z).removeClass('calc-open');
						}
					}
					return;
				}

				if ( ! $('#transit_roler').length ) {
					return;
				}

				if ( z.href.indexOf('#') !== -1 ) {
					var ccid = z.hash.substring(1),
						realURL = z.href.substr(0,z.href.indexOf('#'));

					if ( ! ccid && ( z.pathname === window.location.pathname ) ) {
						return false;
					}

					// Process haschange
					if (ccid && ( z.pathname === window.location.pathname ) ) {
						e.preventDefault();
						d.hashChangeHandler(z);
						return false;
					}
				}

				var new_tab = e.ctrlKey || e.metaKey;
				if ( $(z).attr('target') === '_blank' ) {
					new_tab = true;
				}

				if ( ! new_tab ) {
					if ( $('body').hasClass('elementor-editor-active') ) {
						return false;
					}
					if ( $('#transit_roler').length && d.linkisLocal(z) ) {
						// start the transition.
						d.callthepage(e);
					}
				}
			});
		},

		// Woocommerce product image shadow.
		wooProductImage: function() {
			var colorThief = new ColorThief();

			$('.products:not(.braynWooBeauty)').each(function() {
				var pp = this;

				$(pp).find('.product').each( function() {
					var p = this;
					if ( $(this).find('img').length ) {
						var img = $(this).find('img'),
							clr;
						img = img[0];

						if ( img.complete ){
							clr = colorThief.getColor(img);

							if ( typeof clr === "undefined" ) {
								return false;
							}

							$(img).css({
								'-webkit-box-shadow': '0 30px 20px -15px rgba('+clr.toString()+', .5)',
								boxShadow: '0 30px 20px -15px rgba('+clr.toString()+', .5)',
								'-webkit-transition': 'all 0.3s ease-out 0s',
								'transition': 'all 0.3s ease-out 0s',
							});
							
							$(p).on('mouseover', function(){
								$(img).css({
									'-webkit-transform': 'translateY(-10px)',
									'transform': 'translateY(-10px)',
									'-webkit-box-shadow': '0 45px 22px -25px rgba('+clr.toString()+', .75)',
									boxShadow: '0 45px 22px -25px rgba('+clr.toString()+', .75)',
								});
							}).on('mouseleave', function() {
								$(img).css({
									'-webkit-transform': 'translateY(0)',
									'transform': 'translateY(0)',
									'-webkit-box-shadow': '0 30px 20px -15px rgba('+clr.toString()+', .5)',
									boxShadow: '0 30px 20px -15px rgba('+clr.toString()+', .5)',
								});
							});

							$(pp).addClass('braynWooBeauty');
						} else {
							img.addEventListener('load', function() {
								clr = colorThief.getColor(img);

								if ( typeof clr === "undefined" ) {
									return false;
								}

								$(img).css({
									'-webkit-box-shadow': '0 30px 20px -15px rgba('+clr.toString()+', .5)',
									boxShadow: '0 30px 20px -15px rgba('+clr.toString()+', .5)',
									'-webkit-transition': 'all 0.3s ease-out 0s',
									'transition': 'all 0.3s ease-out 0s',
								});
								
								$(p).on('mouseover', function(){
									$(img).css({
										'-webkit-transform': 'translateY(-10px)',
										'transform': 'translateY(-10px)',
										'-webkit-box-shadow': '0 45px 22px -25px rgba('+clr.toString()+', .75)',
										boxShadow: '0 45px 22px -25px rgba('+clr.toString()+', .75)',
									});
								}).on('mouseleave', function() {
									$(img).css({
										'-webkit-transform': 'translateY(0)',
										'transform': 'translateY(0)',
										'-webkit-box-shadow': '0 30px 20px -15px rgba('+clr.toString()+', .5)',
										boxShadow: '0 30px 20px -15px rgba('+clr.toString()+', .5)',
									});
								});

								$(pp).addClass('braynWooBeauty');
							});
						}
					}
				});
			});
		},

		// Portfolio image shadow.
		portfolioImageShadow: function() {
			var d=this;

			if ( $('.portfolio-grid-lists').length ) {
				var colorThief = new ColorThief();

				$('.portfolio-grid-link').each( function()  {
					var t=this;

					if ( $(t).hasClass('braynShadBeauty') ) {
						return;
					}

					if ( $(t).find('img').length ) {
						var img = $(t).find('img'),
							clr;

						img = img[0];
						if ( img.complete ){
							clr = colorThief.getColor(img);
							if ( typeof clr !== "undefined" ) {

								$(img).css({
									'-webkit-box-shadow': '30px 30px 45px 0 rgba('+clr.toString()+', .5)',
									boxShadow: '30px 30px 45px 0 rgba('+clr.toString()+', .5)',
									'-webkit-transition': 'all 0.3s ease-out 0s',
									'transition': 'all 0.3s ease-out 0s',
								});

								$(t).addClass('braynShadBeauty');

							}
						} else {
							img.addEventListener('load', function() {
								clr = colorThief.getColor(img);

								if ( typeof clr !== "undefined" ) {

									$(img).css({
										'-webkit-box-shadow': '30px 30px 45px 0 rgba('+clr.toString()+', .5)',
										boxShadow: '30px 30px 45px 0 rgba('+clr.toString()+', .5)',
										'-webkit-transition': 'all 0.3s ease-out 0s',
										'transition': 'all 0.3s ease-out 0s',
									});

									$(t).addClass('braynShadBeauty');

								}
							});
						}
					}
				});
			}
		},

		detectFailedImg: function() {
			var d=this, Err=false;

			$('img').each(function() {
				$(this).on('error', function() {
					$(this).removeAttr('src');
					Err=true;
				});
			});

			if ( Err ) {
				$(window).trigger('load');
			}
		},

		hashChangeHandler: function(el) {
			var d=this, ccid = el.hash.substring(1);
			if ( ccid ) {
				if ( d.menuShowed ) {
					var btn = $('button.hamburger__menu');
					btn.trigger('click');

					$(window).one( 'braynMenuClosedForAjax', function() {
						$('html, body').animate({ scrollTop : Math.round($('#'+ccid).offset().top)-100 }, 800 );
						window.location.hash = ccid;
					});
				} else {
					$('html, body').animate({ scrollTop : Math.round($('#'+ccid).offset().top)-100 }, 800 );
					window.location.hash = ccid;
				}
			}
		},

		/**
		 * The page transition if preloader is used
		 *
		 * @since 1.0.0
		 */
		callthepage: function(e) {
			var d=this,
				nTarget = e.currentTarget.pathname + e.currentTarget.search;

			e.preventDefault();
			if ( d.menuShowed ) {
				$('body').removeAttr('style');
				$(window).scrollTop(0);
			}

			// Remove any pointer events
			$('body').css({
				cursor: 'progress',
				pointerEvents: 'none'
			});

			// Do!!
			d.shrinkContent( e.currentTarget.href );
		},

		/**
		 * The animation before call the new page
		 * @since 1.0.0
		 */
		shrinkContent: function( dest_url ) {
			var d=this, $body = $('body'), $site = $("#site"), tempScrollTop = d.$win.scrollTop(), $header = $('#main-header'),
				shr = anime.timeline({
					autoplay: true,
					complete: function() {
						d.pageTransit(dest_url);
					},
				});

			if ( !d.menuShowed && $header.hasClass('shrink') ) {
				$header.addClass('keepshrink');
				$header.css({top: tempScrollTop+'px'});
			}

			$site.css({
				position: 'fixed',
				top: 0,
				left: 0,
				width: '100%',
				height: '100%',
				overflow: 'hidden',
				webkitBoxShadow: '0 0 100px rgba(0,0,0, .12)',
				boxShadow: '0 0 100px rgba(0,0,0, .12)',
			}).scrollTop(tempScrollTop);    

			shr.add({
				targets: '#site',
				scale: 0.9,
				translateY: (d.$win.width()*0.05)-(d.$win.height()*0.05),
				duration: 500,
				easing: 'easeInOutCirc',
			});
		},

		/**
		 * Check the link
		 *
		 * @version 1.0.0
		 */
		linkisLocal: function(el) {
			var d=this;
			if( window.location.hostname === el.hostname || !el.hostname.length ) {
				// Check more for other cases
				if ( d.linkDeniedUseAjax(el) ) {
					return false;
				}
				return true;
			}

			return false;
		},

		/**
		 * Check the link,
		 * reject if link for mailto/tel, or link to image/video/text file
		 *
		 * @version 1.0.0
		 */
		linkDeniedUseAjax: function(elem) {
			var el = elem.href;

			if ( el.indexOf('mailto:') !== -1 || el.indexOf('tel:') !== -1 ) {
				return true;
			}

			el = el.split('?')[0];
			var parts = el.split('.'),
				extension = parts[parts.length-1],
				fileTypes = ['jpg','jpeg','tiff','png','gif','bmp','mp4','mp3','mov','txt','doc'];

			// if link is point to image/video files, reject it.
			if( fileTypes.indexOf(extension) !== -1 ) {
				return true;
			}

			return false;
		},

		pageTransit: function( dest_url ) {
			var d=this,roler=document.getElementById('transit_roler');

			if ( ! roler ) {
				var c = document.createDocumentFragment(),
            divroler = document.createElement('div');

				divroler.id = 'transit_roler';

				c.appendChild(divroler);
				divroler.innerHTML = '<div class="trl"></div><div class="trr"></div><div class="trload"></div>';

				document.body.appendChild(c);
				roler = document.getElementById('transit_roler');
			}
			$(roler).css({
				position: 'fixed',
				zIndex: 102,
				left: 0,
				right: 0,
				bottom: 0,
				top: 0,
				width: '100%',
				height: 0,
				overflow: ''
			});
			$(roler).find('.trl, .trr').css({
				position: 'fixed',
				zIndex: 103,
				width: '51%',
				height: 0,
				top: 'initial',
				bottom: 0,
				left: 0,
				willChange: 'height',
			});
			$(roler).find('.trr').css({
				left: 'initial',
				right: 0
			});
			
			$(roler).find('.trload').css({
				opacity: 0,
				display: 'block',
			});
			
			anime({
				targets: ['#transit_roler .trl', '#transit_roler .trr'],
				height: ['0%','100%'],
				duration: 500,
				easing: 'easeInOutCirc',
				delay: function(el, i, l) { return i * 100; },
				complete: function() {
					$(roler).find('.trload').css({
						opacity: 1
					});

					window.location.href = dest_url;
				}
			});
		},

		getHeaderSize: function() {
			var d=this, $header = $('#main-header'), hs=false, tm = (d.initialLoaded) ? 5 : 500;
			if ( d.getter ) {
				window.clearRequestTimeout( d.getter );
			}

			if ( $header.hasClass('shrink') ) {
				hs=true;
			}

			d.getterProcess = true;
			$header.removeClass('shrink').removeAttr('style');
			$header.find('.brand--nav').removeAttr('style');

			d.getter = window.requestTimeout( function() {
				d.headerSize = {
					width: d.$win.width(),
					height: $header.height(),
					logoWidth: $('.brand').find('img').width(),
				}
				$('.ui-menu-container').css({paddingTop: d.headerSize.height+'px' });
				if ( $('.header--complementary').css('position') === 'fixed' ) {
					$('.ui-menu-container').css({paddingBottom: '65px' });
				} else {
					$('.ui-menu-container').css({paddingBottom: '' });
				}

				if ( $('body').hasClass('elementor-page') && $('header.page-header').length < 1 && $('.single-portfolio-header').length < 1 ) {
					var firstEl = $('.brayn-the-content').find(">:first-child");
					if ( $(firstEl).hasClass('elementor') ) {
						var elElem = $(firstEl).find('.elementor-element:first'),
							elBg = $(elElem).css('background-color'),
							elBgImg = $(elElem).css('background-image'),
							settings = $(elElem).data('settings');

						if ( typeof settings === "undefined" || typeof settings.background_background === "undefined" || ( typeof settings.background_background !== "undefined" && ( settings.background_background !== "slideshow" && settings.background_background !== "video" ) ) ) {
							if ( typeof elBg === 'undefined' || elBg.replace(/ /g,'') === 'rgba(0,0,0,0)' || elBg === 'transparent' ) {
								if ( typeof elBgImg === 'undefined' || elBgImg === 'none' || elBgImg === '' ) {
									$('.header--complementary').addClass('button-reverse');
								}
							}
						}
					} else if ( $('body').hasClass('single-post') ) {
						$('#main').css({paddingTop: d.headerSize.height+'px'});
						$('.header--complementary').addClass('button-reverse');
					}
				} else if ( $('#brayn-section-hero').length < 1 && $('header.page-header').length < 1 && $('.single-portfolio-header').length < 1 && $('#top-map').length < 1 && $('.brayn-first-post').length < 1 ) {
					if ( ! $('#main').find('.br-section:first-child').hasClass('br-min-height__100vh') )	{
						$('#main').css({paddingTop: d.headerSize.height+'px'});
					}
					$('.header--complementary').addClass('button-reverse');
				} else if ( $('#brayn-section-hero').length < 1 && $('header.page-header').length > 0 ) {
					$('header.page-header').css({paddingTop: d.headerSize.height+'px'});
				}

				d.getterProcess = false;
				d.initialLoaded = false;
				if ( hs ) {
					hs=false;
					d.shrinkHeader();
				}
			}, tm);
		},

		shrinkHeader: function() {
			var d=this, oAnimate = false, $header = $('#main-header');

			// size is unknown, leave it for now.
			if ( typeof d.headerSize.height === 'undefined' || d.getterProcess || $header.hasClass('keepshrink') ) {
				return false;
			}

			if ( d.$win.scrollTop() > d.headerSize.height ) {
				oAnimate = true;
				$header.find('.brand--nav').css({width: d.headerSize.logoWidth+60+54+'px'});
				$header.addClass('shrink');
				oAnimate = false;
			} else if ( d.$win.scrollTop() < 5 ) {	
				if ( $header.hasClass('shrink') && ! oAnimate ) {
					oAnimate = true;
					$header.find('.brand--nav').css({width: '50%'});
					requestTimeout(function() {
						oAnimate = false;
						$header.removeClass('shrink');
						$header.find('.brand--nav').css({width: ''});
					}, 500);
				}
			}
		},

		menuListener: function() {
			var d=this, btn = $('button.hamburger__menu'), $header = $('#main-header'), html = document.documentElement, body = document.body;

			d.addMenuArrows();
			if ( $('.main-menu-widgets').is(':hidden') === false && $('.menu-widget-image').length ) {
				if ( $('.menu-widget-image').find('canvas').length < 1 ) {
					new pSlideCanvas( $('.menu-widget-image')[0], $('.menu-widget-image')[0], 'hide', braynLib.filterObj, {width: $('.menu-widget-image').width(), height: $('.menu-widget-image').height()} );
				}
			}

			btn.on( 'click', function(e) {
				e.preventDefault();
				var oSt = window.pageYOffset || html.scrollTop || body.scrollTop || 0;

				if ( d.onMenuShow ) {
					return false;
				}

				d.onMenuShow = true;

				if ( btn.hasClass('is-active') ) {
					btn.removeClass('is-active');
					var menuHide = anime.timeline({
						autoplay: true,
						complete: function() {
							d.onMenuShow = false;
							$('.main-menu-container-wrap, .menu-widget').removeAttr('style');
							$('.menu-widget-image').parent().removeClass('done-it');
							$('.menu-widget-image').find('img').removeAttr('style');
							d.shrinkHeader();
							d.menuShowed = false;

							if ( $('.brayn-on-customize').length ) {
								if ( ! $('.brayn-on-customize').hasClass('SlideCanvasInited') ) {
									$('.menu-widget-image').find('canvas').remove();
									$('.brayn-on-customize').addClass('SlideCanvasInited');
									new pSlideCanvas( $('.menu-widget-image')[0], $('.menu-widget-image')[0], 'hide', braynLib.filterObj, {width: $('.menu-widget-image').width(), height: $('.menu-widget-image').height()} );
								}
							}
							
							d.$win.on('scroll', function() {
								d.shrinkHeader();
								d.watchPortfolioGridItems();
							});
							$('body').css({ height: '', overflow: '' });
							$(window).trigger('braynMenuClosedForAjax');
						}
					});

					$('.main-menu-container-wrap').css({
						top: 0,
						bottom: 'initial'
					});

					menuHide.add({
						targets: ['#brayn-menu > .menu-item', '.menu-widget'],
						opacity: [1,0],
						translateY: [0, -100],
						delay: function(el, i, l) { return i * 50; },
						easing: 'easeInOutSine',
						duration: ( d.onAjaxProgress ? 50 : 800 ),
						complete: function() {
							$header.removeClass('on_menu');
						}
					}).add({
						targets: '.main-menu-container-wrap',
						height: ['100%', '0%'],
						opacity: [1,0],
						easing: 'easeInOutCirc',
						duration: ( d.onAjaxProgress ? 50 : 600 ),
						offset: '-=200',
					});
				} else {
					btn.addClass('is-active');
					var menuShow = anime.timeline({
						autoplay: true,
						complete: function() {
							$header.addClass('on_menu');
							if ( $header.hasClass('shrink') ) {
								$header.find('.brand--nav').css({width: '50%'});
								window.requestTimeout(function(){
									$header.removeClass('shrink');
									$header.find('.brand--nav').css({width: ''});
									d.onMenuShow = false;
								},500);
							} else {
								d.onMenuShow = false;
							}
							d.menuShowed = true;
						}
					});
					
					$('body').css({height: '100%', overflow: 'hidden'});
					//d.$win.off('scroll');
					
					menuShow.add({
						targets: '.main-menu-container-wrap',
						height: ['0%', '100%'],
						opacity: [0, 1],
						easing: 'easeInOutCirc',
						duration: 600,
						complete: function() {
							var mwi = $('.menu-widget-image');

							if ( mwi.length && typeof window.appear !== 'undefined' ) {
								var mwiAppear = new window.appear({
									elements: function elements() {
										return document.getElementsByClassName('menu-widget-image');
									},
									appear: function appear(el) {
										$(el).trigger('customShowCanvas');
										$(el).parent().addClass('done-it');
									},
									bounds: 0
								});
							}
						}
					}).add({
						targets: ['#brayn-menu > .menu-item', '.menu-widget > h4', '.menu-widget-list > li'],
						opacity: [0,1],
						translateY: [50, 0],
						delay: function(el, i, l) { return i * 50; },
						easing: 'easeOutSine',
						duration: 600,
						offset: "-=50",
					});
				}
			});

			var menuScroll = window.Scrollbar,
				menuEl = document.querySelector('.main-menu-container'),
				scrollEm;

			if ( menuEl ) {
				scrollEm = menuScroll.init( menuEl );
				scrollEm.scrollTop = 0;
			}
		},

		/**
		 * Add arrow to menu item that have child
		 * @ver 1.0
		 */
		addMenuArrows: function() {
			var d=this, $master=$('#brayn-menu'), $childs=$master.find('ul.sub-menu');

			if ( $childs.length ) {
				$childs.each(function() {
					var z=$(this).parent(),arrow='<span class="arrow-yuk-down"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M256 294.1L383 167c9.4-9.4 24.6-9.4 33.9 0s9.3 24.6 0 34L273 345c-9.1 9.1-23.7 9.3-33.1.7L95 201.1c-4.7-4.7-7-10.9-7-17s2.3-12.3 7-17c9.4-9.4 24.6-9.4 33.9 0l127.1 127z"/></svg></span>';
					$(this).hide();
					if ( $(z).find('>.arrow-yuk-down').length < 1 ) {
						$(arrow).insertAfter( $(z).find('>a') );
					} else {
						if ( $(z).find('>.arrow-yuk-down').hasClass('rtt') ) {
							$(z).find('>.arrow-yuk-down').removeClass('rtt');
						}
					}
				});
			}
			
			$('.arrow-yuk-down').each(function() {
				var ayd = this;
				$(ayd).on('click', function(e) {
					e.preventDefault();
					if ( ! $(this).hasClass('rtt') ) {
						$(ayd).parent('li').find('>ul').stop().slideDown(200, function(){
							$(ayd).addClass('rtt');
						});
					} else {
						$(this).parent('li').css({pointerEvents : 'none'});
						$(this).parent('li').trigger('mouseleave');
					}
				});
				$(ayd).parent('li').on('mouseover', function() {
					$(this).find('>ul').stop().slideDown(200, function() {;
						$(ayd).addClass('rtt');
					});
				}).on('mouseleave', function() {
					$(this).find('>ul').stop().slideUp(200, function(){
						$(ayd).parent('li').css({pointerEvents : ''});
						$(ayd).removeClass('rtt');
					});
				});
			});
		},

		searchHandle: function() {
			var t=this,
				onMove = false,
				btn=$('.search-caller'),
				closebar=$('.brayn--close-search-form'),
				$form = $('#brayn-search-form').find('form'),
				s_anim;

			$('.brayn--search').css({backgroundColor: 'inherit', width: '100%'});
			s_anim = anime.timeline({
				autoplay: false,
				complete: function() {
					onMove = false;
				}
			});

			s_anim.add({
				targets: '#brayn-search-form',
				width: ['0%', '100%'],
				duration: 400,
				easing: 'easeInOutCirc'
			}).add({
				targets: '#brayn-search-form .brayn--close-search-form',
				scale: [0, 1],
				opacity: [0,1],
				duration: 200,
				easing: 'easeInOutSine',
			}).add({
				targets: '#brayn-search-form .search-form',
				translateY: [50, 0],
				opacity: [0,1],
				duration: 400,
				easing: 'easeInOutSine',
			});

			btn.unbind().on('click',function(e) {
				e.preventDefault();
				if ( onMove ) {
					return false;
				}

				if( s_anim.reversed ) {
					s_anim.reverse();
				}
				onMove = true;
				s_anim.play();
				$('#brayn-search-form').find('input[type="search"]').val('').focus();
			});

			closebar.css({display: 'block'}).on('click', function(e) {
				e.preventDefault();
				if ( onMove ) {
					return false;
				}
				$('#brayn-search-form').find('input[type="search"]').blur();
				onMove = true;
				anime({
					targets: '#brayn-search-form',
					width: ['100%', '0%'],
					opacity: [1, 0],
					duration: 400,
					easing: 'easeInOutCirc',
					complete: function() {
						$('#brayn-search-form').css({opacity: ''});
						closebar.removeAttr('style');
						$('#brayn-search-form .search-form').removeAttr('style');
						onMove = false;
					}
				});
			});
		},

		/**
		 * Parallax & hero helper
		 * @ver 1.0
		 */
		parallaxInit: function() {
			var d=this, $singleHeader = $('.portfolio-header-bg'), $firstPostHeader = $('.first-post-bg');
			var isSafari = navigator.vendor && navigator.vendor.indexOf('Apple') > -1 && navigator.userAgent && navigator.userAgent.indexOf('CriOS') == -1 && navigator.userAgent.indexOf('FxiOS') == -1;

			if ( $singleHeader.length ) {
				$singleHeader.find('img').addClass('jarallax-img');
				$singleHeader.jarallax({
					speed: -0.2,
					type: 'scale',
					disableParallax: function() {
						return /iPad|iPhone|iPod|Android/.test(navigator.userAgent) || isSafari;
					},
					onInit: function() {
						window.requestTimeout(function(){
							$singleHeader.find('.jarallax-img').css({'-webkit-transform':'translate3d(0px,0px,0px) scale(1.2)','transform':'translate3d(0px,0px,0px) scale(1.2)'});
						},200);
					}
				});

				if ( /iPad|iPhone|iPod|Android/.test(navigator.userAgent) || isSafari ) {
					$singleHeader.braynrallax();
				}

				anime({
					targets: '.portfolio-header-bg',
					opacity: [0,1],
					scale: [1.1, 1],
					duration: 1000,
					easing: 'easeInOutSine',
					delay: 200,
					complete: function() {
						$singleHeader.removeAttr('style').css({opacity: 1});
					}
				}); 
			}

			if ( $firstPostHeader.length && $firstPostHeader.find('img').length ) {
				$firstPostHeader.find('img').addClass('jarallax-img');
				$firstPostHeader.jarallax({
					speed: -0.2,
					type: 'scale-opacity',
					disableParallax: function() {
						return /iPad|iPhone|iPod|Android/.test(navigator.userAgent) || isSafari;
					},
					onInit: function() {
						window.requestTimeout(function(){
							$firstPostHeader.find('.jarallax-img').css({'-webkit-transform':'translate3d(0px,0px,0px) scale(1.2)','transform':'translate3d(0px,0px,0px) scale(1.2)'});
						},200);
					}
				});

				if ( /iPad|iPhone|iPod|Android/.test(navigator.userAgent) || isSafari ) {
					$firstPostHeader.braynrallax();
				}

				anime({
					targets: '.first-post-bg',
					opacity: [0,1],
					scale: [1.1, 1],
					duration: 1000,
					easing: 'easeInOutSine',
					delay: 200,
					complete: function() {
						$firstPostHeader.removeAttr('style').css({opacity: 1});
					}
				}); 
			}
		},

		/**
		 * Woo product carousel
		 * @since 2.0.0
		 */
		wooSlider: function() {
			var d=this, $wooCarousel = $('.e-brayn-product-slide-container'), wooSwiper = [];

			if ( $wooCarousel.length > 0 ) {
				$wooCarousel.each( function(x) {
					var colSlide = $(this).data('colnumb'),
						slideAuto = $(this).data('autoplay'),
						slideSpeed = $(this).data('speed'),
						wooCarouselSlide = $(this).find('.e-brayn-product-slide'),
						autoParams;
					// Exists, clean em.
					if ( typeof wooSwiper[x] !== 'undefined' ) {
						wooSwiper[x].destroy(true, true);
					}
					if ( $(this).find('.swiper-pagination').length ) {
						$(this).find('.swiper-pagination').attr('id', 'wooCarouselPagination'+x);
					}
					$(wooCarouselSlide).attr('id', 'wooCarousel'+x);

					autoParams = ( slideAuto.enabled === "" ) ? false : { delay: slideAuto.delay };

					wooSwiper[x] = new Swiper('#wooCarousel'+x, {
						slidesPerView: colSlide.mobile,
						spaceBetween: 20,
						grabCursor: true,
						autoHeight: true,
						speed: slideSpeed,
						autoplay: autoParams,
						breakpointsInverse: true,
						breakpoints: {
							768: {
								slidesPerView: colSlide.tablet,
								spaceBetween: 30
							},
							992: {
								slidesPerView: colSlide.def,
								spaceBetween: 40
							}
						},
						pagination: {
							el: '#wooCarouselPagination'+x,
							clickable: true,
						},
					});
				});
			}
		},

		wooSliderInit: function( $scope ) {
			var d=this, x=$($scope);
			
			if ( ! x.hasClass('e-brayn-product-slide-container') ) {
				x = x.find('.e-brayn-product-slide-container');
				x = $(x);
			}

			var colSlide = x.data('colnumb'),
				slideAuto = x.data('autoplay'),
				slideSpeed = x.data('speed'),
				wooCarouselSlide = x.find('.e-brayn-product-slide'),
				autoParams;

			//if ( x.find('.swiper-pagination').length ) {
				//x.find('.swiper-pagination').attr('id', 'wooCarouselPagination'+x);
			//}
			//$(wooCarouselSlide).attr('id', 'wooCarousel'+x);

			autoParams = ( slideAuto.enabled === "" ) ? false : { delay: slideAuto.delay };

			var wooSwiper = new Swiper($(wooCarouselSlide)[0], {
				slidesPerView: colSlide.mobile,
				spaceBetween: 20,
				grabCursor: true,
				autoHeight: true,
				speed: slideSpeed,
				autoplay: autoParams,
				breakpointsInverse: true,
				breakpoints: {
					768: {
						slidesPerView: colSlide.tablet,
						spaceBetween: 30
					},
					992: {
						slidesPerView: colSlide.def,
						spaceBetween: 40
					}
				},
				pagination: {
					el: '.swiper-pagination',
					clickable: true,
				},
			});
		},

		portoSlideWd: function() {
			var d=this, $portoCarousel = $('.portfolio-carousel-contain'), portfolioSwiper = [];

			if ( $portoCarousel.length > 0 ) {
				$portoCarousel.each(function(x) {
					var colSlide = $(this).data('colnumb');
					if ( typeof portfolioSwiper[x] !== 'undefined' ) {
						portfolioSwiper[x].destroy(true, true);
					}
					$(this).attr('id', 'portoCarousel'+x);
					portfolioSwiper[x] = new Swiper('#portoCarousel'+x, {
						slidesPerView: colSlide.mobile,
						spaceBetween: 20,
						grabCursor: true,
						navigation: {
							nextEl: '#portoCarousel'+x+' .portfolio-carousel-btn-next',
							prevEl: '#portoCarousel'+x+' .portfolio-carousel-btn-prev',
						},
						breakpointsInverse: true,
						breakpoints: {
							768: {
								slidesPerView: colSlide.tablet,
								spaceBetween: 30
							},
							992: {
								slidesPerView: colSlide.def,
								spaceBetween: 40
							}
						},
						on: {
							init: function() {
								if ( /iPad|iPhone|iPod|Android/.test(navigator.userAgent) ) {
									$('#portoCarousel'+x).find('img').css({opacity:1});
									$('#portoCarousel'+x).find('.portfolio-carousel-item').addClass('is-touch')
								} else {
									$('#portoCarousel'+x).find('.portfolio-carousel-img').each(function(){
										var src = $(this).find('img').attr('src'),
											dl = $('<div class="dl" />'),
											dr = $('<div class="dr" />');

										$(this).append(dl).append(dr);
										$(dl).css({backgroundImage: 'url('+src+')'});
										$(dr).css({backgroundImage: 'url('+src+')'});

										src = dl = dr = null;
									});
								}
							},
						}
					});
				});

				var $pcitem = $('.portfolio-carousel-item');
				$pcitem.on('mouseover', function() {
					var k=this;
					$pcitem.not(k).css({opacity: .5});
				}).on('mouseleave', function() {
					$pcitem.css({opacity: ''});
				});
			}
		},

		portoGalSlideInit: function( $scope ) {
			var d=this, x=$($scope);
			
			if ( ! x.hasClass('br-carousel-gallery-container') ) {
				x = x.find('.br-carousel-gallery-container');
				x = $(x);
			}

			if ( x.hasClass('alreadyInited') ) {
				return false;
			}
			x.addClass('alreadyInited');

			x.find('.br-carousel-item').each(function() {
				var _src = $(this).find('img').attr('src'),
					bg = $(this).find('.br-carousel-bg');
					bg[0].style.backgroundImage = 'url("'+_src+'")';
			});

		  	var interleaveOffset = 0.5,
		  		pcSlideTotal = x.find('.br-carousel-item').length;

			var swiper = new Swiper( x[0], {
					loop: false,
					slidesPerView: 1,
					spaceBetween: 0,
					grabCursor: true,
					watchSlidesProgress: true,
					navigation: {
						nextEl: x.find('.br-gallery-carousel-btn-next')[0],
						prevEl: x.find('.br-gallery-carousel-btn-prev')[0],
					},
					speed: 700,
					autoplay: {
						delay: 5000,
						disableOnInteraction: false,
					},
					// modify the effect of Swiper transition
					// source : https://codepen.io/udovichenko/pen/LGeQae
					on: {
						init: function() {
							var $markup = $('<div class="total-slide"><span class="slide-current">01</span>/<span class="slide-total">0'+pcSlideTotal+'</span></div>');

							$markup.insertAfter( x.find('.br-gallery-carousel-btn-prev') );
							$markup = null;
						},
						slideChange: function() {
							var swiper = this,
								crt = "0"+(swiper.realIndex+1);

							x.find('.slide-current').html(crt);
							crt = null;
						},
						progress: function() {
							var swiper = this;
							for (var i = 0; i < swiper.slides.length; i++) {
								var slideProgress = swiper.slides[i].progress;
								var innerOffset = swiper.width * interleaveOffset;
								var innerTranslate = slideProgress * innerOffset;
								
								swiper.slides[i].querySelector(".br-carousel-bg").style.webkitTransform = "translate3d(" + innerTranslate + "px, 0, 0)";
								swiper.slides[i].querySelector(".br-carousel-bg").style.transform = "translate3d(" + innerTranslate + "px, 0, 0)";
							}
						},
						touchStart: function() {
							var swiper = this;
							for (var i = 0; i < swiper.slides.length; i++) {
								swiper.slides[i].style.transition = "";
							}
						},
						setTransition: function(speed) {
							var swiper = this;
							for (var i = 0; i < swiper.slides.length; i++) {
								swiper.slides[i].style.webkitTransition = speed + "ms";
								swiper.slides[i].style.transition = speed + "ms";
								swiper.slides[i].querySelector(".br-carousel-bg").style.webkitTransition = speed + "ms";
								swiper.slides[i].querySelector(".br-carousel-bg").style.transition = speed + "ms";
							}
						}
					}
				});
		},

		portoGalSlide: function() {
			var d=this;

			if ( $('.br-carousel-gallery-container').length ) {
				$('.br-carousel-gallery-container').each(function() {
					var x = this;
					d.portoGalSlideInit(x);
				});
			}    
		},

		funcCaller: function() {
			var d=this;

			d.portoSlideWd();
			d.wooSlider();
			d.portoGalSlide();

			// Testimonial carousel
			if ( $('.testimonial-carousel-contain').length ) {
				var testiSwiper = new Swiper ('.testimonial-carousel-contain', {
					slidesPerView: 1,
					spaceBetween: 0,
					grabCursor: false,
					navigation: {
						nextEl: '.testimonial-carousel-btn-next',
						prevEl: '.testimonial-carousel-btn-prev',
					},
					speed: 800,
					effect: 'fade',
					fadeEffect: {
						crossFade: true,
					},
					autoplay: {
						delay: 5000,
						disableOnInteraction: false,
					},
					on: {
						init: function() {
							var $slideTotal = $('.testimonial-carousel-contain').find('.br-testimonial').length,
								$markup = $('<div class="total-slide"><span class="slide-current">01</span>/<span class="slide-total">0'+$slideTotal+'</span></div>');

							$markup.insertAfter( $('.testimonial-carousel-btn-prev') );
							$slideTotal = $markup = null;
						},
						slideChange: function() {
							var crt = "0"+(testiSwiper.activeIndex+1);
							$('.testimonial-carousel-contain').find('.slide-current').html(crt);
							crt = null;
						},
					}
				});
			}

			// Client slide/carousel
			if ( $('.client-carousel-contain').length ) {
				var clientSwiper = new Swiper ('.client-carousel-contain', {
					slidesPerView: 2,
					spaceBetween: 20,
					grabCursor: true,
					breakpointsInverse: true,
					breakpoints: {
						768: {
							slidesPerView: 3,
						},
						992: {
							slidesPerView: 4,
						}
					},
					speed: 500,
					loop: true,
					autoplay: {
						delay: 5000,
						disableOnInteraction: false,
					},
				});				
			}

			// Portfolio grid helper
			if ( $('.portfolio-grid-lists').length && /iPad|iPhone|iPod|Android/.test(navigator.userAgent) === false ) {
				if ( typeof VanillaTilt !== "undefined" ) {
					VanillaTilt.init(document.querySelectorAll(".portfolio-grid-link"),{
						max:15,
						speed:600,
						scale: 1.05,
						easing: 'cubic-bezier(0,0.29,0.58,1)'
					});
				}

				var flyingPorto = new window.appear({
					elements: function elements() {
						return document.getElementsByClassName('portfolio-grid-item');
					},
					appear: function appear(el) {
						$(el).addClass('onAppear');
					},
					disappear: function disappear(el) {
						$(el).removeClass('onAppear');
					},
					reappear: function reappear(el) {
						$(el).addClass('onAppear');
					},
					bounds: 0
				});
			}

			d.objectFitFix();
			// circle progress
			d.circleProgress();
			// masonry init
			d.masonryInit();
			// Lightbox
			d.magnificPopupInit();
			d.floatEdgeMedia();
			d.floatEdgeMediaOrig();
			d.teamProfileInit();
			d.mejsInit();
			d.widgetMenus();

			if ( $('.brayn-page--404').length ) {
				d.errorPageAnimate();
			}
		},

		widgetMenus: function() {
			var t=this,widgetMenu = $('.widget_nav_menu'),
				wdHasChild = widgetMenu.find('.menu-item-has-children'),
				wdCats = $('.widget_categories, .widget_pages, .widget_product_categories'),
				wdCatsHasChild = wdCats.find('.children');

			if ( wdHasChild.length ) {
				$(wdHasChild).each(function() {
					var z=this,arrow = '<span class="arrow-wd-down"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M256 294.1L383 167c9.4-9.4 24.6-9.4 33.9 0s9.3 24.6 0 34L273 345c-9.1 9.1-23.7 9.3-33.1.7L95 201.1c-4.7-4.7-7-10.9-7-17s2.3-12.3 7-17c9.4-9.4 24.6-9.4 33.9 0l127.1 127z"/></svg></span>';

					if ( $(z).find('>ul').length < 1 ) {
						return;
					}

					$(z).find('>ul').hide();

					if ( $(z).find('>.arrow-wd-down').length < 1 ) {
						$(arrow).insertAfter( $(z).find('>a') );
					} else {
						if ( $(z).find('>.arrow-wd-down').hasClass('rtt') ) {
							$(z).find('>ul').attr('style','');
						}
					}
				});
			}

			if ( wdCatsHasChild.length ) {
				$(wdCatsHasChild).each(function() {
					var z=this,arrow = '<span class="arrow-wd-down"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M256 294.1L383 167c9.4-9.4 24.6-9.4 33.9 0s9.3 24.6 0 34L273 345c-9.1 9.1-23.7 9.3-33.1.7L95 201.1c-4.7-4.7-7-10.9-7-17s2.3-12.3 7-17c9.4-9.4 24.6-9.4 33.9 0l127.1 127z"/></svg></span>';

					$(z).hide();

					if ( $(z).parent('li').find('>.arrow-wd-down').length < 1 ) {
						$(arrow).insertAfter( $(z).parent('li').find('>a') );
					} else {
						if ( $(z).parent('li').find('>.arrow-wd-down').hasClass('rtt') ) {
							$(z).attr('style','');
						}
					}
				});
			}

			$('.arrow-wd-down').each(function() {
				var ayd = this;
				$(ayd).off().on('click', function(e) {
					e.preventDefault();
					if ( ! $(this).hasClass('rtt') ) {
						$(ayd).parent('li').find('>ul').slideDown(200);
						$(this).addClass('rtt');
					} else {
						$(ayd).parent('li').find('>ul').slideUp(200);
						$(this).removeClass('rtt');
					}
				});
			});
		},

		errorPageAnimate: function() {
			var t=this, errAnm;

			errAnm = anime.timeline({
				loop: false,
			});

			errAnm.add({
				targets: ['.brayn-error-page-heading span:first-child', '.brayn-error-page-heading span:last-child'],
				opacity: [0,1],
				translateY: [100,0],
				duration: 700,
				easing: 'easeInOutCirc',
				delay: 500
			}).add({
				targets: '.brayn-error-page-heading span:not(:first-child):not(:last-child)',
				opacity: [0,1],
				translateY: [-100,0],
				duration: 700,
				easing: 'easeInOutCirc',
			}, '-=700').add({
				targets: ['.brayn-page--404-content p', '.brayn-page--404-content a'],
				opacity: [0,1],
				translateY: [50,0],
				duration: 700,
				easing: 'easeInOutCirc',
				delay: function(el, i, l) { return i * 50; },
			});
		},

		mejsInit: function() {
			var t=this, mediaSettings=false;

			if ( typeof MediaElementPlayer !== 'undefined' ) {
				mediaSettings = window._wpmejsSettings || {};
				mediaSettings.features = mediaSettings.features || mejs.MepDefaults.features;
				mediaSettings.features.push( 'exampleclass' );
				MediaElementPlayer.prototype.buildexampleclass = function( player ) {
					$('#'+player.id).addClass( 'brayn-mejs-container' );
				};
			}

			if ( $('audio').length ) {
				if ( typeof MediaElementPlayer === 'undefined' ) {
					return false;
				}

				$('audio').each( function(i) {
					var pr = $(this).parent();
					if ( pr[0].nodeName.toLowerCase() === 'mediaelementwrapper' ) {
						return;
					}

					$(this).attr('id', 'brayn-audio'+i );
					$('#brayn-audio'+i).mediaelementplayer(mediaSettings);
				});
			}

			if ( $('video').length ) {
				if ( typeof MediaElementPlayer === 'undefined' ) {
					return false;
				}

				$('video').each( function(vi) {
					var vpr = $(this).parent();
					
					if ( vpr[0].nodeName.toLowerCase() === 'mediaelementwrapper' ) {
						return;
					}

					if ( $(this).hasClass('wp-block-cover__video-background') ) {
						return;
					}

					if ( $(this).hasClass('elementor-html5-video') || $(this).hasClass('elementor-video') ) {
						return;
					}

					$(this).attr('id', 'brayn-video'+vi ).attr('width', '640').attr('height', '362').attr('preload', 'true').css({ width: '100%', height: '100%'});

					$('#brayn-video'+vi).mediaelementplayer(mediaSettings);
				});
			}
		},

		teamProfileInit: function() {
			var d=this;

			$('.team-card').each(function() {
				if ( /iPad|iPhone|iPod|Android/.test(navigator.userAgent) === false ) {
					$(this).addClass('untouched');
				} else {
					$(this).removeClass('untouched');
				}
			});
		},

		floatEdgeMediaOrig: function() {
			if ( $('.container').length < 1 ) {
				return false;
			}

			var d=this, lft=$('.container').offset().left, pl= parseFloat($('.container').css('padding-left'));

			$('.br-float-right-edge-tmp').each(function() {
				var _x=this,w;
				
				$(_x).removeAttr('style');
				w = $(_x).width();

				_x.style.width = (w+lft+pl)+'px';
				_x.style.position = 'relative';
				_x.style.marginRight = ((lft+pl)*-1)+'px';
			});

			$('.br-float-left-edge-tmp').each(function() {
				var _x=this,w;
				
				$(_x).removeAttr('style');
				w = $(_x).width();

				_x.style.width = (w+lft+pl)+'px';
				_x.style.position = 'relative';
				_x.style.marginLeft = ((lft+pl)*-1)+'px';
			});
		},

		floatEdgeMedia: function() {
			var d=this;

			if ( typeof elementorCommonConfig === "undefined" ) {
				return false;
			}

			$('.br-float-right-edge').each(function() {
				var _x=this,
					ctr = ( elementorCommonConfig.version.charAt(0) === '2' ? $(_x).parents('.elementor-row') : $(_x).parents('.elementor-container') ),
					cw = ( elementorCommonConfig.version.charAt(0) === '2' ? $(_x).parents('.elementor-column-wrap') : $(_x).parents('.elementor-element') ),
					lft, pl, w;

				lft=$(ctr).offset().left;
				pl = parseFloat($(cw).css('padding-left'));
				$(_x).removeAttr('style');
				$(_x).find('.elementor-widget-container').removeAttr('style');
				w = $(_x).width();

				if ( (w+pl+pl) >= $(window).width() ) {
					$(_x).find('.elementor-widget-container')[0].style.position = 'relative';
					$(_x).find('.elementor-widget-container')[0].style.marginLeft = ((lft+pl)*-1)+'px';
					$(_x).find('.elementor-widget-container')[0].style.marginRight = ((lft+pl)*-1)+'px';

					if ( $(_x).hasClass('as-bg')) {
						var imUrl = $(_x).find('img').attr('src');
						$(_x).find('img').css({opacity: 0});
						$(_x).find('.elementor-widget-container')[0].style.backgroundImage = 'url('+imUrl+')';
						$(_x).find('.elementor-widget-container')[0].style.backgroundRepeat = 'no-repeat';
						$(_x).find('.elementor-widget-container')[0].style.backgroundSize = 'cover';
						$(_x).find('.elementor-widget-container')[0].style.backgroundPosition = 'center';
						$(_x).find('.elementor-widget-container')[0].style.backgroundAttachment = 'scroll';
					}
				} else {
					_x.style.width = (w+lft+pl)+'px';
					_x.style.position = 'relative';
					_x.style.marginRight = ((lft+pl)*-1)+'px';

					if ( $(_x).hasClass('as-bg')) {
						var imUrl = $(_x).find('img').attr('src');
						$(_x).find('img').css({opacity: 0});
						_x.style.height = '100%';
						_x.style.backgroundImage = 'url('+imUrl+')';
						_x.style.backgroundRepeat = 'no-repeat';
						_x.style.backgroundSize = 'cover';
						_x.style.backgroundPosition = 'center';
						_x.style.backgroundAttachment = 'scroll';
					}
				}
			});

			$('.br-float-left-edge').each( function() {
				var _x=this,
					ctr = ( elementorCommonConfig.version.charAt(0) === '2' ? $(_x).parents('.elementor-row') : $(_x).parents('.elementor-container') ),
					cw = ( elementorCommonConfig.version.charAt(0) === '2' ? $(_x).parents('.elementor-column-wrap') : $(_x).parents('.elementor-element') ),
					lft, pl, w;

				lft=$(ctr).offset().left;
				pl = parseFloat($(cw).css('padding-left'));
				$(_x).removeAttr('style');
				$(_x).find('.elementor-widget-container').removeAttr('style');
				w = $(_x).width();

				if ( (w+pl+pl) >= $(window).width() ) {
					$(_x).find('.elementor-widget-container')[0].style.position = 'relative';
					$(_x).find('.elementor-widget-container')[0].style.marginLeft = ((lft+pl)*-1)+'px';
					$(_x).find('.elementor-widget-container')[0].style.marginRight = ((lft+pl)*-1)+'px';

					if ( $(_x).hasClass('as-bg')) {
						var imUrl = $(_x).find('img').attr('src');
						$(_x).find('img').css({opacity: 0});
						$(_x).find('.elementor-widget-container')[0].style.backgroundImage = 'url('+imUrl+')';
						$(_x).find('.elementor-widget-container')[0].style.backgroundRepeat = 'no-repeat';
						$(_x).find('.elementor-widget-container')[0].style.backgroundSize = 'cover';
						$(_x).find('.elementor-widget-container')[0].style.backgroundPosition = 'center';
						$(_x).find('.elementor-widget-container')[0].style.backgroundAttachment = 'scroll';
					}
				} else {
					_x.style.width = (w+lft+pl)+'px';
					_x.style.position = 'relative';
					_x.style.marginLeft = ((lft+pl)*-1)+'px';

					if ( $(_x).hasClass('as-bg')) {
						var imUrl = $(_x).find('img').attr('src');
						$(_x).find('img').css({opacity: 0});
						_x.style.height = '100%';
						_x.style.backgroundImage = 'url('+imUrl+')';
						_x.style.backgroundRepeat = 'no-repeat';
						_x.style.backgroundSize = 'cover';
						_x.style.backgroundPosition = 'center';
						_x.style.backgroundAttachment = 'scroll';
					}
				}
			});
		},

		animatedNumber: function(el) {
			var d=this, fnlObj, fnl=$(el).data('final-number'), drt=(typeof $(el).data('duration') === 'undefined') ? 1500 : $(el).data('duration');

			if ( typeof fnl === 'undefined' ) {
				return false;
			}
			fnlObj = {progress: 0};
			anime({
				targets: fnlObj,
				progress: [0, fnl],
				duration: Math.round(drt),
				easing: 'easeInSine',
				update: function() {
					$(el).html( Math.round(fnlObj.progress).toLocaleString() );
				}
			});
		},

		magnificPopupInit: function() {
			var d=this;

			if ( $('.wp-block-gallery').length ) {
				d.mfpCallInit( '.wp-block-gallery' );
			}

			if ( $('.widget_media_gallery').length ) {
				d.mfpCallInit( '.widget_media_gallery' );
			}

			if ( $('.widget_media_image').length ) {
				d.mfpCallInit( '.widget_media_image' );
			}

			if ( $('.full-size-link').length ) {
				d.mfpCallInit( '.full-size-link' );
			}
		},

		mfpCallInit: function( el ) {
			$(el).each( function() {
				var f=this, gal=false;
				if ( $(f).find('a').length ) {
					$(f).find('a').each( function(i, el) {
						var href_value = el.href;
						if (/\.(jpg|jpeg|png|gif)$/.test(href_value)) {
							gal=true;
						}
					});

					if ( gal ) {
						$(f).magnificPopup({
							delegate: 'a',
							type: 'image',
							removalDelay: 300,
							mainClass: 'mfp-fade',
							gallery:{
								enabled:true
							}
						});
					}
				}
			});
		},

		/**
		 * Circular progress helper,
		 * Used on Elementor editor view
		 *
		 * @since 1.0.0
		 */
		circleProgressOnEditor: function( $scope ) {
			var d=this;
			var _x= $($scope).find('.br-circle-progress'), r= 0,
				c = document.createDocumentFragment(),
				data = $(_x).data('progress');

			var svg = document.createElementNS("http://www.w3.org/2000/svg", "svg"),
				circ = document.createElementNS("http://www.w3.org/2000/svg", "circle"),
				circBG = document.createElementNS("http://www.w3.org/2000/svg", "circle"),
				progText = document.createElementNS("http://www.w3.org/2000/svg", "text");
		
			svg.setAttribute( 'viewBox', '0 0 250 250');
			svg.setAttribute( 'width', '250');
			svg.setAttribute( 'height', '250');
			c.appendChild(svg);
			svg.appendChild(circBG);
			svg.appendChild(circ);
			svg.appendChild(progText);

			circ.setAttribute( 'class', 'circ-to-progress' );
			circ.setAttribute( 'fill', 'none' );
			circ.setAttribute( 'stroke', data['color'] );
			circ.setAttribute( 'cx', '125' );
			circ.setAttribute( 'cy', '125' );

			circBG.setAttribute( 'fill', 'none' );
			circBG.setAttribute( 'stroke', data['background'] );
			circBG.setAttribute( 'cx', '125' );
			circBG.setAttribute( 'cy', '125' );

			progText.setAttribute('x', '50%');
			progText.setAttribute('y', '50%');
			progText.setAttribute('dominant-baseline', 'middle');
			progText.setAttribute('text-anchor', 'middle');

			progText.innerHTML = data.percent;

			r = (250/2)-(30/2);
			circ.setAttribute( 'r', r );
			circ.setAttribute( 'stroke-width', '30');
			circ.setAttribute( 'opacity', '0');

			circBG.setAttribute( 'r', r );
			circBG.setAttribute( 'stroke-width', '30');

			switch( data.size ) {
				case 'small':
					svg.setAttribute( 'class', 'svg-circle small' );
				break;
				case 'big':
					svg.setAttribute( 'class', 'svg-circle big' );
				break;
				case 'medium':
				default:
					svg.setAttribute( 'class', 'svg-circle medium' );
				break;
			}
			circ.setAttribute('stroke-dashoffset',(2*Math.PI*r)*(1-(parseInt(data.percent)/100)));
			circ.setAttribute('stroke-dasharray', 2*Math.PI*r );
			circ.setAttribute('transform', 'rotate(-90, 125, 125)');

			$(_x).html('');
			$(_x)[0].appendChild(c);
		},

		/**
		 * Circular progress helper
		 *
		 * @since 1.0.0
		 */
		circleProgress: function() {
			var d=this;

			$('.br-circle-progress').each(function() {
				var _x=this, r= 0,
					c = document.createDocumentFragment(),
					data = $(_x).data('progress');

				$(_x).html('');

				var svg = document.createElementNS("http://www.w3.org/2000/svg", "svg"),
					circ = document.createElementNS("http://www.w3.org/2000/svg", "circle"),
					circBG = document.createElementNS("http://www.w3.org/2000/svg", "circle"),
					progText = document.createElementNS("http://www.w3.org/2000/svg", "text");
				svg.setAttribute( 'viewBox', '0 0 250 250');
				svg.setAttribute( 'width', '250');
				svg.setAttribute( 'height', '250');
				c.appendChild(svg);
				svg.appendChild(circBG);
				svg.appendChild(circ);
				svg.appendChild(progText);

				circ.setAttribute( 'class', 'circ-to-progress' );
				circ.setAttribute( 'fill', 'none' );
				circ.setAttribute( 'stroke', data['color'] );
				circ.setAttribute( 'cx', '125' );
				circ.setAttribute( 'cy', '125' );

				circBG.setAttribute( 'fill', 'none' );
				circBG.setAttribute( 'stroke', data['background'] );
				circBG.setAttribute( 'cx', '125' );
				circBG.setAttribute( 'cy', '125' );

				progText.setAttribute('x', '50%');
				progText.setAttribute('y', '50%');
				progText.setAttribute('dominant-baseline', 'middle');
				progText.setAttribute('text-anchor', 'middle');

				progText.innerHTML = data.percent;

				r = (250/2)-(30/2);
				circ.setAttribute( 'r', r );
				circ.setAttribute( 'stroke-width', '30');
				circ.setAttribute( 'opacity', '0');

				circBG.setAttribute( 'r', r );
				circBG.setAttribute( 'stroke-width', '30');

				switch( data.size ) {
					case 'small':
						svg.setAttribute( 'class', 'svg-circle small' );
						break;
					case 'big':
						svg.setAttribute( 'class', 'svg-circle big' );
						break;
					case 'medium':
					default:
						svg.setAttribute( 'class', 'svg-circle medium' );
						break;
				}
				circ.setAttribute('stroke-dashoffset',(2*Math.PI*r)*(1-(parseInt(data.percent)/100)));
				circ.setAttribute('stroke-dasharray', 2*Math.PI*r );
				circ.setAttribute('transform', 'rotate(-90, 125, 125)');
				
				_x.appendChild(c);
			});
		},

		objectFitFix: function() {
			var d=this;

			if('objectFit' in document.documentElement.style === false) {
				$('.post-grid-minimal-bg').each(function() {
					var el = this;
					if ( $(el).find('img').length > 0 ) {
						var imgUrl = $(el).find('img').attr('src');
						el.style.backgroundImage = 'url('+imgUrl+')';
						$(el).addClass('objFitBg');
						$(el).find('img').detach();
					}
				});
			}
		},

		masonryMetroInit: function( el ) {
			var d=this, metroGallery, x=$(el), ol;

			if ( ! x.hasClass('br-metro-gallery') ) {
				var bx = $(el).find('.br-metro-gallery');
				x = $(bx);
			}

			ol = x.find('.metro-grid');

			metroGallery = $(ol).masonry({
				itemSelector: '.metro-grid-item',
				columnWidth: '.metro__sizer',
				percentPosition: true,
				transitionDuration: '0.3s',
				gutter: 0,
			});

			metroGallery.masonry().masonry('layout');
		},

		masonryDefaultInit: function( el ) {
			var d=this, masonGallery, x=$(el), ol;

			if ( ! x.hasClass('br-masonry-gallery') ) {
				var bx = $(el).find('.br-masonry-gallery');
				x = $(bx);
			}

			ol = x.find('.masonry-grid');

			masonGallery = $(ol).masonry({
				itemSelector: '.masonry-grid-item',
				columnWidth: '.masonry__sizer',
				percentPosition: true,
				transitionDuration: '0.3s',
				gutter: 0,
			});

			masonGallery.masonry().masonry('layout');
		},

		masonryInit: function() {
			var d=this;

			if ( $('.br-masonry-gallery').length ) {
				$('.br-masonry-gallery').each(function() {
					var el = this;
					d.masonryDefaultInit( el );
				});
			}

			if ( $('.br-metro-gallery').length ) {
				$('.br-metro-gallery').each(function() {
					var el = this;
					d.masonryMetroInit( el );
				});
			}

			if ( $('.masonry-post').length ) {
				var masonPost;
				masonPost = $('.masonry-post').masonry({
					itemSelector: '.col-post-loop',
					percentPosition: true,
					transitionDuration: '0.3s',
					gutter: 0,
				});
				masonPost.masonry().masonry('layout');
			}
		},

		watchPortfolioGridItems: function() {
			var d=this,curScroll=d.$win.scrollTop();

			if ( $('.portfolio-grid-lists').length ) {
				$('.onAppear').each(function() {
					var _x=this, move = 0;
					if ( !$(_x).hasClass('onAppear') ) {
						return;
					}

					var intercept = curScroll-d.$win.height();
					var followScroll = ( $(_x).find('.portfolio-grid-obj').css('transform') !== 'none' ) ? true : false;

					if ( curScroll > d.origScroll ) {
						move = followScroll ? intercept/75 : (intercept/75)*-1;
					} else {
						move = followScroll ? (intercept/75)*-1 : intercept/75;
					}
					$(_x).css({
						'will-change' : 'transform',
						'-webkit-backface-visibility' : 'hidden',
						'perspective' : '1000px',
						'-webkit-transform': 'translate3d(0, '+move+'px, 0)',
						transform: 'translate3d(0, '+move+'px, 0)',
					});
				});
			}
			d.origScroll = curScroll;
		},

		customPointerInit: function() {
			var d=this;

			// If feature is disabled OR we on a touch enable device, stop it.
			if ( ! $('body').hasClass('custom-pointer') || ('ontouchstart' in document.documentElement) ) {
				return false;
			}

			var cp = $('<canvas id="brayn-custom-pointer" width="50" height="50"></canvas>');
			$('body').append(cp);
			var c = document.getElementById("brayn-custom-pointer");
			var ctx = c.getContext("2d");
			ctx.beginPath();
			ctx.arc(25, 25, 20, 0, 2 * Math.PI, true);
			ctx.strokeStyle = "rgba(0,0,0, .65)";
			ctx.stroke();
			ctx.beginPath();
			ctx.arc(25, 25, 21, 0, 2 * Math.PI, true);
			ctx.strokeStyle = "rgba(255,255,255, .65)";
			ctx.stroke();
			$('#brayn-custom-pointer').css({
				position: 'fixed',
				zIndex: 99,
				top: '0',
				left: '0',
				pointerEvents: 'none',
				mixBlendMode : 'screen'
			});

			d.attachPointerEvents();
		},

		attachPointerEvents: function() {
			var d=this;
			document.getElementsByTagName("body")[0].addEventListener("mousemove", function(e) {
				var locX = e.clientX-25,
					locY = e.clientY-25;

				document.getElementById("brayn-custom-pointer").style.webkitTransform = 'translate3D('+locX+'px, '+locY+'px, 0)';
				document.getElementById("brayn-custom-pointer").style.mozTransform = 'translate3D('+locX+'px, '+locY+'px, 0)';
				document.getElementById("brayn-custom-pointer").style.transform = 'translate3D('+locX+'px, '+locY+'px, 0)';
			});
		},

		circProg: function() {
			var circProg = $('.br-circle-progress');

			if ( circProg.length && typeof window.appear !== 'undefined' ) {
				var circularAppear = new window.appear({
					elements: function elements() {
						return document.getElementsByClassName('svg-circle');
					},
					appear: function appear(el,i) {
						if ( $(el).hasClass('done-animate') ) {
							return;
						}

						$(el).addClass( 'done-animate' );
						var cAnim, cDash = $(el).find('.circ-to-progress').attr('stroke-dashoffset'),
							cDarray = $(el).find('.circ-to-progress').attr('stroke-dasharray'),
							cProg = $(el).find('text').html(),
							cProgdata = { progress: 0 };

						cAnim = anime.timeline({
							autoplay: true,
						});
						$(el).find('.circ-to-progress').attr('stroke-dashoffset', cDarray).attr('opacity', 1);
						$(el).find('text').html('');
						cAnim.add({	
							targets: $(el).find('.circ-to-progress')[0],
							strokeDashoffset: [cDarray, cDash],
							duration: 1200,
							delay: 100,
							easing: 'easeInOutCirc'
						}).add({
							targets: cProgdata,
							progress: cProg,
							duration: 1200,
							delay: 100,
							easing: 'easeInOutSine',
							update: function() {
								$(el).find('text').html( Math.round(cProgdata.progress)+'%');
							}
						}, '-=1200');
					},
					bounds: 0
				});
			}  
		},

		prettyReveal: function() {
			var d=this,
				fbi=$('.full-img-block'),
				circProg = $('.br-circle-progress');

			//var ef=$('.has-reveal-effect');
			var ef=$('.has-reveal-effect');

			if ( circProg.length && typeof window.appear !== 'undefined' ) {
				var circularAppear = new window.appear({
					elements: function elements() {
						return document.getElementsByClassName('svg-circle');
					},
					appear: function appear(el,i) {
						if ( $(el).hasClass('done-animate') ) {
							return;
						}

						$(el).addClass( 'done-animate' );
						var cAnim, cDash = $(el).find('.circ-to-progress').attr('stroke-dashoffset'),
							cDarray = $(el).find('.circ-to-progress').attr('stroke-dasharray'),
							cProg = $(el).find('text').html(),
							cProgdata = { progress: 0 };
						
						cAnim = anime.timeline({
							autoplay: true,
						});
						$(el).find('.circ-to-progress').attr('stroke-dashoffset', cDarray).attr('opacity', 1);
						$(el).find('text').html('');
						cAnim.add({
							targets: $(el).find('.circ-to-progress')[0],
							strokeDashoffset: [cDarray, cDash],
							duration: 1200,
							delay: 100,
							easing: 'easeInOutCirc'
						}).add({
							targets: cProgdata,
							progress: cProg,
							duration: 1200,
							delay: 100,
							easing: 'easeInOutSine',
							update: function() {
								$(el).find('text').html( Math.round(cProgdata.progress)+'%');
							}
						}, '-=1200');
					},
					bounds: 0
				});
			}

			if ( $('.br-animated-number').length && typeof window.appear !== 'undefined' ) {
				var animNumberReveal = new window.appear({
					elements: function elements() {
						return document.getElementsByClassName('br-animated-number');
					},
					appear: function appear(el,i) {
						if ( $(el).hasClass('done-animate') ) {
							return;
						}

						$(el).addClass( 'done-animate' );
						
						// animated number
						d.animatedNumber( el );

					},
					bounds: 0
				}); 
			}

			if ( fbi.length && typeof window.appear !== 'undefined' ) {
				var fbiAppear = new window.appear({
					elements: function elements() {
						return document.getElementsByClassName('full-img-block');
					},
					appear: function appear(el) {
						if ( $(el).hasClass('done-animate') ) {
							return;
						}

						$(el).addClass( 'done-animate' );
						new pSlideCanvas( el, el, 'appear', 'assets/images/clouds.jpg', {width: $(el).width(), height: $(el).height()} );
					},
					bounds: 0
				});
			}

			if ( ef.length && typeof window.appear !== 'undefined' ) {
				var globReveal = new window.appear({
						elements: function elements() {
							return document.getElementsByClassName('has-reveal-effect');
						},
						appear: function appear(el, dly) {
							if ( $(el).hasClass('done-animate') ) {
								return;
							}

							var effect = $(el).data('effect');
							if ( typeof effect === 'undefined' ) {
								// default
								effect = 'fadeInTop';
							}

							$(el).addClass( 'done-animate' );

							switch( effect ) {
								case 'revealRight':
									$(el).css({opacity:1});
									var rx = $('<span class="revealer" />');
									$(el).addClass('revealOnProc').append( rx );
									
									rx.css({
										left: 0,
										top: 0,
										width: 0,
									});
									anime({
										targets: $(rx)[0],
										width: ['0%', '100%'],
										duration: 300,
										easing: 'easeInOutCirc',
										complete: function() {
											$(rx).css({
												left : 'initial',
												right: 0,
											});
											$(el).removeClass('revealOnProc');

											anime({
												targets: $(rx)[0],
												width: 0,
												duration: 300,
												easing: 'easeInOutCirc',
												delay: 200,
												complete: function() {
													$(el).removeClass('has-reveal-effect').css({opacity: '', transform: '', '-webkit-transform': ''});
													$(rx).remove(); 
												}
											});
										},
										delay: function(el) { return dly * 50; },
									});
								break;
								case 'revealLeft':
									$(el).css({opacity:1});
									var rx = $('<span class="revealer" />');
									$(el).addClass('revealOnProc').append( rx );
									rx.css({
										right: 0,
										top: 0,
										width: 0,
									});
									anime({
										targets: $(rx)[0],
										width: ['0%', '100%'],
										duration: 300,
										easing: 'easeInOutCirc',
										complete: function() {
											$(rx).css({
												right : 'initial',
												left: 0,
											});
											$(el).removeClass('revealOnProc');

											anime({
												targets: $(rx)[0],
												width: 0,
												duration: 300,
												easing: 'easeInOutCirc',
												delay: 200,
												complete: function() {
													$(el).removeClass('has-reveal-effect').css({opacity: '', transform: '', '-webkit-transform': ''});
													$(rx).remove(); 
												}
											});
										},
										delay: function(el) { return dly * 50; },
									});
								break;
								case 'revealTop':
									$(el).css({opacity:1});
									var rx = $('<span class="revealer" />');
									$(el).addClass('revealOnProc').append( rx );
									rx.css({
										right: 0,
										left: 0,
										bottom: 0,
										height: 0,
									});
									anime({
										targets: $(rx)[0],
										height: ['0%', '100%'],
										duration: 300,
										easing: 'easeInOutCirc',
										complete: function() {
											$(rx).css({
												bottom : 'initial',
												top: 0,
											});
											$(el).removeClass('revealOnProc');

											anime({
												targets: $(rx)[0],
												height: 0,
												duration: 300,
												easing: 'easeInOutCirc',
												delay: 200,
												complete: function() {
													$(el).removeClass('has-reveal-effect').css({opacity: '', transform: '', '-webkit-transform': ''});
													$(rx).remove(); 
												}
											});
										},
										delay: function(el) { return dly * 50; },
									});
								break;
								case 'revealBottom':
									$(el).css({opacity:1});
									var rx = $('<span class="revealer" />');
									$(el).addClass('revealOnProc').append( rx );
									rx.css({
										right: 0,
										left: 0,
										top: 0,
										height: 0,
									});
									anime({
										targets: $(rx)[0],
										height: ['0%', '100%'],
										duration: 300,
										easing: 'easeInOutCirc',
										complete: function() {
											$(rx).css({
												top : 'initial',
												bottom: 0,
											});
											$(el).removeClass('revealOnProc');

											anime({
												targets: $(rx)[0],
												height: 0,
												duration: 300,
												easing: 'easeInOutCirc',
												delay: 200,
												complete: function() {
													$(el).removeClass('has-reveal-effect').css({opacity: '', transform: '', '-webkit-transform': ''});
													$(rx).remove(); 
												}
											});
										},
										delay: function(el) { return dly * 50; },
									});
								break;
								case 'fadeIn':
									anime({
										targets: el,
										opacity: [0,1],
										duration: 500,
										easing: 'easeInOutSine',
										complete: function() {
											$(el).removeClass('has-reveal-effect').css({opacity: '', transform: '', '-webkit-transform': ''});
										},
										delay: function(el) { return dly * 50; },
									});
								break;
								case 'fadeInLeft':
									anime({
										targets: el,
										opacity: [0,1],
										translateX: [75, 0],
										duration: 500,
										easing: 'easeInOutSine',
										complete: function() {
											$(el).removeClass('has-reveal-effect').css({opacity: '', transform: '', '-webkit-transform': ''});
										},
										delay: function(el) { return dly * 50; },
									});
								break;
								case 'fadeInRight':
									anime({
										targets: el,
										opacity: [0,1],
										translateX: [-75, 0],
										duration: 500,
										easing: 'easeInOutSine',
										complete: function() {
											$(el).removeClass('has-reveal-effect').css({opacity: '', transform: '', '-webkit-transform': ''});
										},
										delay: function(el) { return dly * 50; },
									});
								break;
								case 'zoomIn':
									$(el).css({opacity:1,transform: 'scale(0)','-webkit-transform': 'scale(0)'});
									anime({
										targets: el,
										scale: [0, 1],
										duration: 500,
										easing: 'easeInOutSine',
										complete: function() {
											$(el).removeClass('has-reveal-effect').css({opacity: '', transform: '', '-webkit-transform': ''});
										},
										delay: function(el) { return dly * 50; },
									});
								break;
								case 'fadeInBottom':
									anime({
										targets: el,
										opacity: [0,1],
										translateY: [-75, 0],
										duration: 500,
										easing: 'easeInOutQuad',
										complete: function() {
											$(el).removeClass('has-reveal-effect').css({opacity: '', transform: '', '-webkit-transform': ''});
										},
										delay: function(el) { return dly * 50; },
									});
								break;
								case 'fadeInTop':
								default:
									anime({
										targets: el,
										opacity: [0,1],
										translateY: [100, 0],
										duration: 500,
										easing: 'easeInOutQuad',
										complete: function() {
											$(el).removeClass('has-reveal-effect').css({opacity: '', transform: '', '-webkit-transform': ''});
										},
										delay: function(el) { return dly * 50; },
									});
								break;
							}
						},
						bounds: -50
					});
			}
		},

		mediaPlayerSkin: function() {
			var t=this;

			if ( typeof MediaElementPlayer !== 'undefined' ) {
				var settings = window._wpmejsSettings || {};
				settings.features = settings.features || mejs.MepDefaults.features;
				settings.features.push( 'exampleclass' );
				MediaElementPlayer.prototype.buildexampleclass = function( player ) {
					player.container.addClass( 'brayn-mejs-container' );
				};
			}
		},

		// Remove the preloader
		removeLoader: function() {
			var d=this;

			$(window).scrollTop(0);

			requestAnimationFrame( function() {
				if ( $('#transit_roler').length ) {

					$('#transit_roler').find('.trload').css({opacity: 0});
					anime({
						targets: ['#transit_roler .trl', '#transit_roler .trr'],
						height: ['100%','0%'],
						duration: 500,
						delay: function(el, i, l) { return i * 200; },
						easing: 'easeInOutCirc',
						complete: function() {
							$('#transit_roler').css({height: 0, overflow: 'hidden'});
							$('#transit_roler').find('.trload').hide();
							$(window).trigger('braynHasFinishLoad');
						}
					});
				} else {
					window.requestTimeout(function(){
						$(window).trigger('braynHasFinishLoad');
					},300);
				}
			});
		},
	};
	z.init();
	return z;
}( window.jQuery );
