/**
 * File customize-preview.js.
 *
 * Instantly live-update customizer settings in the preview for improved user experience.
 */

( function( $ ) {
	"use strict";
	var css = {};
	wp.customize.bind( 'preview-ready', function() {
		if ( $('head').find("#custom-skin-loader-css").length < 1 ) {
			$('head').append('<style type="text/css" id="custom-skin-loader-css"></style>');
		}

		wp.customize.preview.bind( 'braynmenu-highlight', function( data ) {
			if ( true === data.expanded ) {
				if ( ! $('#main-header').hasClass('on_menu') ) {
					$('button.hamburger__menu').trigger('click');
				}
			} else {
				if ( $('#main-header').hasClass('on_menu') ) {
					$('button.hamburger__menu').trigger('click');
				}
			}
		});

		wp.customize.preview.bind( 'braynarchive-highlight', function( data ) {
			if ( true === data.expanded ) {
				wp.customize.preview.send( 'url', cecuz.postarchivelink );
			} else {
				wp.customize.preview.send( 'url', cecuz.homeurl );
			}
		});
	});

	// single post: taglists.
	// @since 1.0
	wp.customize( 'show_tag_lists', function( value ) {
		value.bind( function( to ) {
			if ( true === to ) {
				$('#tag_lists_customization').show();
			} else {
				$('#tag_lists_customization').hide();
			}
		});
	});

	// menu widget
	wp.customize( 'use_widget_image', function( value ) {
		value.bind( function( to ) {
			if ( true === to ) {
				$('.menu-widget-block').show();
			} else {
				$('.menu-widget-block').hide();
			}
		});
	});

	// menu widget, link url
	// @since 1.0
	wp.customize( 'brayn_menu_widget_image_url', function( value ) {
		value.bind( function( to ) {
			$('.menu-widget-block').attr('href', to);
		});
	});

	// menu widget, link target
	// @since 1.0
	wp.customize( 'brayn_menu_widget_image_url_target', function( value ) {
		value.bind( function( to ) {
			if ( true === to ) {
				$('.menu-widget-block').attr('target', '_blank');
			} else {
				$('.menu-widget-block').attr('target', '_self');
			}
		});
	});

	// social widget
	wp.customize( 'use_widget_social', function( value ) {
		value.bind( function( to ) {
			if ( true === to ) {
				$('.menu-widget-social-block').show();
			} else {
				$('.menu-widget-social-block').hide();
			}
		});
	});

	// single post: author info box.
	// @since 1.0
	wp.customize( 'show_author_box', function( value ) {
		value.bind( function( to ) {
			if ( true === to ) {
				$('#author_box_customization').show();
			} else {
				$('#author_box_customization').hide();
			}
		});
	});

	// single post: next/prev link.
	// @since 1.0
	wp.customize( 'post_prev_next', function( value ) {
		value.bind( function( to ) {
			//console.log( to );
			if ( true === to ) {
				$('#post_prev_next_customization').show();
			} else {
				$('#post_prev_next_customization').hide();
			}
		});
	});

	// single portfolio: next/prev link.
	// @since 1.0
	wp.customize( 'portfolio_prev_next', function( value ) {
		value.bind( function( to ) {
			//console.log( to );
			if ( true === to ) {
				$('#portfolio_prev_next_customization').show();
			} else {
				$('#portfolio_prev_next_customization').hide();
			}
		});
	})

	// footer widgets
	// @since 1.0
	wp.customize( 'brayn_footer_widgets', function( value ) {
		value.bind( function( to ) {
			if ( true === to ) {
				$('.brayn_footer___widgets').show();
			} else {
				$('.brayn_footer___widgets').hide();
			}
		});
	});

	// Search button
	// @since 1.0
	wp.customize( 'enable_search', function( value ) {
		value.bind( function( to ) {
			if ( true === to ) {
				$('.search-caller').show();
			} else {
				$('.search-caller').hide();
			}
		});
	});

	// Header button
	// @since 1.0
	wp.customize( 'enable_header_button', function( value ) {
		value.bind( function( to ) {
			if ( true === to ) {
				$('.button-to-quote').show();
			} else {
				$('.button-to-quote').hide();
			}
		});
	});

	wp.customize( 'header_button_url_target', function( value ) {
		value.bind( function( to ) {
			if ( true === to ) {
				$('.button-to-quote').attr('target', '_blank');
			} else {
				$('.button-to-quote').attr('target', '_self');
			}
		});
	});

	wp.customize( 'header_button_url', function( value ) {
		value.bind( function( to ) {
			$('.button-to-quote').attr('href', to);
		});
	});

	var socialsettings = ['social_dribbble','social_facebook','social_github','social_medium','social_instagram','social_linkedin','social_pinterest','social_twitter','social_youtube','social_youtube'];

	socialsettings.forEach( set => {
		wp.customize( set, function( value ) {
			value.bind( function( to ) {
				if ( '' === to ) {
					if ( $('.brayn-menu-widget-list').find('.'+set).not(':hidden') ) {
						$('.brayn-menu-widget-list').find('.'+set).hide();
					}
				} else {
					if ( $('.brayn-menu-widget-list').find('.'+set).is(':hidden') ) {
						 $('.brayn-menu-widget-list').find('.'+set).show();
					}
				}
			});
		});
	});

	// Heading font-family
	// @since 1.0
	wp.customize( 'brayn_heading_font', function( value ) {
		value.bind( function( to ) {
			var fm = to.split(':');
			
			fm = '"'+ fm[0].replace(/\++/g, " ") +'", sans-serif';

			if ( $('head').find('#custom-font-heading').length ) {
				$("#custom-font-heading").attr("href", "//fonts.googleapis.com/css?family="+to);
			} else {
				$('head').prepend('<link id="custom-font-heading" rel="stylesheet" href="https://fonts.googleapis.com/css?family='+to+'" type="text/css" media="screen">');
			}
		});
	});

	// Body font-family
	// @since 1.0
	wp.customize( 'brayn_body_font', function( value ) {
		value.bind( function( to ) {
			var fm = to.split(':');
			
			fm = '"'+ fm[0].replace(/\++/g, " ") +'", sans-serif';

			if ( $('head').find('#custom-font-body').length ) {
				$("#custom-font-body").attr("href", "//fonts.googleapis.com/css?family="+to);
			} else {
				$('head').prepend('<link id="custom-font-body" rel="stylesheet" href="https://fonts.googleapis.com/css?family='+to+'" type="text/css" media="screen">');
			}
		});
	});

	// woo search enable_woo_search
	// @since 2.0.0
	wp.customize( 'enable_woo_search', function( value ) {
		value.bind( function( to ) {
			var _f = $('#brayn-search-form').find('form');
			if ( true === to ) {
				$('<input type="hidden" name="post_type" value="product">').appendTo( _f );
				_f.find('input[type="search"]').attr('placeholder', 'Search products ...');
			} else {
				_f.find('input[name="post_type"]').remove();
				_f.find('input[type="search"]').attr('placeholder', 'Search ...');
			}
		});
	});

	// Top cart
	// @since 2.0.0
	wp.customize( 'enable_top_cart', function( value ) {
		value.bind( function( to ) {
			if ( true === to ) {
				$('.brayn-top-cart').show();
			} else {
				$('.brayn-top-cart').hide();
			}
		});
	});

	// Top account
	// @since 2.0.0
	wp.customize( 'enable_top_user', function( value ) {
		value.bind( function( to ) {
			if ( true === to ) {
				$('.brayn-top-account').show();
			} else {
				$('.brayn-top-account').hide();
			}
		});
	});
} )( jQuery );