<?php
/**
 * The template for displaying the footer
 *
 * @package WordPress
 * @subpackage Brayn
 * @since 1.0
 */

?>
<?php
	// Elementor `footer` location.
	if ( ! function_exists( 'elementor_theme_do_location' ) || ! elementor_theme_do_location( 'footer' ) ) {
?>
	<footer id="br-site-footer" class="br-site-footer">
		<div class="container">
			
			<?php get_template_part( 'template-parts/footer', 'widgets' ); ?>
			
			<!-- Copyright & additional menu -->
			<div class="footer-end">
				<div class="row">
					<div class="col-md-6 text-center text-md-left brayn--copyright-text">
						<?php print wp_kses_post( stripslashes( get_theme_mod( 'copyright_text', sprintf( esc_html__( '&copy;%s. Brayn by WIP Themes.', 'brayn' ), date('Y') ) ) ) ); ?>
					</div>

					<?php get_template_part( 'template-parts/nav/footer', 'menu' ); ?>
				</div>
			</div>
		</div>
	</footer>
<?php } ?>

	</div>
	<!-- .viewport -->
	
</div><!-- END #site -->

<?php wp_footer(); ?>

</body>
</html>
