<?php
/**
 * Brayn functions and definitions
 *
 * @package WordPress
 * @subpackage Brayn
 * @since 1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Set default heading font.
if ( ! defined( 'WIP_THEMES_DEFAULT_HEADING_FONT' ) ) {
	define( 'WIP_THEMES_DEFAULT_HEADING_FONT', 'Poppins:100,100i,200,200i,300,300i,400,400i,500,500i,600,600i,700,700i,800,800i,900,900i' );
}

// Set default body font.
if ( ! defined( 'WIP_THEMES_DEFAULT_BODY_FONT' ) ) {
	define( 'WIP_THEMES_DEFAULT_BODY_FONT', 'Source+Sans+Pro:200,200i,300,300i,400,400i,600,600i,700,700i,900,900i' );
}

/**
 * Check woocommerce active status.
 *
 * @since 2.0.0
 */
define( 'BRAYN_WOOCOMMERCE_ACTIVE', class_exists( 'WooCommerce' ) );

/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Run before init hook
 *
 * @since 1.0
 * @return void
 */
function brayn_theme_setup() {
	// theme translation.
	load_theme_textdomain( 'brayn', get_template_directory() . '/langs/' );

	// Add default posts and comments RSS feed links to head.
	add_theme_support( 'automatic-feed-links' );

	/*
	 * Let WordPress manage the document title.
	 * By adding theme support, we declare that this theme does not use a
	 * hard-coded <title> tag in the document head, and expect WordPress to
	 * provide it for us.
	 */
	add_theme_support( 'title-tag' );

	/*
	 * Enable support for Post Thumbnails on posts and pages.
	 */
	add_theme_support( 'post-thumbnails', array( 'post', 'portfolio', 'page' ) );

	// the 4:3 ratio based image size.
	add_image_size( 'brayn-post-cover', 1200, 900, true );
	add_image_size( 'brayn-post-wide', 1200, 750, true );

	// the 1:1 ratio based image size.
	add_image_size( 'brayn-post-square', 1000, 1000, true );
	add_image_size( 'brayn-post-square-small', 500, 500, true );

	// Potrait image size.
	add_image_size( 'brayn-post-potrait', 900, 1200, true );
	add_image_size( 'brayn-post-slide', 800, 600, true );

	// Set the default content width.
	$GLOBALS['content_width'] = 710;

	// This theme uses wp_nav_menu() in 2 locations
	register_nav_menus(
		array(
			'main'   => esc_html__( 'Main Menu', 'brayn' ),
			'footer' => esc_html__( 'Footer Nav (optional)', 'brayn' ),
		)
	);

	/*
	 * Switch default core markup for search form, comment form, and comments
	 * to output valid HTML5.
	 */
	add_theme_support(
		'html5',
		array(
			'comment-form',
			'comment-list',
			'search-form',
			'gallery',
			'caption',
		)
	);

	// Add theme support for Custom Logo.
	add_theme_support(
		'custom-logo',
		array(
			'width'       => 250,
			'height'      => 250,
			'flex-width'  => true,
			'flex-height' => true,
		)
	);

	// Add theme support for selective refresh for widgets.
	add_theme_support( 'customize-selective-refresh-widgets' );

	add_theme_support( 'editor-styles' );
	
	add_editor_style( array( 'assets/css/editor-style.css', '/assets/lib/font-awesome/css/font-awesome.min.css', brayn_font_families() ) );

	// Add support for Block Styles.
	add_theme_support( 'wp-block-styles' );

	// Add support for full and wide align images.
	add_theme_support( 'align-wide' );

	// Add support for responsive embedded content.
	add_theme_support( 'responsive-embeds' );

	// We need our core plugin.
	add_theme_support( 'wipthemes-brayn' );

	brayn_set_elementor_globals();
	update_option( 'wip_themes_core_no_featured_posts', 'yes' );

	/**
	 * Adds Woocommerce support
	 *
	 * @since 2.0.0
	 */
	add_theme_support( 'woocommerce' );
    add_theme_support( 'wc-product-gallery-zoom' );
    add_theme_support( 'wc-product-gallery-lightbox' );
    add_theme_support( 'wc-product-gallery-slider' );
}
add_action( 'after_setup_theme', 'brayn_theme_setup' );

// Tgm plugin activation.
require get_parent_theme_file_path( '/inc/tgmpa/class-tgm-plugin-activation.php' );

// SVG icons class.
require get_parent_theme_file_path( '/inc/class-brayn-svg-icons.php' );

// Skin loader class.
require get_parent_theme_file_path( '/inc/class-brayn-skin-loader.php' );

// Customizer functions.
require get_parent_theme_file_path( '/inc/customizer/customizer-functions.php' );

if ( class_exists( 'WP_Customize_Control' ) ) {
	// Customize control classes.
	require get_parent_theme_file_path( '/inc/customizer/ui/class-brayn-customizer-ui-fonts.php' );
	require get_parent_theme_file_path( '/inc/customizer/ui/class-brayn-customizer-ui-range.php' );
	require get_parent_theme_file_path( '/inc/customizer/ui/class-brayn-customizer-ui-toggle.php' );
	require get_parent_theme_file_path( '/inc/customizer/ui/class-brayn-customizer-ui-radio-image.php' );
	require get_parent_theme_file_path( '/inc/customizer/ui/class-brayn-customizer-ui-refresher.php' );
	require get_parent_theme_file_path( '/inc/customizer/ui/class-brayn-customizer-ui-block-hr.php' );
}

// Theme customizer class.
require get_parent_theme_file_path( '/inc/customizer/class-brayn-customizer.php' );

// Template functions.
require get_parent_theme_file_path( '/inc/template-functions.php' );

// Template tags.
require get_parent_theme_file_path( '/inc/template-tags.php' );

// Template actions.
require get_parent_theme_file_path( '/inc/template-actions.php' );

// Import helper.
if ( class_exists('OCDI_Plugin') ) {
	require get_parent_theme_file_path( '/inc/import-helper.php' );
}

// WooCommerce helper.
if ( BRAYN_WOOCOMMERCE_ACTIVE ) {
	require get_parent_theme_file_path( '/inc/woocommerce-helper.php' );
}
