<?php
/**
 * The header for our theme
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package WordPress
 * @subpackage Brayn
 * @since 1.0
 * @version 1.0
 */

?><!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js">
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>">
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="profile" href="http://gmpg.org/xfn/11">
<?php wp_head(); ?>

</head>

<body <?php body_class(); ?>>

<?php do_action( 'brayn_before_site_el' ); ?>

<div id="site" class="page">

<?php wp_body_open(); ?>
	
<?php
	// Elementor `header` location.
	if ( ! function_exists( 'elementor_theme_do_location' ) || ! elementor_theme_do_location( 'header' ) ) {
?>
	<header id="main-header" class="default-header">
		<div class="header-ui">

			<div class="brand--nav">
				<?php the_custom_logo(); ?>

				<button class="hamburger__menu hamburger hamburger--spring" type="button">
					<span class="hamburger-box">
						<span class="hamburger-inner"></span>
					</span>
				</button>
			</div>

			<div class="header--complementary">
				<?php do_action( 'brayn_header_complementary_content' ); ?>
			</div>

		</div>
	</header>

<?php
		get_template_part('template-parts/nav/main', 'menu');
	}
?>

	<div class="viewport">
