<?php
/**
 * Customizer class
 *
 * @package Brayn
 * @since   1.0
 */

if ( ! class_exists( 'Brayn_Customizer' ) ) {

final class Brayn_Customizer {
	/**
	 * Instance
	 *
	 * @since 1.0.0
	 *
	 * @access private
	 * @static
	 *
	 * @var Brayn_Customizer The single instance of the class.
	 */
	private static $_instance = null;

	/**
	 * Instance
	 *
	 * Ensures only one instance of the class is loaded or can be loaded.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 * @static
	 *
	 * @return Brayn_Customizer An instance of the class.
	 */
	public static function instance() {

		if ( is_null( self::$_instance ) ) {
			self::$_instance = new self();
		}
		return self::$_instance;
	}

	/**
	 * Constructor
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 */
	public function __construct() {
		add_action( 'init', [ $this, 'init' ] );
	}

	public function init() {
		add_action( 'customize_register', [ $this, 'woocommerce' ], 11 );
		add_action( 'customize_register', [ $this, 'setting_global_ele' ] );
		add_action( 'customize_register', [ $this, 'setting_menu_widgets' ] );
		add_action( 'customize_register', [ $this, 'setting_copyright' ] );
		add_action( 'customize_register', [ $this, 'setting_typography' ] );
		add_action( 'customize_register', [ $this, 'setting_blog_archive' ] );
		add_action( 'customize_register', [ $this, 'setting_skin' ] );
	}

	public function setting_skin( $wp_customize ) {
		$description = '';
		if ( ! class_exists( 'Brayn_Core' ) ) {
			$description = esc_html__( 'The "Brayn Core" Plugin is not active! This feature has been disabled!', 'brayn' );
		}

		// Add new panel.
		$wp_customize->add_panel(
			'theme_skin',
			array(
				'priority'       => 32,
				'capability'     => 'edit_theme_options',
				'theme_supports' => '',
				'title'          => esc_html__( 'Custom Skin', 'brayn' ),
				'description'    => $description,
			)
		);

		// New section.
		$wp_customize->add_section(
			'theme_skin_base',
			array(
				'title'       => esc_html__( 'Base styling', 'brayn' ),
				'panel'       => 'theme_skin',
				'priority'    => 10,
				'description' => '',
			)
		);

		$wp_customize->add_section(
			'theme_skin_inner',
			array(
				'title'       => esc_html__( 'Inner Elements', 'brayn' ),
				'panel'       => 'theme_skin',
				'priority'    => 15,
				'description' => '',
			)
		);

		$wp_customize->add_section(
			'theme_skin_menu',
			array(
				'title'       => esc_html__( 'Main menu', 'brayn' ),
				'panel'       => 'theme_skin',
				'priority'    => 20,
				'description' => '',
			)
		);

		$wp_customize->add_section(
			'theme_skin_footer',
			array(
				'title'       => esc_html__( 'Footer', 'brayn' ),
				'panel'       => 'theme_skin',
				'priority'    => 25,
				'description' => '',
			)
		);

		if ( BRAYN_WOOCOMMERCE_ACTIVE ) {
			$wp_customize->add_section(
				'theme_skin_woo',
				array(
					'title'       => esc_html__( 'WooCommerce', 'brayn' ),
					'panel'       => 'theme_skin',
					'priority'    => 30,
					'description' => '',
				)
			);		
		}

		$wp_customize->add_setting(
			'enable_custom_skin',
			[
				'default'           => '',
				'transport'         => 'postMessage',
				'sanitize_callback' => 'esc_html',
			]
		);

		$wp_customize->add_control(
			new Brayn_Customizer_Ui_Toggle(
				$wp_customize,
				'enable_custom_skin',
				[
					'label'       => esc_html__( 'Enable Custom Skin', 'brayn' ),
					'description' => esc_html__( 'You need to enable this option to apply the custom skin on the front-end.', 'brayn' ),
					'section'     => 'theme_skin_base',
					'priority'    => 9,
				]
			)
		);

		if ( ! class_exists( 'Brayn_Core' ) ) {
			return false;
		}

		$settings = brayn_customizer_custom_skin_options();
		$selective_refresh_ids = array();
		foreach ( $settings as $setting_id => $setting ) {
			// Settings.
			$wp_customize->add_setting(
				$setting_id,
				array(
					'default'           => $setting['default'],
					'transport'         => 'postMessage',
					'sanitize_callback' => 'sanitize_hex_color',
				)
			);

			// Controls.
			$wp_customize->add_control(
				new WP_Customize_Color_Control(
					$wp_customize,
					$setting_id,
					array(
						'label'       => $setting['label'],
						'description' => $setting['description'],
						'section'     => $setting['section'],
						'priority'    => $setting['priority'],
					)
				)
			);

			$selective_refresh_ids[] = $setting_id;
		}
		unset( $setting );

		$wp_customize->selective_refresh->add_partial(
			'brayn_primary_color',
			[
				'settings'            => $selective_refresh_ids,
				'selector'            => '#brayn-customizer-custom-css',
				'render_callback'     => 'brayn_customizer_process_api_color',
				'container_inclusive' => false,
				'fallback_refresh'    => false,
			]
		);
	}

	/**
	 * Customizer post/blog archive section.
	 *
	 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
	 * @since 1.0
	 */
	public function setting_blog_archive( $wp_customize ) {
		// add new section.
		$wp_customize->add_section(
			'brayn_post_archive',
			[
				'title'      => esc_html__( 'Blog Archive', 'brayn' ),
				'description' => esc_html__( 'Layout &amp; post listing style for archive pages. These settings may be overridden for individual category and tag.', 'brayn' ),
				'capability' => 'edit_theme_options',
				'priority'   => 27,
			]
		);

		// Settings.
		$wp_customize->add_setting(
			'brayn_index_layout',
			array(
				'default'           => 'no-sidebar',
				'transport'         => 'refresh',
				'sanitize_callback' => 'esc_html',
			)
		);

		$wp_customize->add_setting(
			'brayn_firstpost_featured',
			array(
				'default'           => true,
				'transport'         => 'refresh',
				'sanitize_callback' => 'esc_html',
			)
		);

		$wp_customize->add_setting(
			'brayn_index_loop_style',
			array(
				'default'           => 'column',
				'transport'         => 'refresh',
				'sanitize_callback' => 'esc_html',
			)
		);

		// Controls.
		$wp_customize->add_control(
			new Brayn_Customizer_Ui_Radio_Image(
				$wp_customize,
				'brayn_index_layout',
				[
					'label'       => esc_html__( 'Layout', 'brayn' ),
					'description' => '',
					'choices'     => [
						'right-sidebar' => get_theme_file_uri( '/assets/images/customizer/right-sidebar.png' ),
						'no-sidebar'    => get_theme_file_uri( '/assets/images/customizer/no-sidebar.png' ),
						'left-sidebar'  => get_theme_file_uri( '/assets/images/customizer/left-sidebar.png' ),
					],
					'section'     => 'brayn_post_archive',
					'priority'    => 5,
				]
			)
		);

		$wp_customize->add_control(
			new Brayn_Customizer_Ui_Toggle(
				$wp_customize,
				'brayn_firstpost_featured',
				[
					'label'       => esc_html__( 'Show 1st post as hero post', 'brayn' ),
					'description' => '',
					'default_checked' => true,
					'section'     => 'brayn_post_archive',
					'priority'    => 6,
				]
			)
		);

		$wp_customize->add_control(
			'brayn_index_loop_style',
			[
				'type'     => 'radio',
				'label'    => esc_html__( 'Loop Style', 'brayn' ),
				'description' => '',
				'choices'  => [
					'column'         => esc_html__( 'Column', 'brayn' ),
					'column-minimal' => esc_html__( 'Column Minimal', 'brayn' ),
					'staggered'      => esc_html__( 'Staggered', 'brayn' ),
					'classic'        => esc_html__( 'Classic', 'brayn' ),
				],
				'section'  => 'brayn_post_archive',
				'priority' => 7,
			]
		);
	}

	/**
	 * Customizer additional menu widget section.
	 *
	 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
	 * @since 1.0
	 */
	public function setting_menu_widgets( $wp_customize ) {
		// Add new panel.
		$wp_customize->add_panel(
			'brayn_menu_widgets',
			array(
				'priority'       => 26,
				'capability'     => 'edit_theme_options',
				'theme_supports' => '',
				'title'          => esc_html__( 'Menu Widgets', 'brayn' ),
				'description'    => '',
			)
		);

		// New section.
		$wp_customize->add_section(
			'brayn_menu_widgets_image',
			array(
				'title'       => esc_html__( 'Widget Image', 'brayn' ),
				'panel'       => 'brayn_menu_widgets',
				'priority'    => 10,
				'description' => '',
			)
		);

		$wp_customize->add_section(
			'brayn_menu_widgets_social',
			array(
				'title'       => esc_html__( 'Social links', 'brayn' ),
				'panel'       => 'brayn_menu_widgets',
				'priority'    => 12,
				'description' => '',
			)
		);

		// SETTINGS FOR WIDGET IMAGE.
		$wp_customize->add_setting(
			'use_widget_image',
			array(
				'default'           => false,
				'transport'         => 'postMessage',
				'sanitize_callback' => 'esc_html',
			)
		);

		$wp_customize->add_setting(
			'brayn_widget_menu_image',
			array(
				'default'           => get_theme_file_uri( '/assets/images/menu-widget-def-img.jpg' ),
				'transport'         => 'postMessage',
				'height'            => 325,
				'sanitize_callback' => 'esc_url_raw',
			)
		);

		$wp_customize->add_setting(
			'brayn_menu_widget_image_url',
			array(
				'default'           => '',
				'transport'         => 'postMessage',
				'sanitize_callback' => 'esc_url_raw',
			)
		);

		$wp_customize->add_setting(
			'brayn_menu_widget_image_url_target',
			array(
				'default'           => false,
				'transport'         => 'postMessage',
				'sanitize_callback' => 'esc_html',
			)
		);

		$wp_customize->add_setting(
			'brayn_menu_widget_image_text',
			array(
				'default'           => '',
				'transport'         => 'postMessage',
				'sanitize_callback' => 'esc_html',
			)
		);

		$wp_customize->add_control(
			new Brayn_Customizer_Ui_Toggle(
				$wp_customize,
				'use_widget_image',
				array(
					'label'       => esc_html__( 'Enable/Disable this widget', 'brayn' ),
					'description' => '',
					'default_checked' => 'enabled',
					'section'     => 'brayn_menu_widgets_image',
					'priority'    => 9,
				)
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Image_Control(
				$wp_customize,
				'brayn_widget_menu_image', [
					'label'    => esc_html__( 'Image', 'brayn' ),
					'section'  => 'brayn_menu_widgets_image',
					'settings' => 'brayn_widget_menu_image',
					'priority' => 10,
				]
			)
		);

		$wp_customize->add_control(
			'brayn_menu_widget_image_text',
			[
				'type'        => 'text',
				'label'       => esc_html__( 'Text / Heading', 'brayn' ),
				'description' => '',
				'section'     => 'brayn_menu_widgets_image',
				'priority'    => 11,
			]
		);

		$wp_customize->add_control(
			'brayn_menu_widget_image_url',
			[
				'type'        => 'url',
				'label'       => esc_html__( 'Link URL', 'brayn' ),
				'description' => '',
				'section'     => 'brayn_menu_widgets_image',
				'priority'    => 12,
			]
		);

		$wp_customize->add_control(
			'brayn_menu_widget_image_url_target',
			[
				'type'        => 'checkbox',
				'label'       => esc_html__( 'Open link in new tab?', 'brayn' ),
				'description' => '',
				'section'     => 'brayn_menu_widgets_image',
				'priority'    => 13,
			]
		);

		$wp_customize->selective_refresh->add_partial(
			'brayn_widget_menu_image',
			array(
				'settings'            => array( 'brayn_widget_menu_image' ),
				'selector'            => '.brayn_menu_widget_image',
				'render_callback'     => 'brayn_customizer_widget_image_url',
				'container_inclusive' => false,
				'fallback_refresh'    => false,
			)
		);

		$wp_customize->selective_refresh->add_partial(
			'brayn_menu_widget_image_text',
			array(
				'settings'            => array( 'brayn_menu_widget_image_text' ),
				'selector'            => '.brayn_menu_widget_image_text',
				'render_callback'     => 'brayn_customizer_widget_image_text',
				'container_inclusive' => false,
				'fallback_refresh'    => false,
			)
		);

		// SETTINGS FOR WIDGET SOCIAL LINKS.
		$wp_customize->add_setting(
			'use_widget_social',
			array(
				'default'           => false,
				'transport'         => 'postMessage',
				'sanitize_callback' => 'esc_html',
			)
		);

		$wp_customize->add_setting(
			'brayn_menu_widget_social_title',
			array(
				'default'           => '',
				'transport'         => 'postMessage',
				'sanitize_callback' => 'esc_html',
			)
		);

		$wp_customize->add_control(
			new Brayn_Customizer_Ui_Toggle(
				$wp_customize,
				'use_widget_social',
				array(
					'label'       => esc_html__( 'Enable/Disable this widget', 'brayn' ),
					'description' => '',
					'default_checked' => 'enabled',
					'section'     => 'brayn_menu_widgets_social',
					'priority'    => 9,
				)
			)
		);

		$wp_customize->add_control(
			'brayn_menu_widget_social_title',
			[
				'type'        => 'text',
				'label'       => esc_html__( 'Title', 'brayn' ),
				'description' => '',
				'section'     => 'brayn_menu_widgets_social',
				'priority'    => 11,
			]
		);

		$wp_customize->selective_refresh->add_partial(
			'brayn_menu_widget_social_title',
			array(
				'settings'            => array( 'brayn_menu_widget_social_title' ),
				'selector'            => '.brayn_menu_widget_social_title',
				'render_callback'     => 'brayn_customizer_widget_social_title',
				'container_inclusive' => false,
				'fallback_refresh'    => false,
			)
		);

		// Settings.
		$settings = array(
			'social_dribbble',
			'social_facebook',
			'social_github',
			'social_medium',
			'social_instagram',
			'social_linkedin',
			'social_pinterest',
			'social_twitter',
			'social_youtube',
		);

		$priority = 12;
		foreach ( $settings as $setting ) {
			// Settings.
			$wp_customize->add_setting(
				$setting,
				array(
					'default'           => '',
					'transport'         => 'postMessage',
					'sanitize_callback' => 'esc_url_raw',
				)
			);

			// Controls.
			$wp_customize->add_control(
				$setting,
				array(
					'type'        => 'text',
					'label'       => str_replace( 'social_', '', $setting ),
					'description' => sprintf(
						/* translators: %s: social media name */
						esc_html__( 'Enter your %s public profile url.', 'brayn' ),
						str_replace( 'social_', '', $setting )
					),
					'section'     => 'brayn_menu_widgets_social',
					'priority'    => $priority,
				)
			);

			$priority++;
		}
		unset( $setting );
		unset( $priority );
	}

	/**
	 * Customizer global elements section.
	 *
	 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
	 * @since 1.0
	 */
	public function setting_global_ele( $wp_customize ) {
		// add new section.
		$wp_customize->add_section(
			'brayn_elements',
			array(
				'title'      => esc_html__( 'Elements', 'brayn' ),
				'capability' => 'edit_theme_options',
				'priority'   => 25,
			)
		);

		// Settings.
		$wp_customize->add_setting(
			'enable_preloader',
			array(
				'default'           => 'enabled',
				'transport'         => 'refresh',
				'sanitize_callback' => 'esc_html',
			)
		);

		$wp_customize->add_setting(
			'brayn_footer_widgets',
			array(
				'default'           => 'enabled',
				'transport'         => 'postMessage',
				'sanitize_callback' => 'esc_html',
			)
		);

		$wp_customize->add_setting(
			'brayn_elements_hr_1',
			array(
				'transport'         => 'postMessage',
				'sanitize_callback' => 'esc_html',
			)
		);

		$wp_customize->add_setting(
			'show_tag_lists',
			array(
				'default'           => 'enabled',
				'transport'         => 'postMessage',
				'sanitize_callback' => 'esc_html',
			)
		);

		$wp_customize->add_setting(
			'show_author_box',
			array(
				'default'           => 'enabled',
				'transport'         => 'postMessage',
				'sanitize_callback' => 'esc_html',
			)
		);

		$wp_customize->add_setting(
			'post_prev_next',
			array(
				'default'           => 'enabled',
				'transport'         => 'postMessage',
				'sanitize_callback' => 'esc_html',
			)
		);

		$wp_customize->add_setting(
			'portfolio_prev_next',
			array(
				'default'           => 'enabled',
				'transport'         => 'postMessage',
				'sanitize_callback' => 'esc_html',
			)
		);

		$wp_customize->add_setting(
			'brayn_elements_hr_2',
			array(
				'transport'         => 'postMessage',
				'sanitize_callback' => 'esc_html',
			)
		);

		$wp_customize->add_setting(
			'enable_search',
			array(
				'default'           => true,
				'transport'         => 'postMessage',
				'sanitize_callback' => 'esc_html',
			)
		);

		$wp_customize->add_setting(
			'enable_woo_search',
			array(
				'default'           => true,
				'transport'         => 'postMessage',
				'sanitize_callback' => 'esc_html',
			)
		);

		$wp_customize->add_setting(
			'enable_header_button',
			array(
				'default'           => false,
				'transport'         => 'postMessage',
				'sanitize_callback' => 'esc_html',
			)
		);

		$wp_customize->add_setting(
			'header_button_url',
			array(
				'default'           => '',
				'transport'         => 'postMessage',
				'sanitize_callback' => 'esc_url_raw',
			)
		);

		$wp_customize->add_setting(
			'header_button_url_target',
			array(
				'default'           => false,
				'transport'         => 'postMessage',
				'sanitize_callback' => 'esc_html',
			)
		);

		$wp_customize->add_setting(
			'header_button_text',
			array(
				'default'           => '',
				'transport'         => 'postMessage',
				'sanitize_callback' => 'esc_html',
			)
		);

		// Controls.
		$wp_customize->add_control(
			new Brayn_Customizer_Ui_Toggle(
				$wp_customize,
				'enable_preloader',
				array(
					'label'       => esc_html__( 'Enable/Disable the preloader', 'brayn' ),
					'description' => esc_html__( 'Turn off/on the ajax-like transition', 'brayn' ),
					'default_checked' => 'enabled',
					'section'     => 'brayn_elements',
					'priority'    => 9,
				)
			)
		);

		$wp_customize->add_control(
			new Brayn_Customizer_Ui_Toggle(
				$wp_customize,
				'brayn_footer_widgets',
				array(
					'label'       => esc_html__( 'Footer widgets', 'brayn' ),
					'description' => esc_html__( 'Enabled/disabled the footer widget area', 'brayn' ),
					'default_checked' => 'enabled',
					'section'     => 'brayn_elements',
					'priority'    => 15,
				)
			)
		);

		$wp_customize->add_control(
			new Brayn_Customizer_Ui_Block_Hr(
				$wp_customize,
				'brayn_elements_hr_1',
				array(
					'label'       => esc_html__( 'Post &amp; Portfolio', 'brayn' ),
					'section'     => 'brayn_elements',
					'priority'    => 16,
				)
			)
		);

		$wp_customize->add_control(
			new Brayn_Customizer_Ui_Toggle(
				$wp_customize,
				'show_tag_lists',
				array(
					'label'       => esc_html__( 'Tag lists', 'brayn' ),
					'description' => esc_html__( 'Turn off/on the tag lists in single post page.', 'brayn' ),
					'default_checked' => 'enabled',
					'section'     => 'brayn_elements',
					'priority'    => 17,
				)
			)
		);

		$wp_customize->add_control(
			new Brayn_Customizer_Ui_Toggle(
				$wp_customize,
				'show_author_box',
				array(
					'label'       => esc_html__( 'Author info', 'brayn' ),
					'description' => esc_html__( 'Turn off/on the author info in single post page.', 'brayn' ),
					'default_checked' => 'enabled',
					'section'     => 'brayn_elements',
					'priority'    => 18,
				)
			)
		);

		$wp_customize->add_control(
			new Brayn_Customizer_Ui_Toggle(
				$wp_customize,
				'post_prev_next',
				array(
					'label'       => esc_html__( 'Next/Previous post link.', 'brayn' ),
					'description' => esc_html__( 'Turn off/on the Next/Previous link in single post page.', 'brayn' ),
					'default_checked' => 'enabled',
					'section'     => 'brayn_elements',
					'priority'    => 19,
				)
			)
		);

		$wp_customize->add_control(
			new Brayn_Customizer_Ui_Toggle(
				$wp_customize,
				'portfolio_prev_next',
				array(
					'label'       => esc_html__( 'Next/Previous portfolio link.', 'brayn' ),
					'description' => esc_html__( 'Turn off/on the Next/Previous link in single portfolio page.', 'brayn' ),
					'default_checked' => 'enabled',
					'section'     => 'brayn_elements',
					'priority'    => 20,
				)
			)
		);

		$wp_customize->add_control(
			new Brayn_Customizer_Ui_Block_Hr(
				$wp_customize,
				'brayn_elements_hr_2',
				array(
					'label'       => esc_html__( 'Header Elements', 'brayn' ),
					'section'     => 'brayn_elements',
					'priority'    => 21,
				)
			)
		);

		$wp_customize->add_control(
			new Brayn_Customizer_Ui_Toggle(
				$wp_customize,
				'enable_search',
				array(
					'label'       => esc_html__( 'Search button.', 'brayn' ),
					'description' => esc_html__( 'Enabled/Disabled the search button at the header.', 'brayn' ),
					'default_checked' => 'enabled',
					'section'     => 'brayn_elements',
					'priority'    => 22,
				)
			)
		);

		if ( BRAYN_WOOCOMMERCE_ACTIVE ) {
			$wp_customize->add_control(
				new Brayn_Customizer_Ui_Toggle(
					$wp_customize,
					'enable_woo_search',
					array(
						'label'       => esc_html__( 'Switch to product search', 'brayn' ),
						'description' => esc_html__( 'Switch the search form with woocommerce product search?', 'brayn' ),
						'default_checked' => 'enabled',
						'section'     => 'brayn_elements',
						'priority'    => 22,
					)
				)
			);
		}

		$wp_customize->add_control(
			new Brayn_Customizer_Ui_Toggle(
				$wp_customize,
				'enable_header_button',
				array(
					'label'       => esc_html__( 'Additional button.', 'brayn' ),
					'description' => esc_html__( 'Enabled/Disabled the additional button at the header. If enabled, please continue to settings below.', 'brayn' ),
					'default_checked' => 'enabled',
					'section'     => 'brayn_elements',
					'priority'    => 23,
				)
			)
		);

		$wp_customize->add_control(
			'header_button_text',
			[
				'type'        => 'text',
				'label'       => esc_html__( 'Button Text', 'brayn' ),
				'description' => '',
				'section'     => 'brayn_elements',
				'priority'    => 24,
			]
		);

		$wp_customize->add_control(
			'header_button_url',
			[
				'type'        => 'url',
				'label'       => esc_html__( 'Link URL', 'brayn' ),
				'description' => '',
				'section'     => 'brayn_elements',
				'priority'    => 25,
			]
		);

		$wp_customize->add_control(
			'header_button_url_target',
			[
				'type'        => 'checkbox',
				'label'       => esc_html__( 'Open link in new tab?', 'brayn' ),
				'description' => '',
				'section'     => 'brayn_elements',
				'priority'    => 26,
			]
		);

		$wp_customize->selective_refresh->add_partial(
			'header_button_text',
			array(
				'settings'            => array( 'header_button_text' ),
				'selector'            => '.button-to-quote',
				'render_callback'     => 'brayn_customizer_header_button_text',
				'container_inclusive' => false,
				'fallback_refresh'    => false,
			)
		);
	}

	/**
	 * Add copyright text to site identity section
	 *
	 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
	 */
	public function setting_copyright( $wp_customize ) {
		$cp_default = '&copy;2019. Brayn by WIP Themes.';
		$wp_customize->add_setting(
			'copyright_text',
			[
				'default'           => $cp_default,
				'transport'         => 'postMessage',
				'sanitize_callback' => 'sanitize_textarea_field',
			]
		);

		$wp_customize->add_control(
			'copyright_text',
			[
				'type'        => 'textarea',
				'label'       => esc_html__( 'Copyright Text', 'brayn' ),
				'description' => esc_html__( 'Enter the copyright text.', 'brayn' ),
				'section'     => 'title_tagline',
				'priority'    => 20,
			]
		);

		$wp_customize->selective_refresh->add_partial(
			'copyright_text',
			array(
				'settings'            => array( 'copyright_text' ),
				'selector'            => '.brayn--copyright-text',
				'render_callback'     => 'brayn_customizer_cp_text',
				'container_inclusive' => false,
				'fallback_refresh'    => false,
			)
		);
	}

	/**
	 * Customizer for typography option.
	 *
	 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
	 * @since 1.0
	 */
	public function setting_typography( $wp_customize ) {
		// Register custom typography settings.
		$wp_customize->add_section(
			'theme_typography',
			array(
				'title'    => esc_html__( 'Fonts &amp; Typography', 'brayn' ),
				'priority' => 32,
			)
		);

		// Settings.
		$wp_customize->add_setting(
			'brayn_heading_font',
			array(
				'default'           => WIP_THEMES_DEFAULT_HEADING_FONT,
				'transport'         => 'postMessage',
				'sanitize_callback' => 'esc_attr',
			)
		);

		$wp_customize->add_setting(
			'brayn_body_font',
			array(
				'default'           => WIP_THEMES_DEFAULT_BODY_FONT,
				'transport'         => 'postMessage',
				'sanitize_callback' => 'esc_attr',
			)
		);

		// Controls.
		$wp_customize->add_control(
			new Brayn_Customizer_Ui_Fonts(
				$wp_customize,
				'brayn_heading_font',
				array(
					'label'    => esc_html__( 'Select a Font for Heading', 'brayn' ),
					'section'  => 'theme_typography',
					'priority' => 13,
				)
			)
		);

		$wp_customize->add_control(
			new Brayn_Customizer_Ui_Fonts(
				$wp_customize,
				'brayn_body_font',
				array(
					'label'    => esc_html__( 'Select a Font for Body Text', 'brayn' ),
					'section'  => 'theme_typography',
					'priority' => 15,
				)
			)
		);

		// Settings.
		$wp_customize->add_setting(
			'body_font_size',
			array(
				'default'           => 17,
				'transport'         => 'postMessage',
				'sanitize_callback' => 'esc_html',
			)
		);

		$wp_customize->add_setting(
			'body_line_height',
			array(
				'default'           => 1.7,
				'transport'         => 'postMessage',
				'sanitize_callback' => 'esc_html',
			)
		);

		$wp_customize->add_setting(
			'heading_h1',
			array(
				'default'           => 2.75,
				'transport'         => 'postMessage',
				'sanitize_callback' => 'esc_html',
			)
		);

		$wp_customize->add_setting(
			'heading_h2',
			array(
				'default'           => 2,
				'transport'         => 'postMessage',
				'sanitize_callback' => 'esc_html',
			)
		);

		$wp_customize->add_setting(
			'heading_h3',
			array(
				'default'           => 1.75,
				'transport'         => 'postMessage',
				'sanitize_callback' => 'esc_html',
			)
		);

		$wp_customize->add_setting(
			'heading_h4',
			array(
				'default'           => 1.5,
				'transport'         => 'postMessage',
				'sanitize_callback' => 'esc_html',
			)
		);

		$wp_customize->add_setting(
			'heading_h5',
			array(
				'default'           => 1.25,
				'transport'         => 'postMessage',
				'sanitize_callback' => 'esc_html',
			)
		);

		$wp_customize->add_setting(
			'heading_h6',
			array(
				'default'           => 1,
				'transport'         => 'postMessage',
				'sanitize_callback' => 'esc_html',
			)
		);

		// Controls.
		$wp_customize->add_control(
			new Brayn_Customizer_Ui_Range(
				$wp_customize,
				'body_font_size',
				array(
					'label'       => esc_html__( 'Base font size', 'brayn' ),
					'description' => '',
					'input_attrs' => array(
						'min'  => 12,
						'max'  => 24,
						'step' => 1,
					),
					'unit'        => 'px',
					'section'     => 'theme_typography',
					'priority'    => 16,
				)
			)
		);

		$wp_customize->add_control(
			new Brayn_Customizer_Ui_Range(
				$wp_customize,
				'body_line_height',
				array(
					'label'       => esc_html__( 'Line height (vertical spacing)', 'brayn' ),
					'description' => '',
					'input_attrs' => array(
						'min'  => 1,
						'max'  => 3,
						'step' => 0.05,
					),
					'unit'        => 'em',
					'section'     => 'theme_typography',
					'priority'    => 17,
				)
			)
		);

		$wp_customize->add_control(
			new Brayn_Customizer_Ui_Range(
				$wp_customize,
				'heading_h1',
				array(
					'label'       => esc_html__( 'Heading (H1)', 'brayn' ),
					'description' => '',
					'input_attrs' => array(
						'min'  => 1,
						'max'  => 5,
						'step' => 0.05,
					),
					'unit'        => 'rem',
					'section'     => 'theme_typography',
					'priority'    => 18,
				)
			)
		);

		$wp_customize->add_control(
			new Brayn_Customizer_Ui_Range(
				$wp_customize,
				'heading_h2',
				array(
					'label'       => esc_html__( 'Heading (H2)', 'brayn' ),
					'description' => '',
					'input_attrs' => array(
						'min'  => 1,
						'max'  => 5,
						'step' => 0.05,
					),
					'unit'        => 'rem',
					'section'     => 'theme_typography',
					'priority'    => 19,
				)
			)
		);

		$wp_customize->add_control(
			new Brayn_Customizer_Ui_Range(
				$wp_customize,
				'heading_h3',
				array(
					'label'       => esc_html__( 'Heading (H3)', 'brayn' ),
					'description' => '',
					'input_attrs' => array(
						'min'  => 1,
						'max'  => 5,
						'step' => 0.05,
					),
					'unit'        => 'rem',
					'section'     => 'theme_typography',
					'priority'    => 20,
				)
			)
		);

		$wp_customize->add_control(
			new Brayn_Customizer_Ui_Range(
				$wp_customize,
				'heading_h4',
				array(
					'label'       => esc_html__( 'Heading (H4)', 'brayn' ),
					'description' => '',
					'input_attrs' => array(
						'min'  => 1,
						'max'  => 5,
						'step' => 0.05,
					),
					'unit'        => 'rem',
					'section'     => 'theme_typography',
					'priority'    => 21,
				)
			)
		);

		$wp_customize->add_control(
			new Brayn_Customizer_Ui_Range(
				$wp_customize,
				'heading_h5',
				array(
					'label'       => esc_html__( 'Heading (H5)', 'brayn' ),
					'description' => '',
					'input_attrs' => array(
						'min'  => 1,
						'max'  => 5,
						'step' => 0.05,
					),
					'unit'        => 'rem',
					'section'     => 'theme_typography',
					'priority'    => 22,
				)
			)
		);

		$wp_customize->add_control(
			new Brayn_Customizer_Ui_Range(
				$wp_customize,
				'heading_h6',
				array(
					'label'       => esc_html__( 'Heading (H6)', 'brayn' ),
					'description' => '',
					'input_attrs' => array(
						'min'  => 0.5,
						'max'  => 5,
						'step' => 0.05,
					),
					'unit'        => 'rem',
					'section'     => 'theme_typography',
					'priority'    => 23,
				)
			)
		);

		if ( ! class_exists( 'Brayn_Core' ) ) {
			return false;
		}

		$wp_customize->selective_refresh->add_partial(
			'brayn_heading_font',
			[
				'settings'            => [
					'brayn_heading_font',
					'brayn_body_font',
					'body_font_size',
					'body_line_height',
					'heading_h1',
					'heading_h2',
					'heading_h3',
					'heading_h4',
					'heading_h5',
					'heading_h6'
				],
				'selector'            => '#brayn-customizer-custom-css',
				'render_callback'     => 'brayn_customizer_process_api_color',
				'container_inclusive' => false,
				'fallback_refresh'    => false,
			]
		);
	}

	/**
	 * Customizer for additional woocommerce features
	 *
	 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
	 * @since 2.0.0
	 */
	public function woocommerce( $wp_customize ) {
		if ( ! BRAYN_WOOCOMMERCE_ACTIVE ) {
			return false;
		}

		$wp_customize->add_section(
			'brayn_woocommerce',
			array(
				'title'       => esc_html__( 'Header Buttons', 'brayn' ),
				'panel'       => 'woocommerce',
				'priority'    => 5,
				'description' => '',
			)
		);

		$wp_customize->get_control( 'enable_search' )->section    = 'brayn_woocommerce';
		$wp_customize->get_control( 'enable_woo_search' )->section = 'brayn_woocommerce';

		$wp_customize->add_setting(
			'enable_top_cart',
			array(
				'default'           => true,
				'transport'         => 'postMessage',
				'sanitize_callback' => 'esc_html',
			)
		);

		$wp_customize->add_control(
			new Brayn_Customizer_Ui_Toggle(
				$wp_customize,
				'enable_top_cart',
				array(
					'label'       => esc_html__( 'Top cart button.', 'brayn' ),
					'description' => esc_html__( 'Enabled/Disabled the cart button at the header.', 'brayn' ),
					'default_checked' => 'enabled',
					'section'     => 'brayn_woocommerce',
					'priority'    => 10,
				)
			)
		);

		$wp_customize->add_setting(
			'enable_top_user',
			array(
				'default'           => true,
				'transport'         => 'postMessage',
				'sanitize_callback' => 'esc_html',
			)
		);

		$wp_customize->add_control(
			new Brayn_Customizer_Ui_Toggle(
				$wp_customize,
				'enable_top_user',
				array(
					'label'       => esc_html__( 'Account button.', 'brayn' ),
					'description' => esc_html__( 'Enabled/Disabled the account button at the header.', 'brayn' ),
					'default_checked' => 'enabled',
					'section'     => 'brayn_woocommerce',
					'priority'    => 15,
				)
			)
		);

		$wp_customize->add_setting(
			'brayn_shop_layout',
			array(
				'default'           => 'right-sidebar',
				'transport'         => 'refresh',
				'sanitize_callback' => 'esc_html',
			)
		);

		$wp_customize->add_control(
			new Brayn_Customizer_Ui_Radio_Image(
				$wp_customize,
				'brayn_shop_layout',
				[
					'label'       => esc_html__( 'Shop layout', 'brayn' ),
					'description' => '',
					'choices'     => [
						'right-sidebar' => get_theme_file_uri( '/assets/images/customizer/right-sidebar.png' ),
						'no-sidebar'    => get_theme_file_uri( '/assets/images/customizer/no-sidebar.png' ),
						'left-sidebar'  => get_theme_file_uri( '/assets/images/customizer/left-sidebar.png' ),
					],
					'section'     => 'woocommerce_product_catalog',
					'priority'    => 5,
				]
			)
		);
	}
}

}

Brayn_Customizer::instance();
