<?php
/**
 * Some customizer helper functions
 *
 * @package Brayn
 * @since   1.0
 */

/**
 * Copyright text render callback.
 */
function brayn_customizer_cp_text() {
	return wp_kses_post( get_theme_mod( 'copyright_text', sprintf( esc_html__( '&copy;%s. Brayn by WIP Themes.', 'brayn' ), date('Y') ) ) );
}

function brayn_customizer_widget_image_url() {
	return '<img class="brayn-on-customize" style="opacity:1;" src="' . esc_url( get_theme_mod( 'brayn_widget_menu_image', get_theme_file_uri( '/assets/images/menu-widget-def-img.jpg' ) ) ) . '" alt="widget image" />';
}

function brayn_customizer_widget_image_text() {
	return wp_kses_post( get_theme_mod( 'brayn_menu_widget_image_text') );
}

function brayn_customizer_widget_social_title() {
	return wp_kses_post( get_theme_mod( 'brayn_menu_widget_social_title') );
}

function brayn_customizer_header_button_text() {
	return wp_kses_post( get_theme_mod( 'header_button_text', esc_html__( 'Button Text', 'brayn' ) ) );
}

/**
 * Render callback function for skin
 *
 * @since 1.0
 */
function brayn_customizer_process_api_color() {
	if ( class_exists( 'Brayn_Core' ) ) {
		$module = new Brayn_Skin_Loader();
		print brayn_customizer_print_css( $module->get_compiled_css() );
	}
}

function brayn_customizer_print_css( $css ) {
	return $css;
}

/**
 * Sanitize callback
 *
 * @param string $value from customizer.
 * @return string
 */
function brayn_customizer_partial_sanitize( $value ) {
	return esc_html( $value );
}

/**
 * Get the first post link
 *
 * @return int post id || bool when failure
 */
function brayn_customizer_get_first_post_link() {
	$lastposts = get_posts(
		array(
			'posts_per_page' => 1,
		)
	);

	if ( ! empty( $lastposts ) ) {
		$the_id = $lastposts[0]->ID;
		return get_permalink( $the_id );
	}

	return false;
}

/**
 * Add a placeholder for customizer preview.
 *
 * @since 1.0
 */
function brayn_customizer_print_css_placeholder() {
	if ( is_customize_preview() ) {
		print '<style id="brayn-customizer-custom-css" type="text/css"></style>';
	}
}
add_action( 'wp_head', 'brayn_customizer_print_css_placeholder', 999 );

/**
 * Stored custom skin options.
 *
 * @since 1.0
 */
function brayn_customizer_custom_skin_options() {
	$setting_options = [
		'brayn_primary_color' => [
			'label'       => esc_html__( 'Primary/Accent Color', 'brayn' ),
			'description' => '',
			'priority'    => 10,
			'section'     => 'theme_skin_base',
			'default'     => '#46ad2a',
		],
		'body_bg' => [
			'label'       => esc_html__( 'Body background', 'brayn' ),
			'description' => '',
			'priority'    => 11,
			'section'     => 'theme_skin_base',
			'default'     => '#ffffff',
		],
		'color_text_main' => [
			'label'       => esc_html__( 'Main text color', 'brayn' ),
			'description' => '',
			'priority'    => 13,
			'section'     => 'theme_skin_base',
			'default'     => '#565656',
		],
		'color_text_heading' => [
			'label'       => esc_html__( 'Heading text color', 'brayn' ),
			'description' => '',
			'priority'    => 14,
			'section'     => 'theme_skin_base',
			'default'     => '#1a1a1a',
		],
		'color_link' => [
			'label'       => esc_html__( 'Link color', 'brayn' ),
			'description' => '',
			'priority'    => 16,
			'section'     => 'theme_skin_base',
			'default'     => '#46ad2a',
		],
		'color_link_hover' => [
			'label'       => esc_html__( 'Link color (mouseover)', 'brayn' ),
			'description' => '',
			'priority'    => 17,
			'section'     => 'theme_skin_base',
			'default'     => '#255b16',
		],
		'input_bg' => [
			'label'       => esc_html__( 'Input field background', 'brayn' ),
			'description' => '',
			'priority'    => 18,
			'section'     => 'theme_skin_base',
			'default'     => '#ffffff',
		],
		'input_bg_focus' => [
			'label'       => esc_html__( 'Input field (focus) background', 'brayn' ),
			'description' => esc_html__( 'Input field background on focus/active state', 'brayn' ),
			'priority'    => 19,
			'section'     => 'theme_skin_base',
			'default'     => '#ffffff',
		],
		'color_text_input' => [
			'label'       => esc_html__( 'Input field text color', 'brayn' ),
			'description' => '',
			'priority'    => 20,
			'section'     => 'theme_skin_base',
			'default'     => '#989898',
		],
		'color_text_input_focus' => [
			'label'       => esc_html__( 'Input field (focus) text color', 'brayn' ),
			'description' => '',
			'priority'    => 21,
			'section'     => 'theme_skin_base',
			'default'     => '#565656',
		],
		'color_text_input_placeholder' => [
			'label'       => esc_html__( 'Input field placeholder text color', 'brayn' ),
			'description' => '',
			'priority'    => 22,
			'section'     => 'theme_skin_base',
			'default'     => '#989898',
		],
		'preloader_bg' => [
			'label'       => esc_html__( 'Preloader background', 'brayn' ),
			'description' => '',
			'priority'    => 5,
			'section'     => 'theme_skin_inner',
			'default'     => '#1a1a1a',
		],
		'preloader_loadbg' => [
			'label'       => esc_html__( 'Preloader spinner', 'brayn' ),
			'description' => '',
			'priority'    => 8,
			'section'     => 'theme_skin_inner',
			'default'     => '#46ad2a',
		],
		'page_heading_bg' => [
			'label'       => esc_html__( 'Page title background', 'brayn' ),
			'description' => '',
			'priority'    => 9,
			'section'     => 'theme_skin_inner',
			'default'     => '#212121',
		],
		'color_text_page_heading' => [
			'label'       => esc_html__( 'Page title text color', 'brayn' ),
			'description' => '',
			'priority'    => 10,
			'section'     => 'theme_skin_inner',
			'default'     => '#f4f4f4',
		],
		'color_text_page_heading_text' => [
			'label'       => esc_html__( 'Page subtitle text color', 'brayn' ),
			'description' => '',
			'priority'    => 12,
			'section'     => 'theme_skin_inner',
			'default'     => '#afafaf',
		],
		'searchbar_bg' => [
			'label'       => esc_html__( 'Search form background', 'brayn' ),
			'description' => '',
			'priority'    => 15,
			'section'     => 'theme_skin_inner',
			'default'     => '#0a0a0a',
		],
		'menu_bg' => [
			'label'       => esc_html__( 'Menu background', 'brayn' ),
			'description' => '',
			'priority'    => 5,
			'section'     => 'theme_skin_menu',
			'default'     => '#0a0a0a',
		],
		'color_link_menu' => [
			'label'       => esc_html__( 'Link color', 'brayn' ),
			'description' => '',
			'priority'    => 10,
			'section'     => 'theme_skin_menu',
			'default'     => '#afafaf',
		],
		'color_link_menu_hover' => [
			'label'       => esc_html__( 'Link mouseover', 'brayn' ),
			'description' => '',
			'priority'    => 12,
			'section'     => 'theme_skin_menu',
			'default'     => '#ffffff',
		],
		'color_link_menu_active' => [
			'label'       => esc_html__( 'Active menu link', 'brayn' ),
			'description' => '',
			'priority'    => 15,
			'section'     => 'theme_skin_menu',
			'default'     => '#ffffff',
		],
		'footer_bg' => [
			'label'       => esc_html__( 'Footer background', 'brayn' ),
			'description' => '',
			'priority'    => 5,
			'section'     => 'theme_skin_footer',
			'default'     => '#212121',
		],
		'color_text_footer' => [
			'label'       => esc_html__( 'Text color', 'brayn' ),
			'description' => '',
			'priority'    => 10,
			'section'     => 'theme_skin_footer',
			'default'     => '#dadada',
		],
		'color_text_footer_heading' => [
			'label'       => esc_html__( 'Heading color', 'brayn' ),
			'description' => '',
			'priority'    => 12,
			'section'     => 'theme_skin_footer',
			'default'     => '#f4f4f4',
		],
		'color_link_footer' => [
			'label'       => esc_html__( 'Link color', 'brayn' ),
			'description' => '',
			'priority'    => 15,
			'section'     => 'theme_skin_footer',
			'default'     => '#dadada',
		],
		'color_link_footer_hover' => [
			'label'       => esc_html__( 'Link color (mouseover)', 'brayn' ),
			'description' => '',
			'priority'    => 17,
			'section'     => 'theme_skin_footer',
			'default'     => '#ffffff',
		],
	];

	if ( BRAYN_WOOCOMMERCE_ACTIVE ) {
		$setting_options['woo_store_notice_bg'] = [
			'label'       => esc_html__( 'Store Notice background', 'brayn' ),
			'description' => '',
			'priority'    => 9,
			'section'     => 'theme_skin_woo',
			'default'     => '#212121',
		];

		$setting_options['woo_store_notice_color'] = [
			'label'       => esc_html__( 'Store Notice text color', 'brayn' ),
			'description' => '',
			'priority'    => 9,
			'section'     => 'theme_skin_woo',
			'default'     => '#dadada',
		];

		$setting_options['woo_store_notice_link'] = [
			'label'       => esc_html__( 'Store Notice link color', 'brayn' ),
			'description' => '',
			'priority'    => 9,
			'section'     => 'theme_skin_woo',
			'default'     => '#ffffff',
		];

		$setting_options['woo_onsale_bg'] = [
			'label'       => esc_html__( 'Onsale background', 'brayn' ),
			'description' => '',
			'priority'    => 10,
			'section'     => 'theme_skin_woo',
			'default'     => '#e74c3c',
		];

		$setting_options['woo_onsale_text'] = [
			'label'       => esc_html__( 'Onsale text', 'brayn' ),
			'description' => '',
			'priority'    => 11,
			'section'     => 'theme_skin_woo',
			'default'     => '#ffffff',
		];

		$setting_options['woo_button_bg'] = [
			'label'       => esc_html__( 'Product button bg', 'brayn' ),
			'description' => '',
			'priority'    => 12,
			'section'     => 'theme_skin_woo',
			'default'     => '#212121',
		];

		$setting_options['woo_button_text'] = [
			'label'       => esc_html__( 'Product button text', 'brayn' ),
			'description' => '',
			'priority'    => 13,
			'section'     => 'theme_skin_woo',
			'default'     => '#dadada',
		];

		$setting_options['woo_button_bg_hover'] = [
			'label'       => esc_html__( 'Product button bg hover', 'brayn' ),
			'description' => '',
			'priority'    => 14,
			'section'     => 'theme_skin_woo',
			'default'     => '#46ad2a',
		];

		$setting_options['woo_button_text_hover'] = [
			'label'       => esc_html__( 'Product button text hover', 'brayn' ),
			'description' => '',
			'priority'    => 15,
			'section'     => 'theme_skin_woo',
			'default'     => '#ffffff',
		];

		$setting_options['woo_single_price_color'] = [
			'label'       => esc_html__( 'Single price color', 'brayn' ),
			'description' => '',
			'priority'    => 16,
			'section'     => 'theme_skin_woo',
			'default'     => '#46ad2a',
		];

		$setting_options['woo_topcart_count_bg'] = [
			'label'       => esc_html__( 'Top cart count bg', 'brayn' ),
			'description' => esc_html__( 'The little circle at the top shopping bag icon', 'brayn' ),
			'priority'    => 17,
			'section'     => 'theme_skin_woo',
			'default'     => '#e3251d',
		];

		$setting_options['woo_topcart_count_text'] = [
			'label'       => esc_html__( 'Top cart count text', 'brayn' ),
			'description' => '',
			'priority'    => 18,
			'section'     => 'theme_skin_woo',
			'default'     => '#ffffff',
		];
	}

	return $setting_options;
}

/**
 * Compile the custom css skin,
 * running right after all customization is saved
 *
 * @param object $wp_customize WordPress Customize object.
 * @since 1.0
 * @return void
 */
function brayn_customizer_finish_compile( $wp_customize ) {
	// Refresh content editor css version.
	remove_theme_mod( 'brayn_editor_cache_action' );

	// Only run if core plugin is active.
	if ( class_exists( 'Brayn_Core' ) ) {
		$module = new Brayn_Skin_Loader();
		$module->take_action();
	}
}
add_action( 'customize_save_after', 'brayn_customizer_finish_compile' );

/**
 * Load dynamic logic for the customizer controls area.
 */
function brayn_customizer_panels_js() {
	wp_enqueue_script( 'bootstrap-js', get_theme_file_uri( '/assets/js/bootstrap.min.js' ), array( 'jquery' ), '1.0', true );
	wp_enqueue_script( 'bootstrap-select-js', get_theme_file_uri( '/assets/js/bootstrap-select.min.js' ), array( 'jquery', 'bootstrap-js' ), '1.12.2', true );
	wp_enqueue_script( 'brayn-customize-controls', get_theme_file_uri( '/assets/js/customize-controls.js' ), array( 'bootstrap-select-js' ), filemtime( get_parent_theme_file_path( '/assets/js/customize-controls.js' ) ), true );
	wp_enqueue_style( 'brayn-customize-controls', get_theme_file_uri( '/assets/css/customize-controls.css' ), array(), filemtime( get_parent_theme_file_path( '/assets/css/customize-controls.css' ) ), 'all' );
}
add_action( 'customize_controls_enqueue_scripts', 'brayn_customizer_panels_js' );

/**
 * Bind JS handlers to instantly live-preview changes.
 */
function brayn_customizer_customize_preview_js() {
	wp_enqueue_script( 'brayn-customize-preview', get_theme_file_uri( '/assets/js/customize-preview.js' ), array( 'customize-preview' ), filemtime( get_parent_theme_file_path( '/assets/js/customize-preview.js' ) ), true );
	wp_localize_script(
		'brayn-customize-preview',
		'cecuz',
		array(
			'postlink' => esc_js( brayn_customizer_get_first_post_link() ),
			'postarchivelink' => esc_js( get_post_type_archive_link( 'post' ) ),
			'homeurl'  => esc_js( home_url( '/' ) ),
		)
	);
}
add_action( 'customize_preview_init', 'brayn_customizer_customize_preview_js' );
