<?php
/**
 * Customize control block hr
 *
 * @package Brayn
 * @since   1.0
 */

/**
 * @since 1.0
 */
class Brayn_Customizer_Ui_Block_Hr extends WP_Customize_Control {
	/**
	 * Ui type
	 *
	 * @var string
	 * @since 1.0
	 */
	public $type = 'wip_themes_block_hr';

	/**
	 * Class constructor
	 *
	 * @param object $manager WP_Customize_Control.
	 * @param mixed  $id      WP_Customize_Control.
	 * @param array  $args    WP_Customize_Control.
	 * @param array  $options WP_Customize_Control.
	 * @return void
	 */
	public function __construct( $manager, $id, $args = array(), $options = array() ) {
		parent::__construct( $manager, $id, $args );
	}

	/**
	 * Render the control's content.
	 */
	public function render_content() {
		?>
			<div class="wipThemes_ui_block_wrapper">
				<h4>
					<?php echo esc_html( $this->label ); ?>
				</h4>
			</div>
		<?php
	}
}
