<?php
/**
 * Customize control Google fonts
 *
 * @package Brayn
 * @since   1.0
 */

/**
 * Google fonts select dropdowns
 *
 * @since 1.0
 */
class Brayn_Customizer_Ui_Fonts extends WP_Customize_Control {
	/**
	 * Ui type
	 *
	 * @var string
	 * @since 1.0
	 */
	public $type = 'google_fonts_dropdown';

	/**
	 * Fonts data
	 *
	 * @var bool
	 * @since 1.0
	 */
	private $fonts = false;

	/**
	 * Class constructor
	 *
	 * @param object $manager WP_Customize_Control.
	 * @param mixed  $id      WP_Customize_Control.
	 * @param array  $args    WP_Customize_Control.
	 * @param array  $options WP_Customize_Control.
	 * @return void
	 */
	public function __construct( $manager, $id, $args = array(), $options = array() ) {
		$this->fonts = brayn_get_google_fonts_data();
		parent::__construct( $manager, $id, $args );
	}

	/**
	 * Render the content.
	 */
	public function render_content() {
		if ( $this->fonts && ! empty( $this->fonts ) ) {
			?>
		<label>
			<span class="customize-category-select-control"><?php echo esc_html( $this->label ); ?></span>
		</label>
		<div class="wipThemes-font-ui">
			<select data-live-search="true" <?php $this->link(); ?>>
			<?php
			foreach ( $this->fonts as $k => $v ) {
				$variants = $v->variants;
				$variant  = array();
				foreach ( $variants as $vrs ) {
					$vrs = str_replace( 'italic', 'i', $vrs );
					if ( 'regular' === $vrs ) {
						$vrs = '400';
					} elseif ( 'i' === $vrs ) {
						$vrs = '400i';
					}
					$variant[] = $vrs;
				}
				unset( $vrs );
				$variant = implode( ',', $variant );
				$vll     = str_replace( ' ', '+', $v->family ) . ':' . $variant;
				printf( '<option value="%s" %s>%s</option>', esc_attr( $vll ), selected( $this->value(), $vll, false ), esc_html( $v->family ) );
			}
			?>
			</select>
		</div>
			<?php
		} else {
			// we need our core plugin to activate the google font feature.
			print esc_html__( 'Please activate the "Brayn Core" plugin.', 'brayn' );
		}
	}
}