<?php
/**
 * Customize control Range Option
 *
 * @package Brayn
 * @since   1.0
 */

/**
 * UI Range
 *
 * @since 1.0
 */
class Brayn_Customizer_Ui_Range extends WP_Customize_Control {
	/**
	 * Ui type
	 *
	 * @var string
	 * @since 1.0
	 */
	public $type = 'wip_themes_ui_range';

	/**
	 * Ui unit
	 *
	 * @var string
	 * @since 1.0
	 */
	public $unit = '';

	/**
	 * Class constructor
	 *
	 * @param object $manager WP_Customize_Control.
	 * @param mixed  $id      WP_Customize_Control.
	 * @param array  $args    WP_Customize_Control.
	 * @param array  $options WP_Customize_Control.
	 * @return void
	 */
	public function __construct( $manager, $id, $args = array(), $options = array() ) {
		parent::__construct( $manager, $id, $args );
	}

	/**
	 * Render the control's content.
	 */
	public function render_content() {
		?>
		<label class="wipThemes_ui_range_parent" data-unit="<?php echo esc_attr( $this->unit ); ?>">
			<?php echo esc_html( $this->label ); ?>
			<br/>
			<input type="range" value="<?php echo esc_attr( $this->value() ); ?>" <?php $this->link(); ?> <?php $this->input_attrs(); ?> />
			<input type="text" value="<?php echo esc_attr( $this->value() ); ?> <?php echo esc_attr( $this->unit ); ?>" readonly />
			<?php if ( ! empty( $this->description ) ) : ?>
				<span class="description customize-control-description"><?php echo esc_html( $this->description ); ?></span>
			<?php endif; ?>
		</label>

		<?php
	}
}
