<?php
/**
 * Customize control custom refresher
 *
 * @package Brayn
 * @since   1.0
 */

/**
 * Custom Refresher
 *
 * @since 1.0
 */
class Brayn_Customizer_Ui_Refresher extends WP_Customize_Control {
	/**
	 * Ui type
	 *
	 * @var string
	 * @since 1.0
	 */
	public $type = 'wip_themes_ui_refresher';

	/**
	 * Class constructor
	 *
	 * @param object $manager WP_Customize_Control.
	 * @param mixed  $id      WP_Customize_Control.
	 * @param array  $args    WP_Customize_Control.
	 * @param array  $options WP_Customize_Control.
	 * @return void
	 */
	public function __construct( $manager, $id, $args = array(), $options = array() ) {
		parent::__construct( $manager, $id, $args );
	}

	/**
	 * Render the control's content.
	 */
	public function render_content() {
		?>
			<label class="wipThemes_ui_refresher_parent">
				<input type="checkbox" value="on" <?php $this->link(); ?> <?php checked( $this->value() ); ?> />
				<span class="wipThemes_ui_refresher">
					<?php echo esc_html( $this->label ); ?>
				</span>
				<?php if ( ! empty( $this->description ) ) : ?>
					<span class="description customize-control-description"><?php echo esc_html( $this->description ); ?></span>
				<?php endif; ?>
			</label>
		<?php
	}
}
