<?php
/**
 * The template for displaying single portfolio.
 *
 * @package WordPress
 * @subpackage Brayn
 * @since 1.0
 */

get_header();
?>

<main id="main" class="main-contain">

<?php if ( have_posts() ) : ?>
	<!-- Portfolio header -->
	<section class="single-portfolio-header">	
		<header>
			<?php the_title( '<h1>', '</h1>' ); ?>
			<?php
				if ( brayn_get_portfolio_cat_lists( get_the_ID() ) ) {
			?>
			<span class="portfolio-category"><?php print brayn_get_portfolio_cat_lists( get_the_ID(), ' / ' ); ?></span>
			<?php } ?>
		</header>

		<div class="portfolio-header-bg">
		<?php if ( has_post_thumbnail() ) { ?>
			<?php print get_the_post_thumbnail( $post, 'full' ); ?>
		<?php } ?>
		</div>

		<span class="br-scroll-me"><?php print esc_html__( 'Scroll', 'brayn' ); ?></span>
	</section>
<?php endif; ?>

	
	<?php
		while ( have_posts() ) :
			the_post();

			global $post;
	?>
	<div class="container">

		<article id="post-<?php the_ID(); ?>" <?php post_class( 'brayn-single-page' ); ?>>
			
			<div class="br-section brayn-the-content">
				<?php
				if ( ! brayn_post_is_built_with_elementor( get_the_ID() ) ) {
					print '<div class="single-post-contain">' . "\n";
					print '<div class="post-content-contain">' . "\n";
				}

					the_content();

					wp_link_pages( array(
						'before'      => '<div class="page-links"><span class="screen-reader-text">' . esc_html__( 'Pages:', 'brayn' ) . '</span>',
						'after'       => '</div>',
						'link_before' => '<span class="page-number">',
						'link_after'  => '</span>',
					) );

				if ( ! brayn_post_is_built_with_elementor( get_the_ID() ) ) {
					print '</div>' . "\n";
					print '</div>' . "\n";
				}
				?>
			</div>	

		</article>

	</div>
	<!-- .container -->
	<?php
		if ( '' !== get_theme_mod( 'portfolio_prev_next', true ) || is_customize_preview() ) {

			// Customizer placeholder, not really shown in actual site.
			if ( is_customize_preview() ) {
				$postnavhide = ( '' === get_theme_mod( 'portfolio_prev_next', true ) ? 'display:none;' : '' );
				print '<div id="portfolio_prev_next_customization" style="' . esc_attr( $postnavhide ) . '">';
			}

			print '<div class="project-next-prev">' . "\n";
				the_post_navigation( array(
					'prev_text' => brayn_get_prev_next_post_thumbnail( 'prev', 'thumbnail' ) . '<span class="screen-reader-text">' . esc_html__( 'Previous Post', 'brayn' ) . '</span><span aria-hidden="true" class="nav-subtitle">' . esc_html__( 'Previous', 'brayn' ) . '</span> <span class="nav-title">%title</span>',
					'next_text' => brayn_get_prev_next_post_thumbnail( 'next', 'thumbnail'  ) . '<span class="screen-reader-text">' . esc_html__( 'Next Post', 'brayn' ) . '</span><span aria-hidden="true" class="nav-subtitle">' . esc_html__( 'Next', 'brayn' ) . '</span> <span class="nav-title">%title</span>',
				) );
			print '</div>' . "\n";

			// Customizer placeholder, not really shown in actual site.
			if ( is_customize_preview() ) {
				print '</div>';
			}
		}

		endwhile;

		do_action( 'brayn_after_single_portfolio' );
	?>

</main>

<?php
get_footer();
