<?php
/**
 * Loop search template
 *
 * @since   1.0
 * @package Brayn
 */

$color_classes = ['#2ecc71', '#3498db', '#8e44ad', '#e74c3c', '#2c3e50', '#f1c40f', '#95a5a6'];
?>

<article id="search-<?php the_ID(); ?>" <?php post_class( 'search-loop-item' ); ?>>
	<div class="search-loop-ui d-flex">
		<div class="av-search-loop d-flex align-content-center justify-content-center flex-wrap flex-grow-0" style="background-color: <?php print esc_attr( $color_classes[ array_rand( $color_classes ) ] ); ?>">
			<?php print mb_substr( get_the_title(), 0, 1, "UTF-8" ); ?>
		</div>
		<div class="search-loop-ct flex-grow-1">
			<header>
				<h3 class="entry-title"><a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>" rel="bookmark"><?php the_title(); ?></a></h3>
				<span class="meta-link"><?php print brayn_option_time_link(); ?></span>
			</header>

			<?php the_excerpt(); ?>
		</div>
	</div>
</article>
