<?php
/**
 * Menu widgets template part
 *
 * @package WordPress
 * @subpackage Brayn
 * @since 1.0
 * @version 1.0
 */

?>

<nav class="main-menu-widgets">

	<div class="menu-widget">
	<?php
		if ( get_theme_mod( 'use_widget_image', false ) || is_customize_preview() ) {
			$attr_style_img = is_customize_preview() ? ( ! get_theme_mod( 'use_widget_image', false ) ? 'display:none;' : '' ) : '';
	?>
		<a class="menu-widget-block" href="<?php print esc_url( get_theme_mod( 'brayn_menu_widget_image_url', '#' ) ); ?>"
			<?php if ( get_theme_mod( 'brayn_menu_widget_image_url_target', false ) ) {
				print ' target="_blank"';
			} ?> style="<?php print esc_attr( $attr_style_img ); ?>">
			<div class="menu-widget-image">
			<?php if ( get_theme_mod( 'brayn_widget_menu_image', false ) || is_customize_preview() ) { ?>
				<div class="brayn_menu_widget_image"><img src="<?php print esc_url( get_theme_mod( 'brayn_widget_menu_image', get_theme_file_uri( '/assets/images/menu-widget-def-img.jpg' ) ) ); ?>" alt="widget image" /></div>
			<?php } ?>
			</div>
			<?php if ( get_theme_mod( 'brayn_menu_widget_image_text', false ) || is_customize_preview() ) { ?>
			<h4 class="brayn_menu_widget_image_text"><?php print wp_kses_post( get_theme_mod( 'brayn_menu_widget_image_text' ) ); ?></h4>
			<?php } ?>
		</a>
	<?php } ?>
	</div>

	<?php
		if ( get_theme_mod( 'use_widget_social', false ) || is_customize_preview() ) {
			$attr_style = is_customize_preview() ? ( ! get_theme_mod( 'use_widget_social', false ) ? 'display:none;' : '' ) : '';
	?>
	<div class="menu-widget menu-widget-social-block" style="<?php print esc_attr( $attr_style ); ?>">
			<h4 class="brayn_menu_widget_social_title"><?php print wp_kses_post( get_theme_mod( 'brayn_menu_widget_social_title' ) ); ?></h4>
			<ul class="menu-widget-list brayn-menu-widget-list">
				<?php brayn_print_active_social_links(); ?>
			</ul>
	</div>
	<?php } ?>
</nav>
