<?php
/**
 * post loop classic
 *
 * @package brayn
 * @since 1.0
 */

$post_classes = array( 'br-post', 'br-post-classic' );
?>

<article id="post-<?php the_ID(); ?>" <?php post_class( $post_classes ); ?>>

	<div class="ui-post-classic">
		<div class="post-classic-date">
			<?php print brayn_time_link(); ?>
		</div>

		<div class="post-classic-contain">
			<?php if ( has_post_thumbnail() ) { ?>
				<div class="entry-image has-reveal-effect" data-effect="revealTop">
					<a href="<?php the_permalink(); ?>" rel="bookmark">
						<?php the_post_thumbnail( 'brayn-post-wide' ); ?>
					</a>
				</div>
			<?php } ?>

			<header class="entry-header">
				<?php brayn_category_lists(); ?>
				<h3 class="entry-title"><a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>" rel="bookmark"><?php the_title(); ?></a></h3>
			</header>

			<footer class="entry-meta d-flex justify-content-between">
				<?php print brayn_get_post_author(); ?>
			</footer>

			<div class="entry-content">
				<?php the_excerpt(); ?>

				<p>
					<a class="btn brayn-btn-std" href="<?php the_permalink(); ?>"><?php print esc_html__( 'Continue reading', 'brayn' ); ?></a>
				</p>
			</div>

		</div>
	</div>

</article>
