<?php
/**
 * post loop columns
 *
 * @package brayn
 * @since 1.0
 */

$post_classes = array( 'br-post', 'br-post-grid' );
?>

	<article id="post-<?php the_ID(); ?>" <?php post_class( $post_classes ); ?>>

	<?php if ( has_post_thumbnail() ) { ?>
		<div class="entry-image has-reveal-effect" data-effect="revealTop">
			<a href="<?php the_permalink(); ?>" rel="bookmark">
				<?php the_post_thumbnail( 'brayn-post-cover' ); ?>
			</a>
		</div>

		<header class="entry-header">
			<?php brayn_category_lists(); ?>
			<h4 class="entry-title"><a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>" rel="bookmark"><?php the_title(); ?></a></h4>
		</header>

		<footer class="entry-meta">
			<?php print brayn_get_post_author(); ?>
			<span class="meta-separator">/</span>
			<?php print brayn_option_time_link(); ?>
		</footer>
	<?php } else { ?>

		<div class="ui-post-no-thumbnail d-flex align-items-center">
			<div class="d-block w-100">
				<header class="entry-header">
					<?php brayn_category_lists(); ?>
					<h4 class="entry-title"><a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>" rel="bookmark"><?php the_title(); ?></a></h4>
				</header>

				<footer class="entry-meta d-flex justify-content-between">
					<?php print brayn_get_post_author(); ?>
					<?php print brayn_option_time_link(); ?>
				</footer>
			</div>
		</div>

	<?php } ?>
	</article>
