<?php
/**
 * post loop staggered
 *
 * @package brayn
 * @since 1.0
 */

$post_classes = array( 'br-post', 'br-post-staggered' );
?>

<article id="post-<?php the_ID(); ?>" <?php post_class( $post_classes ); ?>>

	<?php if ( has_post_thumbnail() ) { ?>
		<div class="row">

			<div class="col-md-7 staggered-image">

				<div class="entry-image has-reveal-effect" data-effect="revealTop">
					<a href="<?php the_permalink(); ?>" rel="bookmark">
						<?php the_post_thumbnail( 'brayn-post-cover' ); ?>
					</a>
				</div>

			</div>

			<div class="col-md-5 d-md-flex align-items-md-center">
				<div class="d-block w-100 pt-5 pt-md-0">
					<header class="entry-header">
						<?php brayn_category_lists(); ?>
						<h4 class="entry-title"><a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>" rel="bookmark"><?php the_title(); ?></a></h4>
					</header>

					<footer class="entry-meta d-flex justify-content-between">
						<?php print brayn_get_post_author(); ?>
						<?php print brayn_option_time_link(); ?>
					</footer>

					<div class="entry-content">
						<?php the_excerpt(); ?>

						<p>
							<a class="btn brayn-btn-std" href="<?php the_permalink(); ?>"><?php print esc_html__( 'Continue reading', 'brayn' ); ?></a>
						</p>
					</div>
				</div>
			</div>

		</div>
	<?php } else { ?>

		<div class="ui-post-no-thumbnail d-flex align-items-center">
			<div class="d-block w-100">
				<header class="entry-header">
					<?php brayn_category_lists(); ?>
					<h4 class="entry-title"><a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>" rel="bookmark"><?php the_title(); ?></a></h4>
				</header>

				<footer class="entry-meta d-flex justify-content-between">
					<?php print brayn_get_post_author(); ?>
					<?php print brayn_option_time_link(); ?>
				</footer>

				<div class="entry-content">
					<?php the_excerpt(); ?>

					<p>
						<a class="btn brayn-btn-std" href="<?php the_permalink(); ?>"><?php print esc_html__( 'Continue reading', 'brayn' ); ?></a>
					</p>
				</div>
			</div>
		</div>

	<?php } ?>

</article>
