<?php
/**
 * Single post layout, left sidebar
 *
 * @package brayn
 * @since 1.0
 */

?>

<div class="container">

	<div class="row main-row">

		<div class="single-post-contain col-lg-9 col-md-8 order-md-2">

<?php
	while ( have_posts() ) :
		the_post();

		global $post;
?>
	<article id="post-<?php the_ID(); ?>" <?php post_class( 'single-post' ); ?>>

		<header class="entry-header">
			<?php brayn_category_lists(); ?>
			<h1 class="entry-title"><?php the_title(); ?></h1>
		</header>

		<footer class="entry-meta">
			<?php print brayn_get_post_author(); ?>
			<span class="meta-separator">&#47;</span>
			<?php print brayn_option_time_link(); ?>
			<span class="meta-separator">&#47;</span>
			<?php comments_popup_link( esc_html__( '0 comments', 'brayn' ), esc_html__( '1 comment', 'brayn' ), esc_html__( '% comments', 'brayn' ), 'comments-link', esc_html__( 'Comments off', 'brayn' ) ); ?>
		</footer>

		<?php if ( has_post_thumbnail() ) { ?>
		<div class="post-featured-image">
			<?php print get_the_post_thumbnail( $post, 'full' ); ?>
		</div>
		<?php } ?>

		<div class="post-content-contain">
			<?php 
				the_content();

				wp_link_pages( array(
					'before'      => '<div class="page-links"><span class="screen-reader-text">' . esc_html__( 'Pages:', 'brayn' ) . '</span>',
					'after'       => '</div>',
					'link_before' => '<span class="page-number">',
					'link_after'  => '</span>',
				) );

				print '<hr class="wp-block-separator is-style-dots" />' . "\n";

				brayn_entry_tag();

				do_action( 'brayn_after_single_entry', $post );
			?>
		</div>
	</article>

<?php
	// Prev / next post links.
	if ( '' !== get_theme_mod( 'post_prev_next', true ) || is_customize_preview() ) {

		// Customizer placeholder, not really shown in actual site.
		if ( is_customize_preview() ) {
			$postnavhide = ( '' === get_theme_mod( 'post_prev_next', true ) ? 'display:none;' : '' );
			print '<div id="post_prev_next_customization" style="' . esc_attr( $postnavhide ) . '">';
		}

		the_post_navigation( array(
			'prev_text' => brayn_get_prev_next_post_thumbnail( 'prev', 'thumbnail' ) . '<span class="screen-reader-text">' . esc_html__( 'Previous Post', 'brayn' ) . '</span><span aria-hidden="true" class="nav-subtitle">' . esc_html__( 'Previous', 'brayn' ) . '</span> <span class="nav-title">%title</span>',
			'next_text' => brayn_get_prev_next_post_thumbnail( 'next', 'thumbnail' ) . '<span class="screen-reader-text">' . esc_html__( 'Next Post', 'brayn' ) . '</span><span aria-hidden="true" class="nav-subtitle">' . esc_html__( 'Next', 'brayn' ) . '</span> <span class="nav-title">%title</span>',
		) );

		// Customizer placeholder, not really shown in actual site.
		if ( is_customize_preview() ) {
			print '</div>';
		}
	}

	// If comments are open or we have at least one comment, load up the comment template.
	if ( comments_open() || get_comments_number() ) {
		comments_template();
	}

	endwhile;
?>
		</div>

		<?php get_sidebar( 'post' ); ?>

	</div>

</div>
<!-- .container -->
