<?php
/**
 * Custom author fields
 *
 * @author WIP Themes
 * @version 1.0
 */

function wip_themes_core_show_user_fields( $user ) {
	$socials = array(
		'_author_facebook' => array(
			'label' => esc_html__( 'Facebook', 'brayn-core' ),
			'description' => esc_html__( 'Enter the URL of your facebook profile.', 'brayn-core' ),
			),
		'_author_twitter' => array(
			'label' => esc_html__( 'Twitter', 'brayn-core' ),
			'description' => esc_html__( 'Enter the URL of your twitter profile.', 'brayn-core' ),
			),
		'_author_instagram' => array(
			'label' => esc_html__( 'Instagram', 'brayn-core' ),
			'description' => esc_html__( 'Enter the URL of your Instagram.', 'brayn-core' ),
			),
		'_author_youtube' => array(
			'label' => esc_html__( 'Youtube', 'brayn-core' ),
			'description' => esc_html__( 'Enter the URL of your Youtube channel.', 'brayn-core' ),
			),
		'_author_vimeo' => array(
			'label' => esc_html__( 'Vimeo', 'brayn-core' ),
			'description' => esc_html__( 'Enter the URL of your Vimeo profile.', 'brayn-core' ),
			),
		'_author_google-plus' => array(
			'label' => esc_html__( 'Google+', 'brayn-core' ),
			'description' => esc_html__( 'Enter the URL of your Google+ profile.', 'brayn-core' ),
			),
		'_author_pinterest' => array(
			'label' => esc_html__( 'Pinterest', 'brayn-core' ),
			'description' => esc_html__( 'Enter the URL of your pinterest profile.', 'brayn-core' ),
			),
		'_author_medium' => array(
			'label' => esc_html__( 'Medium', 'brayn-core' ),
			'description' => esc_html__( 'Enter the URL of your medium profile.', 'brayn-core' ),
			),
		'_author_tumblr' => array(
			'label' => esc_html__( 'Tumblr', 'brayn-core' ),
			'description' => esc_html__( 'Enter the URL of your tumblr.', 'brayn-core' ),
			),
		);
	?>
	<h3><?php esc_html_e( 'Social Links', 'brayn-core' ); ?></h3>
	<table class="form-table">
	<?php
	foreach ( $socials as $field_id => $anmy ) {
	?>
	<tr>
		<th><label for="<?php print esc_attr( $field_id ); ?>"><?php print esc_html( $anmy['label'] ); ?></label></th>
		<td>
		<input type="text" name="<?php print esc_attr( $field_id ); ?>" id="<?php print esc_attr( $field_id ); ?>" value="<?php echo esc_attr( get_the_author_meta( esc_html( $field_id ), $user->ID ) ); ?>" class="regular-text" /><br />
			<span class="description"><?php print esc_html( $anmy['description'] ); ?></span>
		</td>
	</tr>
	<?php
	} // End foreach().
	?>
	</table>
	<?php
}
add_action( 'show_user_profile', 'wip_themes_core_show_user_fields' );
add_action( 'edit_user_profile', 'wip_themes_core_show_user_fields' );

function wip_themes_core_save_profile_fields( $user_id ) {
	if ( ! current_user_can( 'edit_user', $user_id ) ) {
		return false;
	}

	$socials = array( '_author_facebook', '_author_twitter', '_author_instagram', '_author_youtube', '_author_vimeo', '_author_google-plus', '_author_pinterest', '_author_medium', '_author_tumblr' );
	foreach ( $socials as $social ) {

		if ( isset( $_POST[ $social ] ) ) {

			$value = sanitize_text_field( $_POST[ $social ] );
			update_user_meta( $user_id, esc_html( $social ), $value );
		}
	}
	unset( $social );
}
add_action( 'personal_options_update', 'wip_themes_core_save_profile_fields' );
add_action( 'edit_user_profile_update', 'wip_themes_core_save_profile_fields' );
