<?php
/**
 * Posts custom columns
 *
 * @author WIP-Themes
 * @version 1.0
 */

// Stop if theme request to not include the featured posts feature.
if ( 'yes' === get_option('wip_themes_core_no_featured_posts') ) {
	return false;
}

function wip_themes_core_admin_run_make_featured_post() {
	if ( ! in_array( get_current_screen()->id, array( 'edit-post' ) ) ) {
		return;
	}

	$paged = isset( $_GET['paged'] ) ? $_GET['paged'] : false;
	$post_type = isset( $_GET['post_type'] ) ? $_GET['post_type'] : false;

	if ( isset( $_GET['action'] ) ) {

		$pid = isset( $_GET['pid'] ) ? $_GET['pid'] : false;

		if ( $_GET['action'] === 'make_post_featured' ) {

			if ( $pid && ! wip_themes_post_is_featured( $pid ) ) {
				update_post_meta( $pid, '_wip_themes_featured', '1', get_post_meta( get_the_ID(), '_wip_themes_featured', true ) );
			}
		} elseif ( $_GET['action'] === 'make_post_unfeatured' ) {

			if ( $pid && wip_themes_post_is_featured( $pid ) ) {
				update_post_meta( $pid, '_wip_themes_featured', '0', '1' );
			}
		} // End if().

		$action_url = add_query_arg( 'post_type', $post_type, admin_url( 'edit.php' ) );
		if ( $paged ) {
			$action_url = add_query_arg( 'paged', $paged, $action_url );
		}
		wp_redirect( $action_url );
		exit;

	} // End if().
}
add_action( 'load-edit.php', 'wip_themes_core_admin_run_make_featured_post' );

/**
 * Post table column structure
 *
 * @param array $columns the current post column.
 *
 * @return array()
 */
function wip_themes_core_admin_post_edit_columns( $columns ) {

	$res = array_slice( $columns, 0, 2, true ) + array(
		'post-feature' => '<span class="vers dashicons-before dashicons-star-filled" title="' . esc_attr__( 'Featured', 'brayn-core' ) . '"><span class="screen-reader-text">' . esc_html__( 'Featured', 'brayn-core' ) . '</span></span>',
		) + array_slice( $columns, 2, count( $columns ) - 2, true );

	return $res;
}
add_filter( 'manage_edit-post_columns', 'wip_themes_core_admin_post_edit_columns' );

/**
 * output the post table column content
 * based on column ID
 *
 * @return void
 */
function wip_themes_core_admin_manage_posts_custom_column( $column ) {
	global $post;

	switch ( $column ) {

		case 'post-feature' :

			$paged = isset( $_GET['paged'] ) ? $_GET['paged'] : false;
			$post_type = isset( $_GET['post_type'] ) ? $_GET['post_type'] : false;

			if ( wip_themes_post_is_featured( $post->ID ) ) {
				$args = array(
					'action' => 'make_post_unfeatured',
					'pid' => $post->ID,
				);

				if ( $post_type ) {
					$args['post_type'] = $post_type;
				}

				if ( $paged ) {
					$args['paged'] = $paged;
				}
				$action_url = add_query_arg( $args, admin_url( 'edit.php' ) );
				echo '<a href="' . esc_url( $action_url ) . '" style="color: #f6b434;"><span class="dashicons dashicons-star-filled"><span class="screen-reader-text">Yes</span></span></a>';

			} else {

				$args = array(
					'action' => 'make_post_featured',
					'pid' => $post->ID,
				);

				if ( $post_type ) {
					$args['post_type'] = $post_type;
				}

				if ( $paged ) {
					$args['paged'] = $paged;
				}

				$action_url = add_query_arg( $args, admin_url( 'edit.php' ) );
				echo '<a href="' . esc_url( $action_url ) . '"><span class="dashicons dashicons-star-empty"><span class="screen-reader-text">No</span></span></a>';
			}
		break;
	} // End switch().
}
add_action( 'manage_posts_custom_column', 'wip_themes_core_admin_manage_posts_custom_column' );
