<?php
/*
Plugin Name: Brayn Core
Plugin URI: https://themeforest.net/user/wip-themes
Description: Core functions and features required by Brayn Theme by WIP-Themes
Version: 2.0.0
Author: WIP-Themes
Author URI: https://themeforest.net/user/wip-themes
License: GPL
Text Domain: brayn-core
Copyright: https://themeforest.net/user/wip-themes
*/

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'Brayn_Core' ) ) {
	class Brayn_Core {
		// var $plugin_url
		public $plugin_url;

		// var $plugin_path
		public $plugin_path;

		// var self::$instance
		private static $instance;

		/**
		 * Main plugin's instance
		 *
		 * @access public
		 * @since 1.0
		 * @return instance of Brayn_Core
		 */
		public static function instance() {
			if ( ! isset( self::$instance ) && ! ( self::$instance instanceof Brayn_Core ) ) {
				self::$instance = new Brayn_Core;
				self::$instance->define_constants();
				self::$instance->call_files();

				register_activation_hook( __FILE__, 'brayn_cores_activate' );
				register_deactivation_hook( __FILE__, 'brayn_cores_deactivate' );
				add_action( 'admin_init', array( self::$instance, '_run' )  );
				add_action( 'init', array( self::$instance, 'init' ) );
				add_action( 'widgets_init', array( self::$instance, 'register_widgets' ) );
			}

			return self::$instance;
		}

		/**
		 * Plugin inits
		 *
		 * @access public
		 * @since 1.0
		 * @return void
		 */
		public function init() {
			do_action( 'brayn_core_before_init' );

			$this->_i18n();

			do_action( 'brayn_core_init' );
		}

		/**
		 * Throw error on object clone
		 *
		 * The whole idea of the singleton design pattern is that there is a single
		 * object therefore, we don't want the object to be cloned.
		 *
		 * @since 1.0
		 * @access protected
		 * @return void
		 */
		public function __clone() {
			// Cloning instances of the class is forbidden
			_doing_it_wrong( __FUNCTION__, __( 'Cheatin&#8217; huh?', 'brayn-core' ), '2.0.0' );
		}

		/**
		 * Define some constants using by plugin
		 *
		 * @access private
		 * @since 1.0
		 * @return void
		 */
		private function define_constants() {
			if ( ! defined( 'BRAYN_CORE_VER' ) )
				define( "BRAYN_CORE_VER", '2.0.0' );

			if ( ! defined( 'BRAYN_CORE_PATH' ) )
				define( "BRAYN_CORE_PATH", dirname( __FILE__ ) );

			if ( ! defined( 'BRAYN_CORE_URL' ) )
				define( "BRAYN_CORE_URL", untrailingslashit( plugins_url( '/', __FILE__ ) ) );

			if ( ! defined( 'BRAYN_CORE_FILE' ) )
				define( 'BRAYN_CORE_FILE', plugin_basename( __FILE__ ) );

			define( 'BRAYNCORE_WOOCOMMERCE_ACTIVE', class_exists( 'WooCommerce' ) );
		}

		/**
		 * Call required files
		 *
		 * @access private
		 * @since 1.0
		 * @return void
		 */
		private function call_files() {
			require_once( BRAYN_CORE_PATH . '/inc/init.php' );
			require_once( BRAYN_CORE_PATH . '/inc/functions.php' );
			require_once( BRAYN_CORE_PATH . '/inc/class-brayn-core-cpt.php' );
			require_once( BRAYN_CORE_PATH . '/inc/class-brayn-core-sass-production.php' );
			require_once( BRAYN_CORE_PATH . '/admin/class-brayn-core-metabox.php' );
			require_once( BRAYN_CORE_PATH . '/inc/instagram-module.php' );
			require_once( BRAYN_CORE_PATH . '/inc/custom-widgets.php' );
			require_once( BRAYN_CORE_PATH . '/inc/class-brayn-core-compiler-scss.php' );
			require_once( BRAYN_CORE_PATH . '/inc/class-brayn-elementor-factory.php' );
			
			if ( is_admin() ) {
				require_once( BRAYN_CORE_PATH . '/admin/custom-post-manage-column.php' );
				require_once( BRAYN_CORE_PATH . '/admin/custom-tax-fields.php' );
				require_once( BRAYN_CORE_PATH . '/admin/custom-author-socials.php' );
			}
		}

		/**
		 * Register plugin's translation
		 *
		 * @access public
		 * @since 1.0
		 * @return void
		 */
		public function _i18n() {
			load_plugin_textdomain( 'brayn-core', false, 'brayn-core/langs' );
		}

		/**
		 * get and set plugin url
		 *
		 * @access public
		 * @since 1.0
		 * @return string plugin public url
		 */
		public function plugin_url() {
			if ( self::$instance->plugin_url )
				return self::$instance->plugin_url;

			if ( defined( "BRAYN_CORE_URL" ) ) {
				return self::$instance->plugin_url = BRAYN_CORE_URL;
			} else {
				return self::$instance->plugin_url = untrailingslashit( plugins_url( '/', __FILE__ ) );
			}
		}

		/**
		 * get and set plugin path
		 *
		 * @access public
		 * @since 1.0
		 * @return string plugin path
		 */
		public function plugin_path() {
			if ( self::$instance->plugin_path )
				return self::$instance->plugin_path;

			if ( defined( "BRAYN_CORE_PATH" )) {
				return self::$instance->plugin_path = BRAYN_CORE_PATH;
			} else {
				return self::$instance->plugin_path = dirname( __FILE__ );
			}
		}

		/**
		 * Register custom widgets
		 *
		 * @access public
		 * @since 1.0
		 * @return void
		 */
		public function register_widgets() {
			$defaults = array( 'Wip_Themes_About_Widget', 'Wip_Themes_Blog_Posts_Widget', 'Wip_Themes_Featured_Posts_Widget', 'Wip_Themes_FB_Likebox_Widget' );
			
			if ( 'yes' === get_option('wip_themes_core_no_featured_posts') ) {
				$defaults = array( 'Wip_Themes_About_Widget', 'Wip_Themes_Blog_Posts_Widget', 'Wip_Themes_FB_Likebox_Widget' );
			}

			$custom_widgets = apply_filters( 'wip_themes_core_custom_widgets', $defaults );
			
			if ( ! empty( $custom_widgets ) ) {
				foreach ( $custom_widgets as $widget_name ) {
					register_widget( $widget_name );
				}
				unset( $widget_name );
			}
		}

		/**
		 * Run**
		 *
		 * @access public
		 * @since 1.0
		 * @return void
		 */
		public function _run() {
			if ( ! current_theme_supports( 'wipthemes-brayn' ) ) {
				add_action( 'admin_notices', 'brayn_core_plugin_error_notice' );
				deactivate_plugins( BRAYN_CORE_FILE );
			}
		}
	}
}

Brayn_Core::instance();
