<?php
/**
 * Custom post types module helper
 *
 * @author WIP-Themes
 * @version 1.0
 */

// exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Class name : Brayn_Core_Cpt
if ( ! class_exists( 'Brayn_Core_Cpt' ) ) {
	class Brayn_Core_Cpt {
		/**
		 * var $instance
		 *
		 * @access private
		 * @since 1.0
		 */
		private static $instance;

		/**
		 * var $public
		 *
		 * @access private
		 * @since 1.0
		 */
		public $cpt_register = array();

		/**
		 * var $taxonomies_register
		 *
		 * @access public
		 * @since 1.0
		 */
		public $taxonomies_register = array();

		/**
		 * Brayn_Core_Cpt's instance
		 *
		 * @access public
		 * @since 1.0
		 * @return instance of Brayn_Core_Cpt
		 */
		public static function instance() {
			if ( ! isset( self::$instance ) && ! ( self::$instance instanceof Brayn_Core_Cpt ) ) {
				self::$instance = new Brayn_Core_Cpt;
				
				add_action( 'init', array( self::$instance, 'init' ) );
			}

			return self::$instance;
		}

		/**
		 * Throw error on object clone
		 *
		 * The whole idea of the singleton design pattern is that there is a single
		 * object therefore, we don't want the object to be cloned.
		 *
		 * @since 1.0
		 * @access protected
		 * @return void
		 */
		public function __clone() {
			// Cloning instances of the class is forbidden
			_doing_it_wrong( __FUNCTION__, __( 'Cheatin&#8217; huh?', 'brayn-core' ), '1.0' );
		}

		/**
		 * Module inits
		 *
		 * @access public
		 * @since 1.0
		 * @return void
		 */
		public function init() {
			self::$instance->custom_post_init();
			flush_rewrite_rules();
		}
		
		/**
		 * register the custom post type
		 *
		 * @access public
		 * @since 1.0
		 * @return void
		 */
		public static function register_custom_post_type( $cpt_name = null, $cpt_options = null ) {
			if ( empty( $cpt_name ) || empty( $cpt_options ) ) {
				return false;
			}
			self::$instance->cpt_register[$cpt_name] = $cpt_options;
		}

		/**
		 * register the custom taxonomy
		 *
		 * @access public
		 * @since 1.0
		 * @return void
		 */
		public static function register_taxonomy( $tax_name = null, $tax_options = null ) {
			if ( empty( $tax_name ) || empty( $tax_options ) ) {
				return false;
			}
			self::$instance->taxonomies_register[$tax_name] = $tax_options;
		}

		/**
		 * custom post and taxonomies creation
		 *
		 * @access public
		 * @since 1.0
		 * @return array
		 */
		public function custom_post_init() {
			// register post types
			if ( ! empty( $this->cpt_register ) ) {
				foreach ( $this->cpt_register as $cpt_name => $ui ) {
					if ( post_type_exists( $cpt_name ) ) 
						return;

					register_post_type( $cpt_name, $ui );
				}
				unset( $cpt_name );
				unset( $ui );
			}

			// register taxonomies
			if ( ! empty( $this->taxonomies_register ) ) {
				foreach ( $this->taxonomies_register as $tax_name => $var ) {
					$post_type = isset( $var['post_type_for'] ) ? $var['post_type_for'] : false;
					$ui = isset( $var['ui'] ) ? $var['ui'] : false;

					// no post type? well, taxonomy not live with ghost LOL
					if ( ! $post_type ) 
						return;

					// need ui
					if ( ! $ui ) 
						return;

					// call for CPT, but it actually not exists? leave em
					if ( ! post_type_exists( $post_type ) ) 
						return;

					// already registered.
					if ( taxonomy_exists( $tax_name ) )
						return;

					// register.
					register_taxonomy( $tax_name, $ui[0], $ui[1] );
				}
				unset( $tax_name );
				unset( $var );
			}
		}
	} // class 
}
// if class_exists

Brayn_Core_Cpt::instance();
