<?php
/**
 * custom elementor woocommerce featured products
 *
 * @package Elementor
 * @subpackage Brayn Core
 * @since 2.0.0
 */

use Elementor\Controls_Manager;

class Brayn_Elementor_Woocommerce_Featured_Widget extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * @since 2.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		$name = 'brayn-woo-featured';
		return $name;
	}

	/**
	 * Get widget title.
	 *
	 * @since 2.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Woo: Featured Products', 'brayn-core' );
	}

	/**
	 * Get widget icon.
	 *
	 * @since 2.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-product-rating';
	}

	/**
	 * Get widget categories.
	 *
	 * @since 2.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'brayn-theme' ];
	}

	/**
	 * Register widget controls.
	 *
	 * @since 2.0.0
	 * @access protected
	 */
	protected function _register_controls() {

		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__( 'Settings', 'brayn-core' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'number_post',
			[
				'label' => esc_html__( 'Number of products', 'brayn-core' ),
				'type' => Controls_Manager::TEXT,
				'input_type' => 'number',
				'placeholder' => '',
				'default' => 4,
				'description' => '',
			]
		);

		$this->add_control(
			'post_col',
			[
				'label' => esc_html__( 'Columns', 'brayn-core' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' =>['col'],
				'range' => [
					'col' => [
						'min' => 2,
						'max' => 6,
						'step' => 1,
					],
				],
				'default' =>[
					'unit' => 'col',
					'size' => 4,
				],
			]
		);

		$cats = brayn_core_taxonomies_options( 'product_cat', true );
		$this->add_control(
			'category',
			[
				'label' => esc_html__( 'Product category', 'brayn-core' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'all',
				'description' => '',
				'options' => $cats,
			]
		);

		$this->add_control(
			'orderby',
			[
				'label' => esc_html__( 'Order by', 'brayn-core' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'date',
				'description' => '',
				'options' => [
					'date'       => esc_html__( 'Published date', 'brayn-core' ),
					'menu_order' => esc_html__( 'The menu order', 'brayn-core' ),
					'popularity' => esc_html__( 'Number of sales', 'brayn-core' ),
					'rating'     => esc_html__( 'Average rating', 'brayn-core' ),
					'title'      => esc_html__( 'Product title', 'brayn-core' ),
					'rand'       => esc_html__( 'Random', 'brayn-core' ),
				],
			]
		);

		$this->add_control(
			'order',
			[
				'label' => __( 'Order', 'brayn-core' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'desc',
				'options' => [
					'asc' => __( 'ASC', 'brayn-core' ),
					'desc' => __( 'DESC', 'brayn-core' ),
				],
			]
		);

		$this->end_controls_section();
	}

	private function get_shortcode() {
		$settings = $this->get_settings();

		$attributes = [
			'limit' => $settings['number_post'],
			'columns' => $settings['post_col']['size'],
			'paginate' => false,
			'visibility' => 'featured',
			'orderby' => $settings['orderby'],
			'order' => $settings['order'],
		];

		if ( 'all' !== $settings['category'] ) {
			$attributes['category'] = $settings['category'];
		}
		
		$this->add_render_attribute( 'shortcode', $attributes );

		$shortcode = sprintf( '[products %s]', $this->get_render_attribute_string( 'shortcode' ) );

		return $shortcode;
	}

	/**
	 * Render widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 2.0.0
	 * @access protected
	 */
	public function render() {
		if ( ! brayn_core_woo_active() ) {
			return false;
		}
		echo do_shortcode( $this->get_shortcode() );
	}

	public function render_plain_content() {
		echo $this->get_shortcode();
	}
}
